/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.logviewer.Messages;
import org.netxms.ui.eclipse.logviewer.widgets.ConditionEditor;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ZoneSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ZoneConditionEditor
extends ConditionEditor {
    private static final String[] OPERATIONS;
    private static final String EMPTY_SELECTION_TEXT;
    private WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
    private int zoneUin = 0;
    private CLabel objectName;

    static {
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.ObjectConditionEditor_Is;
        Messages.get();
        stringArray[1] = Messages.ObjectConditionEditor_IsNot;
        OPERATIONS = stringArray;
        Messages.get();
        EMPTY_SELECTION_TEXT = Messages.ObjectConditionEditor_None;
    }

    public ZoneConditionEditor(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ZoneConditionEditor.this.labelProvider.dispose();
            }
        });
    }

    @Override
    protected String[] getOperations() {
        return OPERATIONS;
    }

    @Override
    protected void createContent(Composite parent, ColumnFilter initialFilter) {
        Composite group = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gd);
        this.objectName = new CLabel(group, 0);
        this.toolkit.adapt((Composite)this.objectName);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        this.objectName.setLayoutData((Object)gd);
        this.objectName.setText(EMPTY_SELECTION_TEXT);
        ImageHyperlink selectionLink = this.toolkit.createImageHyperlink(group, 0);
        selectionLink.setImage(SharedIcons.IMG_FIND);
        selectionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ZoneConditionEditor.this.selectObject();
            }
        });
        if (initialFilter != null) {
            if (initialFilter.getType() == ColumnFilterType.EQUALS) {
                this.setSelectedOperation(initialFilter.isNegated() ? 1 : 0);
                this.zoneUin = (int)initialFilter.getNumericValue();
            }
            if (this.zoneUin != 0) {
                Zone zone = ConsoleSharedData.getSession().findZone(this.zoneUin);
                if (zone != null) {
                    this.objectName.setText(zone.getObjectName());
                    this.objectName.setImage(this.labelProvider.getImage((Object)zone));
                } else {
                    this.objectName.setText("[" + this.zoneUin + "]");
                }
            }
        }
    }

    private void selectObject() {
        ZoneSelectionDialog dlg = new ZoneSelectionDialog(this.getShell());
        if (dlg.open() == 0) {
            this.zoneUin = dlg.getZoneUIN();
            if (this.zoneUin != 0) {
                this.objectName.setText(dlg.getZoneName());
                this.objectName.setImage(this.labelProvider.getImage((Object)ConsoleSharedData.getSession().findZone(this.zoneUin)));
            } else {
                this.objectName.setText(EMPTY_SELECTION_TEXT);
                this.objectName.setImage(null);
            }
        }
    }

    @Override
    public ColumnFilter createFilter() {
        int op = this.getSelectedOperation();
        ColumnFilter filter = new ColumnFilter(ColumnFilterType.EQUALS, (long)this.zoneUin);
        filter.setNegated(op == 1);
        return filter;
    }
}

