/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ObjectFigure;

public class ObjectStatusIcon
extends ObjectFigure {
    private static final int IMAGE_MARGIN_Y = 4;
    private static final int BACKGROUND_MARGIN_X = 4;
    private static final int BACKGROUND_MARGIN_Y = 4;
    private static final int FRAME_LINE_WIDTH = 3;
    private int imageWidth;
    private int imageHeight;

    public ObjectStatusIcon(NetworkMapObject element, MapLabelProvider labelProvider) {
        super(element, labelProvider);
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.setOpaque(false);
        this.updateSize(labelProvider);
    }

    private void updateSize(MapLabelProvider labelProvider) {
        Image image = labelProvider.getStatusImage(this.object);
        if (image != null) {
            this.imageWidth = image.getImageData().width;
            this.imageHeight = image.getImageData().height;
        } else {
            this.imageWidth = 32;
            this.imageHeight = 32;
        }
        this.setSize(this.imageWidth + 8 + 3, this.imageHeight + 8 + 3);
    }

    protected void paintFigure(Graphics gc) {
        Image image;
        gc.setAntialias(1);
        Rectangle rect = new Rectangle(this.getBounds());
        int imageOffset = (rect.width - this.imageWidth) / 2;
        if (this.isElementSelected()) {
            rect.x += imageOffset - 4;
            ++rect.y;
            rect.width = this.imageWidth + 8;
            rect.height = this.imageWidth + 8 - 1;
            gc.setForegroundColor(SELECTION_COLOR);
            gc.setLineWidth(3);
            gc.setLineStyle(this.labelProvider.isElementSelected((NetworkMapElement)this.element) ? 3 : 1);
            gc.drawRoundRectangle(rect, 16, 16);
            rect = new Rectangle(this.getBounds());
        }
        if ((image = this.labelProvider.getStatusImage(this.object)) != null) {
            gc.drawImage(image, rect.x + imageOffset, rect.y + 4);
        }
    }
}

