/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.widgets;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.base.GeoLocation;
import org.netxms.client.NXCSession;
import org.netxms.client.TimePeriod;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.osm.GeoLocationCache;
import org.netxms.ui.eclipse.osm.Messages;
import org.netxms.ui.eclipse.osm.tools.Area;
import org.netxms.ui.eclipse.osm.tools.QuadTree;
import org.netxms.ui.eclipse.osm.widgets.AbstractGeoMapViewer;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class GeoLocationHistoryViewer
extends AbstractGeoMapViewer
implements MouseTrackListener {
    private static final int START = 1;
    private static final int END = 2;
    private static final String[] pointInformation;
    private static final int LABEL_ARROW_OFFSET = 10;
    private static final Color LABEL_BACKGROUND;
    private static final Color LABEL_TEXT;
    private static final Color TRACK_COLOR;
    private AbstractObject historyObject = null;
    private List<GeoLocation> points = new ArrayList<GeoLocation>();
    private TimePeriod timePeriod = new TimePeriod();
    private ToolTip pointToolTip = null;
    private QuadTree<GeoLocation> locationTree = new QuadTree();
    private int selectedPoint = -1;

    static {
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.GeoMapViewer_Start;
        Messages.get();
        stringArray[1] = Messages.GeoMapViewer_End;
        pointInformation = stringArray;
        LABEL_BACKGROUND = new Color((Device)Display.getCurrent(), 240, 254, 192);
        LABEL_TEXT = new Color((Device)Display.getCurrent(), 0, 0, 0);
        TRACK_COLOR = new Color((Device)Display.getCurrent(), 163, 73, 164);
    }

    public GeoLocationHistoryViewer(Composite parent, int style, AbstractObject object) {
        super(parent, style);
        this.historyObject = object;
        this.pointToolTip = new ToolTip(this.getShell(), 4096);
        this.addMouseTrackListener(this);
    }

    @Override
    protected void onMapLoad() {
        this.updateHistory();
    }

    @Override
    protected void onCacheChange(AbstractObject object, GeoLocation prevLocation) {
        if (object.getObjectId() == this.historyObject.getObjectId()) {
            this.updateHistory();
        }
    }

    public void mouseHover(MouseEvent e) {
        this.selectedPoint = -1;
        this.pointToolTip.setVisible(false);
        List<GeoLocation> suitablePoints = this.getAdjacentLocations(e.x, e.y);
        if (suitablePoints.isEmpty()) {
            return;
        }
        this.selectedPoint = this.points.indexOf(suitablePoints.get(0));
        this.redraw();
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        this.selectedPoint = -1;
        this.pointToolTip.setVisible(false);
        this.redraw();
    }

    @Override
    public void mouseMove(MouseEvent e) {
        super.mouseMove(e);
        if (this.selectedPoint != -1) {
            this.selectedPoint = -1;
            this.pointToolTip.setVisible(false);
            this.redraw();
        }
    }

    public List<GeoLocation> getAdjacentLocations(Point p) {
        return this.getAdjacentLocations(p.x, p.y);
    }

    public List<GeoLocation> getAdjacentLocations(int x, int y) {
        Point p = new Point(x, y);
        final GeoLocation center = this.getLocationAtPoint(p);
        p.x -= 5;
        p.y -= 5;
        GeoLocation topLeft = this.getLocationAtPoint(p);
        p.x += 10;
        p.y += 10;
        GeoLocation bottomRight = this.getLocationAtPoint(p);
        Area area = new Area(topLeft.getLatitude(), topLeft.getLongitude(), bottomRight.getLatitude(), bottomRight.getLongitude());
        List<GeoLocation> locations = this.locationTree.query(area);
        Collections.sort(locations, new Comparator<GeoLocation>(){

            @Override
            public int compare(GeoLocation l1, GeoLocation l2) {
                double d1 = Math.pow(Math.pow(l1.getLatitude() - center.getLatitude(), 2.0) + Math.pow(l1.getLongitude() - center.getLongitude(), 2.0), 0.5);
                double d2 = Math.pow(Math.pow(l2.getLatitude() - center.getLatitude(), 2.0) + Math.pow(l2.getLongitude() - center.getLongitude(), 2.0), 0.5);
                return (int)Math.signum(d1 - d2);
            }
        });
        return locations;
    }

    private void updateHistory() {
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.GeoMapViewer_DownloadJob_Title, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.osm", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List pl = session.getLocationHistory(GeoLocationHistoryViewer.this.historyObject.getObjectId(), GeoLocationHistoryViewer.this.timePeriod.getPeriodStart(), GeoLocationHistoryViewer.this.timePeriod.getPeriodEnd());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        GeoLocationHistoryViewer.this.points = pl;
                        GeoLocationHistoryViewer.this.locationTree.removeAll();
                        int i = 0;
                        while (i < GeoLocationHistoryViewer.this.points.size()) {
                            GeoLocationHistoryViewer.this.locationTree.insert(((GeoLocation)GeoLocationHistoryViewer.this.points.get(i)).getLatitude(), ((GeoLocation)GeoLocationHistoryViewer.this.points.get(i)).getLongitude(), (GeoLocation)GeoLocationHistoryViewer.this.points.get(i));
                            ++i;
                        }
                        GeoLocationHistoryViewer.this.redraw();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.GeoMapViewer_DownloadError;
            }
        };
        job.setUser(false);
        job.start();
    }

    public void setTimePeriod(TimePeriod timePeriod) {
        this.timePeriod = timePeriod;
        this.updateHistory();
    }

    public TimePeriod getTimePeriod() {
        return this.timePeriod;
    }

    public void changeTimePeriod(int value, int unit) {
        this.timePeriod.setTimeFrameType(1);
        this.timePeriod.setTimeRangeValue(value);
        this.timePeriod.setTimeUnitValue(unit);
        this.updateHistory();
    }

    @Override
    protected void drawContent(GC gc, GeoLocation currentLocation, int imgW, int imgH) {
        Point centerXY = GeoLocationCache.coordinateToDisplay(currentLocation, this.accessor.getZoom());
        int nextX = 0;
        int nextY = 0;
        int i = 0;
        while (i < this.points.size()) {
            Point virtualXY = GeoLocationCache.coordinateToDisplay(this.points.get(i), this.accessor.getZoom());
            int dx = virtualXY.x - centerXY.x;
            int dy = virtualXY.y - centerXY.y;
            if (i != this.points.size() - 1) {
                Point virtualXY2 = GeoLocationCache.coordinateToDisplay(this.points.get(i + 1), this.accessor.getZoom());
                nextX = imgW / 2 + (virtualXY2.x - centerXY.x);
                nextY = imgH / 2 + (virtualXY2.y - centerXY.y);
            }
            int color = 3;
            if (i == this.selectedPoint) {
                color = 5;
                DateFormat df = RegionalSettings.getDateTimeFormat();
                this.pointToolTip.setText(String.format("%s\r\n%s - %s", this.points.get(i), df.format(this.points.get(i).getTimestamp()), df.format(this.points.get(i).getEndTimestamp())));
                this.pointToolTip.setVisible(true);
            }
            if (i == 0) {
                if (i == this.points.size() - 1) {
                    nextX = imgW / 2 + dx;
                    nextY = imgH / 2 + dy;
                }
                this.drawPoint(gc, imgW / 2 + dx, imgH / 2 + dy, 1, nextX, nextY, color);
            } else if (i == this.points.size() - 1) {
                this.drawPoint(gc, imgW / 2 + dx, imgH / 2 + dy, 2, nextX, nextY, color);
            } else {
                this.drawPoint(gc, imgW / 2 + dx, imgH / 2 + dy, 0, nextX, nextY, color);
            }
            ++i;
        }
    }

    private void drawPoint(GC gc, int x, int y, int flag, int prevX, int prevY, int color) {
        if (flag == 1 || flag == 2) {
            if (flag == 1) {
                gc.setForeground(TRACK_COLOR);
                gc.setLineWidth(3);
                gc.drawLine(x, y, prevX, prevY);
            }
            gc.setBackground(this.getDisplay().getSystemColor(color));
            gc.fillOval(x - 5, y - 5, 10, 10);
            String text = pointInformation[flag - 1];
            Point textSize = gc.textExtent(text);
            Rectangle rect = new Rectangle(x - 10, y - 5 - textSize.y, textSize.x + 8 + 4, textSize.y + 8);
            gc.setBackground(LABEL_BACKGROUND);
            gc.setForeground(BORDER_COLOR);
            gc.setLineWidth(4);
            gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            gc.setLineWidth(2);
            gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
            int[] arrow = new int[]{rect.x + 10 - 4, rect.y + rect.height, x, y, rect.x + 10 + 4, rect.y + rect.height};
            gc.setLineWidth(4);
            gc.setForeground(BORDER_COLOR);
            gc.drawPolyline(arrow);
            gc.fillPolygon(arrow);
            gc.setForeground(LABEL_BACKGROUND);
            gc.setLineWidth(2);
            gc.drawLine(arrow[0], arrow[1], arrow[4], arrow[5]);
            gc.drawPolyline(arrow);
            gc.setForeground(LABEL_TEXT);
            gc.drawText(text, rect.x + 4 + 4, rect.y + 4);
        } else {
            gc.setForeground(TRACK_COLOR);
            gc.setLineWidth(3);
            gc.drawLine(x, y, prevX, prevY);
            gc.setBackground(Display.getCurrent().getSystemColor(color));
            gc.fillOval(x - 5, y - 5, 10, 10);
        }
    }

    @Override
    public AbstractObject getObjectAtPoint(Point p) {
        return null;
    }
}

