/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.propertypages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.ServerAction;
import org.netxms.client.events.ActionExecutionConfiguration;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.ui.eclipse.epp.Messages;
import org.netxms.ui.eclipse.epp.dialogs.ActionExecutionConfigurationDialog;
import org.netxms.ui.eclipse.epp.dialogs.ActionSelectionDialog;
import org.netxms.ui.eclipse.epp.propertypages.helpers.ActionListLabelProvider;
import org.netxms.ui.eclipse.epp.widgets.RuleEditor;
import org.netxms.ui.eclipse.tools.ObjectLabelComparator;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class RuleServerActions
extends PropertyPage {
    private RuleEditor editor;
    private EventProcessingPolicyRule rule;
    private SortableTableViewer viewer;
    private Map<Long, ActionExecutionConfiguration> actions = new HashMap<Long, ActionExecutionConfiguration>();
    private Button addButton;
    private Button editButton;
    private Button deleteButton;

    protected Control createContents(Composite parent) {
        this.editor = (RuleEditor)((Object)this.getElement().getAdapter(RuleEditor.class));
        this.rule = this.editor.getRule();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] stringArray = new String[5];
        Messages.get();
        stringArray[0] = Messages.RuleServerActions_Action;
        stringArray[1] = "Delay";
        stringArray[2] = "Delay timer key";
        stringArray[3] = "Snooze time";
        stringArray[4] = "Snooze/blocking timer key";
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{300, 90, 200, 90, 200};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ActionListLabelProvider(this.editor.getEditorView()));
        this.viewer.setComparator((ViewerComparator)new ObjectLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = ((IStructuredSelection)RuleServerActions.this.viewer.getSelection()).size();
                RuleServerActions.this.deleteButton.setEnabled(size > 0);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RuleServerActions.this.editAction();
            }
        });
        for (ActionExecutionConfiguration c : this.rule.getActions()) {
            this.actions.put(c.getActionId(), new ActionExecutionConfiguration(c));
        }
        this.viewer.setInput((Object)this.actions.values().toArray());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        Messages.get();
        this.addButton.setText(Messages.RuleServerActions_Add);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                RuleServerActions.this.addAction();
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.editButton = new Button(buttons, 8);
        this.editButton.setText("&Edit...");
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                RuleServerActions.this.editAction();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.deleteButton = new Button(buttons, 8);
        Messages.get();
        this.deleteButton.setText(Messages.RuleServerActions_Delete);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                RuleServerActions.this.deleteAction();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        return dialogArea;
    }

    private void addAction() {
        ActionSelectionDialog dlg = new ActionSelectionDialog(this.getShell(), this.editor.getEditorView().getActions());
        dlg.enableMultiSelection(true);
        if (dlg.open() == 0) {
            ServerAction[] serverActionArray = dlg.getSelectedActions();
            int n = serverActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ServerAction a = serverActionArray[n2];
                this.actions.put(a.getId(), new ActionExecutionConfiguration(a.getId(), 0, 0, null, null));
                ++n2;
            }
        }
        this.viewer.setInput((Object)this.actions.values().toArray());
    }

    private void editAction() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        ActionExecutionConfigurationDialog dlg = new ActionExecutionConfigurationDialog(this.getShell(), (ActionExecutionConfiguration)selection.getFirstElement());
        if (dlg.open() == 0) {
            this.viewer.update(selection.getFirstElement(), null);
        }
    }

    private void deleteAction() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                ActionExecutionConfiguration a = (ActionExecutionConfiguration)it.next();
                this.actions.remove(a.getActionId());
            }
            this.viewer.setInput((Object)this.actions.values().toArray());
        }
    }

    private void doApply() {
        this.rule.setActions(new ArrayList<ActionExecutionConfiguration>(this.actions.values()));
        this.editor.setModified(true);
    }

    protected void performApply() {
        this.doApply();
    }

    public boolean performOk() {
        this.doApply();
        return super.performOk();
    }
}

