/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.jface.resource.JFaceResources;
import org.netxms.base.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.maps.MapObjectDisplayMode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Node;
import org.netxms.client.topology.RadioInterface;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.figures.BirtChartFigure;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.Activator;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.NodeLastValuesFigure;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectTooltip
extends Figure {
    private NodeLastValuesFigure lastValuesFigure = null;
    private int index;
    private AbstractObject object;
    private MapLabelProvider labelProvider;
    private long refreshTimestamp = 0L;

    public ObjectTooltip(AbstractObject object, MapLabelProvider labelProvider) {
        DciValue[] values;
        MacAddress mac;
        StringBuilder sb;
        this.object = object;
        this.labelProvider = labelProvider;
        this.setBorder((Border)new MarginBorder(3));
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        this.setLayoutManager((LayoutManager)layout);
        Label title = new Label();
        title.setIcon(labelProvider.getWorkbenchIcon(object));
        title.setText(object.getObjectName());
        title.setFont(JFaceResources.getBannerFont());
        this.add((IFigure)title);
        Label status = new Label();
        status.setIcon(StatusDisplayInfo.getStatusImage((ObjectStatus)object.getStatus()));
        status.setText(StatusDisplayInfo.getStatusText((ObjectStatus)object.getStatus()));
        this.add((IFigure)status);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        this.setConstraint((IFigure)status, gd);
        if (object instanceof Node) {
            if ((((Node)object).getCapabilities() & 0x800000) != 0) {
                if (((Node)object).getHardwareProductName() != null && !((Node)object).getHardwareProductName().isEmpty()) {
                    this.addInformationBlock(String.valueOf(((Node)object).getHardwareProductName()) + " (" + ((Node)object).getCipDeviceTypeName() + ")", null);
                } else {
                    this.addInformationBlock(((Node)object).getCipDeviceTypeName(), null);
                }
            } else {
                this.addInformationBlock(((Node)object).getHardwareProductName(), null);
            }
            this.addInformationBlock(((Node)object).getHardwareVendor(), "Vendor: ");
        }
        if (object instanceof Node && ((Node)object).getPrimaryIP().isValidAddress() && !((Node)object).getPrimaryIP().getAddress().isAnyLocalAddress()) {
            sb = new StringBuilder(((Node)object).getPrimaryIP().getHostAddress());
            mac = ((Node)object).getPrimaryMAC();
            if (mac != null) {
                sb.append(" (");
                sb.append(mac.toString());
                sb.append(')');
            }
            Label iface = new Label();
            iface.setIcon(SharedIcons.IMG_IP_ADDRESS);
            iface.setText(sb.toString());
            this.add((IFigure)iface);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)iface, gd);
        }
        this.index = this.getChildren().size();
        if (object instanceof Node && labelProvider.getObjectFigureType() == MapObjectDisplayMode.LARGE_LABEL && (values = labelProvider.getNodeLastValues(object.getObjectId())) != null && values.length > 0) {
            this.lastValuesFigure = new NodeLastValuesFigure(values);
            this.add((IFigure)this.lastValuesFigure);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)this.lastValuesFigure, gd);
        }
        if (object instanceof Container) {
            this.addStatusChart(object, labelProvider);
        }
        if (object instanceof AccessPoint) {
            sb = new StringBuilder(((AccessPoint)object).getModel());
            mac = ((AccessPoint)object).getMacAddress();
            if (mac != null) {
                sb.append('\n');
                sb.append(mac.toString());
            }
            RadioInterface[] radioInterfaceArray = ((AccessPoint)object).getRadios();
            int n = radioInterfaceArray.length;
            int n2 = 0;
            while (n2 < n) {
                RadioInterface rif = radioInterfaceArray[n2];
                Messages.get();
                sb.append(Messages.ObjectTooltip_Radio);
                sb.append(rif.getIndex());
                sb.append(" (");
                sb.append(rif.getMacAddress().toString());
                Messages.get();
                sb.append(Messages.ObjectTooltip_Channel);
                sb.append(rif.getChannel());
                Messages.get();
                sb.append(Messages.ObjectTooltip_TXPower);
                sb.append(rif.getPowerMW());
                Messages.get();
                sb.append(Messages.ObjectTooltip_mW);
                ++n2;
            }
            Label info = new Label();
            info.setText(sb.toString());
            this.add((IFigure)info);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)info, gd);
        }
        if (!object.getComments().isEmpty()) {
            FlowPage page = new FlowPage();
            this.add((IFigure)page);
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.setConstraint((IFigure)page, gd);
            TextFlow text = new TextFlow();
            text.setText("\n" + object.getComments());
            page.add((IFigure)text);
        }
    }

    public void refresh() {
        long now = System.currentTimeMillis();
        if (now < this.refreshTimestamp + 15000L) {
            return;
        }
        this.refreshTimestamp = now;
        if (this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.LARGE_LABEL) {
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        final long nodeId = this.object.getObjectId();
        ConsoleJob job = new ConsoleJob("Get DCI data for object tooltip", null, "org.netxms.ui.eclipse.networkmaps", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    final DciValue[] values = session.getLastValues(nodeId, false, true, false);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ObjectTooltip.this.object instanceof Node && values != null && values.length > 0) {
                                if (ObjectTooltip.this.lastValuesFigure != null) {
                                    ObjectTooltip.this.remove((IFigure)ObjectTooltip.this.lastValuesFigure);
                                }
                                ObjectTooltip.this.lastValuesFigure = new NodeLastValuesFigure(values);
                                GridData gd = new GridData();
                                gd.horizontalSpan = 2;
                                ObjectTooltip.this.add((IFigure)ObjectTooltip.this.lastValuesFigure, gd, ObjectTooltip.this.index);
                                ObjectTooltip.this.layout();
                                ObjectTooltip.this.labelProvider.getViewer().resizeToolTipShell();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Activator.logError("Exception while reading data for object tooltip", e);
                }
            }

            protected String getErrorMessage() {
                return null;
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    private void addInformationBlock(String text, String prefix) {
        if (text == null || text.isEmpty()) {
            return;
        }
        Label info = new Label();
        info.setText(prefix != null ? String.valueOf(prefix) + text : text);
        this.add((IFigure)info);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.setConstraint((IFigure)info, gd);
    }

    private void addStatusChart(AbstractObject object, MapLabelProvider labelProvider) {
        BirtChartFigure chart = new BirtChartFigure(0, labelProvider.getColors());
        this.add((IFigure)chart);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        gd.heightHint = 180;
        gd.widthHint = 320;
        this.setConstraint((IFigure)chart, gd);
        int[] objectCount = new int[6];
        this.collectData(objectCount, object);
        chart.setTitleVisible(true);
        Messages.get();
        chart.setChartTitle(Messages.ObjectTooltip_ChartTitle);
        chart.setLegendPosition(2);
        chart.setLegendVisible(true);
        chart.set3DModeEnabled(true);
        chart.setTransposed(false);
        chart.setTranslucent(false);
        chart.setBorder((Border)new LineBorder());
        int i = 0;
        while (i <= ObjectStatus.UNKNOWN.getValue()) {
            chart.addParameter(new GraphItem(0L, 0L, DataOrigin.INTERNAL, DataType.INT32, StatusDisplayInfo.getStatusText((int)i), StatusDisplayInfo.getStatusText((int)i), "%s"), (double)objectCount[i]);
            chart.setPaletteEntry(i, new ChartColor(StatusDisplayInfo.getStatusColor((int)i).getRGB()));
            ++i;
        }
        chart.initializationComplete();
    }

    private void collectData(int[] objectCount, AbstractObject root) {
        for (AbstractObject o : root.getAllChildren(2)) {
            if (o.getStatus().compareTo((Enum)ObjectStatus.UNKNOWN) > 0) continue;
            int n = o.getStatus().getValue();
            objectCount[n] = objectCount[n] + 1;
        }
    }
}

