/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.dialogs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.objectbrowser.widgets.ZoneSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.topology.Activator;
import org.netxms.ui.eclipse.topology.Messages;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EnterIpAddressDlg
extends Dialog {
    private LabeledText ipAddressText;
    private ZoneSelector zoneSelector;
    private InetAddress ipAddress;
    private long zoneUIN;
    private boolean zoningEnabled = ConsoleSharedData.getSession().isZoningEnabled();

    public EnterIpAddressDlg(Shell parent) {
        super(parent);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.EnterIpAddressDlg_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.ipAddressText = new LabeledText(dialogArea, 0);
        Messages.get();
        this.ipAddressText.setLabel(Messages.EnterIpAddressDlg_IpAddress);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.ipAddressText.setLayoutData((Object)gd);
        if (this.zoningEnabled) {
            this.zoneSelector = new ZoneSelector(dialogArea, 0, false);
            Messages.get();
            this.zoneSelector.setLabel(Messages.EnterIpAddressDlg_Zone);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = 300;
            this.zoneSelector.setLayoutData((Object)gd);
            IDialogSettings settings = Activator.getDefault().getDialogSettings();
            try {
                int uin = settings.getInt("IPAddressSelection.ZoneUIN");
                if (ConsoleSharedData.getSession().findZone(uin) != null) {
                    this.zoneSelector.setZoneUIN(uin);
                }
            }
            catch (Exception e) {
                this.zoneSelector.setZoneUIN(0);
            }
        }
        return dialogArea;
    }

    protected void okPressed() {
        try {
            this.ipAddress = InetAddress.getByName(this.ipAddressText.getText());
        }
        catch (UnknownHostException e) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.EnterIpAddressDlg_Warning, (String)Messages.EnterIpAddressDlg_EnterValidAddress);
            return;
        }
        if (this.zoningEnabled) {
            this.zoneUIN = this.zoneSelector.getZoneUIN();
            IDialogSettings settings = Activator.getDefault().getDialogSettings();
            settings.put("IPAddressSelection.ZoneUIN", this.zoneUIN);
        } else {
            this.zoneUIN = 0L;
        }
        super.okPressed();
    }

    public long getZoneId() {
        return this.zoneUIN;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }
}

