/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.actions;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.netxms.client.constants.ColumnFilterSetOperation;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.log.LogFilter;
import org.netxms.client.log.OrderingColumn;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.ui.eclipse.logviewer.Messages;
import org.netxms.ui.eclipse.logviewer.views.LogViewer;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ShowObjectEvents
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        ISelection selection = window.getActivePage().getSelection();
        if (selection == null || !(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        ColumnFilter cf = new ColumnFilter();
        cf.setOperation(ColumnFilterSetOperation.OR);
        for (Object o : ((IStructuredSelection)selection).toList()) {
            if (!(o instanceof AbstractObject)) continue;
            cf.addSubFilter(new ColumnFilter(o instanceof AbstractNode ? ColumnFilterType.EQUALS : ColumnFilterType.CHILDOF, ((AbstractObject)o).getObjectId()));
            if (!(o instanceof Cluster)) continue;
            cf.addSubFilter(new ColumnFilter(ColumnFilterType.EQUALS, ((AbstractObject)o).getObjectId()));
        }
        try {
            LogViewer view = (LogViewer)window.getActivePage().showView("org.netxms.ui.eclipse.logviewer.view.log_viewer", "EventLog", 1);
            LogFilter filter = new LogFilter();
            filter.setColumnFilter("event_source", cf);
            ArrayList<OrderingColumn> orderingColumns = new ArrayList<OrderingColumn>(1);
            Messages.get();
            orderingColumns.add(new OrderingColumn("event_timestamp", Messages.ShowObjectEvents_Time, true));
            filter.setOrderingColumns(orderingColumns);
            view.queryWithFilter(filter);
        }
        catch (PartInitException e) {
            Shell shell = window.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ShowObjectEvents_Error, (String)String.format(Messages.ShowObjectEvents_CannotOpenLogViewer, e.getMessage()));
        }
        return null;
    }
}

