/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.views;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.netxms.base.Glob;
import org.netxms.base.InetAddressEx;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.ObjectFilter;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.NetworkService;
import org.netxms.client.objects.Sensor;
import org.netxms.client.objects.VPNConnector;
import org.netxms.client.objects.Zone;
import org.netxms.client.objects.ZoneMember;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.objectbrowser.Activator;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectbrowser.views.helpers.ObjectSearchResultComparator;
import org.netxms.ui.eclipse.objectbrowser.views.helpers.ObjectSearchResultLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.CommandBridge;
import org.netxms.ui.eclipse.tools.ComparatorHelper;
import org.netxms.ui.eclipse.tools.FilteringMenuManager;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;
import org.netxms.ui.eclipse.widgets.LabeledText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ObjectFinder
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objectbrowser.views.ObjectFinder";
    public static final int COL_ID = 0;
    public static final int COL_CLASS = 1;
    public static final int COL_NAME = 2;
    public static final int COL_IP_ADDRESS = 3;
    public static final int COL_PARENT = 4;
    public static final int COL_ZONE = 5;
    private static final int SEARCH_MODE_NORMAL = 0;
    private static final int SEARCH_MODE_PATTERN = 1;
    private static final int SEARCH_MODE_REGEXP = 2;
    private static final String[] OBJECT_ATTRIBUTES = new String[]{"adminState", "agentVersion", "alarms", "alias", "bootTime", "bridgeBaseAddress", "bridgePortNumber", "city", "comments", "components", "country", "customAttributes", "description", "dot1xBackendAuthState", "dot1xPaeAuthState", "driver", "expectedState", "flags", "geolocation", "guid", "id", "ifIndex", "ifType", "ipAddr", "ipAddressList", "ipNetMask", "isAgent", "isBridge", "isCDP", "isExcludedFromTopology", "isLLDP", "isLocalManagement", "isLoopback", "isManuallyCreated", "isPAE", "isPhysicalPort", "isPrinter", "isRouter", "isSMCLP", "isSNMP", "isSONMP", "isSTP", "macAddr", "mapImage", "mtu", "name", "node", "nodes", "operState", "peerInterface", "peerNode", "platformName", "port", "postcode", "proxyNode", "proxyNodeId", "responsibleUsers", "runtimeFlags", "snmpOID", "snmpSysContact", "snmpSysLocation", "snmpSysName", "snmpVersion", "slot", "speed", "status", "streetAddress", "sysDescription", "type", "uin", "zone", "zoneUIN"};
    private static final String[] OBJECT_CONSTANTS = new String[]{"ACCESSPOINT", "AGENTPOLICY", "AGENTPOLICY_CONFIG", "AGENTPOLICY_LOGPARSER", "BUSINESSSERVICE", "BUSINESSSERVICEROOT", "CHASSIS", "CLUSTER", "CONDITION", "CONTAINER", "DASHBOARD", "DASHBOARDGROUP", "DASHBOARDROOT", "INTERFACE", "MOBILEDEVICE", "NETWORK", "NETWORKMAP", "NETWORKMAPGROUP", "NETWORKMAPROOT", "NETWORKSERVICE", "NODE", "NODELINK", "POLICYGROUP", "POLICYROOT", "RACK", "SENSOR", "SERVICEROOT", "SLMCHECK", "SUBNET", "TEMPLATE", "TEMPLATEGROUP", "TEMPLATEROOT", "VPNCONNECTOR", "ZONE"};
    private static final List<ObjectClass> OBJECT_CLASSES = new ArrayList<ObjectClass>();
    private SortableTableViewer results;
    private CTabFolder tabFolder;
    private LabeledText text;
    private Button radioPlainText;
    private Button radioPattern;
    private Button radioRegularExpression;
    private CheckboxTableViewer classList;
    private CheckboxTableViewer zoneList;
    private Text ipRangeStart;
    private Text ipRangeEnd;
    private CompositeWithMessageBar queryEditorMessage;
    private ScriptEditor queryEditor;
    private Action actionStartSearch;
    private Action actionShowObjectDetails;
    private NXCSession session;

    static {
        OBJECT_CLASSES.add(new ObjectClass(33, "Access Point"));
        OBJECT_CLASSES.add(new ObjectClass(28, "Business Service"));
        OBJECT_CLASSES.add(new ObjectClass(27, "Business Service Root"));
        OBJECT_CLASSES.add(new ObjectClass(35, "Chassis"));
        OBJECT_CLASSES.add(new ObjectClass(14, "Cluster"));
        OBJECT_CLASSES.add(new ObjectClass(13, "Condition"));
        OBJECT_CLASSES.add(new ObjectClass(5, "Container"));
        OBJECT_CLASSES.add(new ObjectClass(23, "Dashboard"));
        OBJECT_CLASSES.add(new ObjectClass(22, "Dashboard Root"));
        OBJECT_CLASSES.add(new ObjectClass(3, "Interface"));
        OBJECT_CLASSES.add(new ObjectClass(31, "Mobile Device"));
        OBJECT_CLASSES.add(new ObjectClass(4, "Network"));
        OBJECT_CLASSES.add(new ObjectClass(21, "Network Map"));
        OBJECT_CLASSES.add(new ObjectClass(20, "Network Map Group"));
        OBJECT_CLASSES.add(new ObjectClass(19, "Network Map Root"));
        OBJECT_CLASSES.add(new ObjectClass(11, "Network Service"));
        OBJECT_CLASSES.add(new ObjectClass(2, "Node"));
        OBJECT_CLASSES.add(new ObjectClass(29, "Node Link"));
        OBJECT_CLASSES.add(new ObjectClass(32, "Rack"));
        OBJECT_CLASSES.add(new ObjectClass(37, "Sensor"));
        OBJECT_CLASSES.add(new ObjectClass(7, "Service Root"));
        OBJECT_CLASSES.add(new ObjectClass(30, "Service Check"));
        OBJECT_CLASSES.add(new ObjectClass(1, "Subnet"));
        OBJECT_CLASSES.add(new ObjectClass(8, "Template"));
        OBJECT_CLASSES.add(new ObjectClass(9, "Template Group"));
        OBJECT_CLASSES.add(new ObjectClass(10, "Template Root"));
        OBJECT_CLASSES.add(new ObjectClass(12, "VPN Connector"));
        OBJECT_CLASSES.add(new ObjectClass(6, "Zone"));
    }

    public void createPartControl(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.tabFolder = new CTabFolder(parent, 0x800082);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, false));
        CTabItem filterTab = new CTabItem(this.tabFolder, 0);
        filterTab.setText("Filter");
        filterTab.setImage(SharedIcons.IMG_FILTER);
        Composite conditionGroup = new Composite((Composite)this.tabFolder, 0);
        layout = new GridLayout();
        layout.numColumns = this.session.isZoningEnabled() ? 3 : 2;
        conditionGroup.setLayout((Layout)layout);
        filterTab.setControl((Control)conditionGroup);
        Composite fullTextSearchGroup = new Composite(conditionGroup, 0);
        fullTextSearchGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        layout = new GridLayout();
        fullTextSearchGroup.setLayout((Layout)layout);
        this.text = new LabeledText(fullTextSearchGroup, 0);
        this.text.setLabel("Search string");
        this.text.setLayoutData((Object)new GridData(4, 128, true, false));
        TraverseListener traverseListener = new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    ObjectFinder.this.startSearch();
                }
            }
        };
        this.text.addTraverseListener(traverseListener);
        Group searchModeGroup = new Group(fullTextSearchGroup, 0);
        searchModeGroup.setText("Search mode");
        layout = new GridLayout();
        searchModeGroup.setLayout((Layout)layout);
        this.radioPlainText = new Button((Composite)searchModeGroup, 16);
        this.radioPlainText.setText("&Normal");
        this.radioPlainText.setSelection(true);
        this.radioPattern = new Button((Composite)searchModeGroup, 16);
        this.radioPattern.setText("&Pattern (* = any string, ? = any character)");
        this.radioRegularExpression = new Button((Composite)searchModeGroup, 16);
        this.radioRegularExpression.setText("&Regular expression");
        Composite classFilterGroup = new Composite(conditionGroup, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.verticalSpan = 2;
        classFilterGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        classFilterGroup.setLayout((Layout)layout);
        Label classFilterTitle = new Label(classFilterGroup, 0);
        classFilterTitle.setText("Class filter");
        this.classList = CheckboxTableViewer.newCheckList((Composite)classFilterGroup, (int)2080);
        this.classList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.classList.setInput(OBJECT_CLASSES);
        this.classList.setAllChecked(true);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 100;
        this.classList.getTable().setLayoutData((Object)gd);
        Composite classListButtons = new Composite(classFilterGroup, 0);
        RowLayout rlayout = new RowLayout();
        rlayout.marginLeft = 0;
        classListButtons.setLayout((Layout)rlayout);
        Button selectAll = new Button(classListButtons, 8);
        selectAll.setText("Select &all");
        RowData rd = new RowData();
        rd.width = 90;
        selectAll.setLayoutData((Object)rd);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectFinder.this.classList.setAllChecked(true);
            }
        });
        Button clearAll = new Button(classListButtons, 8);
        clearAll.setText("&Clear all");
        rd = new RowData();
        rd.width = 90;
        clearAll.setLayoutData((Object)rd);
        clearAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectFinder.this.classList.setAllChecked(false);
            }
        });
        if (this.session.isZoningEnabled()) {
            Composite zoneFilterGroup = new Composite(conditionGroup, 0);
            gd = new GridData(4, 4, true, true);
            gd.verticalSpan = 2;
            zoneFilterGroup.setLayoutData((Object)gd);
            layout = new GridLayout();
            zoneFilterGroup.setLayout((Layout)layout);
            Label zoneFilterTitle = new Label(zoneFilterGroup, 0);
            zoneFilterTitle.setText("Zone filter");
            this.zoneList = CheckboxTableViewer.newCheckList((Composite)zoneFilterGroup, (int)2080);
            this.zoneList.setContentProvider((IContentProvider)new ArrayContentProvider());
            List zones = this.session.getAllZones();
            this.zoneList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.zoneList.setInput((Object)zones);
            this.zoneList.setAllChecked(true);
            gd = new GridData(4, 4, true, true);
            gd.heightHint = 100;
            this.zoneList.getTable().setLayoutData((Object)gd);
            Composite zoneListButtons = new Composite(zoneFilterGroup, 0);
            rlayout = new RowLayout();
            rlayout.marginLeft = 0;
            zoneListButtons.setLayout((Layout)rlayout);
            selectAll = new Button(zoneListButtons, 8);
            selectAll.setText("Select &all");
            rd = new RowData();
            rd.width = 90;
            selectAll.setLayoutData((Object)rd);
            selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ObjectFinder.this.zoneList.setAllChecked(true);
                }
            });
            clearAll = new Button(zoneListButtons, 8);
            clearAll.setText("&Clear all");
            rd = new RowData();
            rd.width = 90;
            clearAll.setLayoutData((Object)rd);
            clearAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ObjectFinder.this.zoneList.setAllChecked(false);
                }
            });
        }
        Group ipFilterGroup = new Group(conditionGroup, 0);
        ipFilterGroup.setText("IP Range");
        ipFilterGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        layout = new GridLayout();
        layout.numColumns = 3;
        ipFilterGroup.setLayout((Layout)layout);
        this.ipRangeStart = new Text((Composite)ipFilterGroup, 2048);
        this.ipRangeStart.setLayoutData((Object)new GridData(4, 4, true, false));
        this.ipRangeStart.addTraverseListener(traverseListener);
        new Label((Composite)ipFilterGroup, 0).setText(" - ");
        this.ipRangeEnd = new Text((Composite)ipFilterGroup, 2048);
        this.ipRangeEnd.setLayoutData((Object)new GridData(4, 4, true, false));
        this.ipRangeEnd.addTraverseListener(traverseListener);
        Button searchButtonFilter = new Button(conditionGroup, 8);
        searchButtonFilter.setText("&Search");
        gd = new GridData(16384, 1024, true, false);
        gd.widthHint = 90;
        searchButtonFilter.setLayoutData((Object)gd);
        searchButtonFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ObjectFinder.this.startSearch();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        CTabItem queryTab = new CTabItem(this.tabFolder, 0);
        queryTab.setText("Query");
        queryTab.setImage(SharedIcons.IMG_FIND);
        Composite queryArea = new Composite((Composite)this.tabFolder, 0);
        layout = new GridLayout();
        queryArea.setLayout((Layout)layout);
        queryTab.setControl((Control)queryArea);
        this.queryEditorMessage = new CompositeWithMessageBar(queryArea, 2048);
        this.queryEditorMessage.setLayoutData((Object)new GridData(4, 4, true, true));
        this.queryEditor = new ScriptEditor((Composite)this.queryEditorMessage, 0, 2, true);
        this.queryEditorMessage.setContent((Composite)this.queryEditor);
        this.queryEditor.addVariables(Arrays.asList(OBJECT_ATTRIBUTES));
        this.queryEditor.addConstants(Arrays.asList(OBJECT_CONSTANTS));
        Button searchButtonQuery = new Button(queryArea, 8);
        searchButtonQuery.setText("&Search");
        gd = new GridData(16384, 1024, true, false);
        gd.widthHint = 90;
        searchButtonQuery.setLayoutData((Object)gd);
        searchButtonQuery.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ObjectFinder.this.startQuery();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        String[] names = new String[]{"ID", "Class", "Name", "IP Address", "Parent", "Zone"};
        int[] widths = new int[]{90, 120, 300, 250, 300, 200};
        this.results = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        if (!ConsoleSharedData.getSession().isZoningEnabled()) {
            this.results.removeColumnById(5);
        }
        this.results.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.results.setLabelProvider((IBaseLabelProvider)new ObjectSearchResultLabelProvider());
        this.results.setComparator((ViewerComparator)new ObjectSearchResultComparator());
        this.results.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.results, (IDialogSettings)settings, (String)"ResultTable");
        this.results.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ObjectFinder.this.results, (IDialogSettings)settings, (String)"ResultTable");
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.results);
        this.createResultsContextMenu();
        this.activateContext();
        this.createActions();
        this.contributeToActionBars();
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = ObjectFinder.this.tabFolder.getSelectionIndex();
                switch (index) {
                    case 0: {
                        ObjectFinder.this.text.setFocus();
                        break;
                    }
                    case 1: {
                        ObjectFinder.this.queryEditor.setFocus();
                    }
                }
                settings.put("ObjectFinder.selectedTab", index);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        try {
            this.tabFolder.setSelection(settings.getInt("ObjectFinder.selectedTab"));
        }
        catch (NumberFormatException e) {
            this.tabFolder.setSelection(0);
        }
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.objectbrowser.context.ObjectFinder");
        }
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionStartSearch = new Action("&Search", Activator.getImageDescriptor("icons/find.gif")){

            public void run() {
                int i = ObjectFinder.this.tabFolder.getSelectionIndex();
                if (i == 0) {
                    ObjectFinder.this.startSearch();
                } else if (i == 1) {
                    ObjectFinder.this.startQuery();
                }
            }
        };
        this.actionStartSearch.setId("org.netxms.ui.eclipse.objectbrowser.actions.startSearch");
        this.actionStartSearch.setActionDefinitionId("org.netxms.ui.eclipse.objectbrowser.commands.start_search");
        ActionHandler showFilterHandler = new ActionHandler((IAction)this.actionStartSearch);
        handlerService.activateHandler(this.actionStartSearch.getActionDefinitionId(), (IHandler)showFilterHandler);
        this.actionShowObjectDetails = new Action("Show object details"){

            public void run() {
                ObjectFinder.this.showObjectDetails();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionStartSearch);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionStartSearch);
    }

    private void createResultsContextMenu() {
        FilteringMenuManager manager = new FilteringMenuManager("org.netxms.ui.eclipse.objectbrowser");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectContextMenu.fill(mgr, (IShellProvider)ObjectFinder.this.getSite(), (ISelectionProvider)ObjectFinder.this.results);
                if (((IStructuredSelection)ObjectFinder.this.results.getSelection()).size() == 1) {
                    mgr.insertAfter("properties", (IAction)ObjectFinder.this.actionShowObjectDetails);
                }
            }
        });
        Menu menu = manager.createContextMenu((Control)this.results.getTable());
        this.results.getTable().setMenu(menu);
        this.getSite().registerContextMenu((MenuManager)manager, (ISelectionProvider)this.results);
    }

    public void setFocus() {
        switch (this.tabFolder.getSelectionIndex()) {
            case 0: {
                this.text.setFocus();
                break;
            }
            case 1: {
                this.queryEditor.setFocus();
            }
        }
    }

    private void startQuery() {
        final NXCSession session = ConsoleSharedData.getSession();
        final String query = this.queryEditor.getText();
        new ConsoleJob("Query objects", (IWorkbenchPart)this, "org.netxms.ui.eclipse.objectbrowser", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                if (!session.areObjectsSynchronized()) {
                    session.syncObjects();
                }
                try {
                    final List objects = session.queryObjects(query);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ObjectFinder.this.queryEditorMessage.hideMessage();
                            ObjectFinder.this.results.setInput((Object)objects);
                            ObjectFinder.this.queryEditor.setFocus();
                        }
                    });
                }
                catch (NXCException e) {
                    if (e.getErrorCode() == 117 || e.getErrorCode() == 118) {
                        final String errorMessage = e.getAdditionalInfo();
                        this.runInUIThread(new Runnable(){

                            @Override
                            public void run() {
                                ObjectFinder.this.queryEditorMessage.showMessage(1, errorMessage);
                            }
                        });
                    }
                    throw e;
                }
            }

            protected String getErrorMessage() {
                return "Object query failed";
            }
        }.start();
    }

    private void startSearch() {
        InetAddress addrStart = null;
        InetAddress addrEnd = null;
        if (!this.ipRangeStart.getText().trim().isEmpty() && !this.ipRangeEnd.getText().trim().isEmpty()) {
            try {
                addrStart = InetAddress.getByName(this.ipRangeStart.getText().trim());
            }
            catch (UnknownHostException e) {
                MessageDialogHelper.openWarning((Shell)this.getSite().getShell(), (String)"Warning", (String)"IP address range start is invalid");
            }
            try {
                addrEnd = InetAddress.getByName(this.ipRangeEnd.getText().trim());
            }
            catch (UnknownHostException e) {
                MessageDialogHelper.openWarning((Shell)this.getSite().getShell(), (String)"Warning", (String)"IP address range end is invalid");
            }
        }
        ArrayList<Integer> classFilter = new ArrayList<Integer>();
        Object[] objectArray = this.classList.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            classFilter.add(((ObjectClass)o).classId);
            ++n2;
        }
        ArrayList<Integer> zoneFilter = new ArrayList<Integer>();
        if (this.session.isZoningEnabled()) {
            Object[] objectArray2 = this.zoneList.getCheckedElements();
            int n3 = objectArray2.length;
            n = 0;
            while (n < n3) {
                Object o = objectArray2[n];
                zoneFilter.add(((Zone)o).getUIN());
                ++n;
            }
        }
        if (this.radioRegularExpression.getSelection()) {
            this.doSearch(this.text.getText().trim(), 2, classFilter, zoneFilter, addrStart, addrEnd);
        } else {
            this.doSearch(this.text.getText().trim().toLowerCase(), this.radioPattern.getSelection() ? 1 : 0, classFilter, zoneFilter, addrStart, addrEnd);
        }
    }

    private void doSearch(final String searchString, final int mode, final List<Integer> classFilter, final List<Integer> zoneFilter, final InetAddress addrStart, final InetAddress addrEnd) {
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Find objects", (IWorkbenchPart)this, "org.netxms.ui.eclipse.objectbrowser", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                if (!session.areObjectsSynchronized()) {
                    session.syncObjects();
                }
                final Pattern regexp = mode == 2 ? Pattern.compile(searchString, 98) : null;
                final List objects = session.filterObjects(new ObjectFilter(){

                    public boolean filter(AbstractObject object) {
                        if (session.isZoningEnabled() && session.getAllZones().size() != zoneFilter.size()) {
                            AbstractNode parent;
                            ZoneMember node;
                            if (object instanceof ZoneMember && !zoneFilter.contains((node = (ZoneMember)object).getZoneId())) {
                                return false;
                            }
                            if (object instanceof Sensor) {
                                AbstractNode proxy = (AbstractNode)session.findObjectById(((Sensor)object).getProxyId(), AbstractNode.class);
                                if (proxy != null && zoneFilter.contains(proxy.getZoneId())) {
                                    return false;
                                }
                            } else if (object instanceof Interface) {
                                parent = ((Interface)object).getParentNode();
                                if (parent != null && !zoneFilter.contains(parent.getZoneId())) {
                                    return false;
                                }
                            } else if (object instanceof NetworkService) {
                                parent = ((NetworkService)object).getParentNode();
                                if (parent != null && !zoneFilter.contains(parent.getZoneId())) {
                                    return false;
                                }
                            } else if (object instanceof VPNConnector) {
                                parent = ((VPNConnector)object).getParentNode();
                                if (parent != null && !zoneFilter.contains(parent.getZoneId())) {
                                    return false;
                                }
                            } else if (object instanceof AccessPoint) {
                                parent = ((AccessPoint)object).getParentNode();
                                if (parent != null && !zoneFilter.contains(parent.getZoneId())) {
                                    return false;
                                }
                            } else if (object instanceof GenericObject && !zoneFilter.isEmpty()) {
                                AbstractObject[] children = ((GenericObject)object).getChildrenAsArray();
                                boolean match = false;
                                AbstractObject[] abstractObjectArray = children;
                                int n = children.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    AbstractObject o = abstractObjectArray[n2];
                                    if (o instanceof ZoneMember && zoneFilter.contains(((ZoneMember)o).getZoneId())) {
                                        match = true;
                                    }
                                    ++n2;
                                }
                                if (!match) {
                                    return false;
                                }
                            }
                        }
                        if (!classFilter.contains(object.getObjectClass())) {
                            return false;
                        }
                        if (addrStart != null && addrEnd != null && !ObjectFinder.checkAddrRange(addrStart, addrEnd, object)) {
                            return false;
                        }
                        if (searchString.isEmpty()) {
                            return true;
                        }
                        for (String s : object.getStrings()) {
                            switch (mode) {
                                case 0: {
                                    if (!s.toLowerCase().contains(searchString)) break;
                                    return true;
                                }
                                case 1: {
                                    if (!Glob.match((String)searchString, (String)s.toLowerCase())) break;
                                    return true;
                                }
                                case 2: {
                                    if (!regexp.matcher(s).find()) break;
                                    return true;
                                }
                            }
                        }
                        return false;
                    }
                });
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ObjectFinder.this.results.setInput((Object)objects);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Object search failure";
            }
        }.start();
    }

    private static boolean checkAddrRange(InetAddress start, InetAddress end, AbstractObject object) {
        ArrayList<InetAddressEx> addrList = new ArrayList<InetAddressEx>(16);
        if (object instanceof AbstractNode) {
            addrList.add(((AbstractNode)object).getPrimaryIP());
            for (AbstractObject o : object.getAllChildren(3)) {
                addrList.addAll(((Interface)o).getIpAddressList());
            }
        } else if (object instanceof Interface) {
            addrList.addAll(((Interface)object).getIpAddressList());
        } else if (object instanceof AccessPoint) {
            addrList.add(((AccessPoint)object).getIpAddress());
        }
        for (InetAddressEx a : addrList) {
            if (ComparatorHelper.compareInetAddresses((InetAddress)a.getAddress(), (InetAddress)start) < 0 || ComparatorHelper.compareInetAddresses((InetAddress)a.getAddress(), (InetAddress)end) > 0) continue;
            return true;
        }
        return false;
    }

    private void showObjectDetails() {
        IStructuredSelection selection = (IStructuredSelection)this.results.getSelection();
        if (selection.size() != 1) {
            return;
        }
        AbstractObject object = (AbstractObject)selection.getFirstElement();
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.netxms.ui.eclipse.objectview.view.tabbed_object_view");
            CommandBridge.getInstance().execute("TabbedObjectView/changeObject", (Object)object.getObjectId());
        }
        catch (PartInitException e) {
            MessageDialogHelper.openError((Shell)this.getSite().getShell(), (String)"Error", (String)String.format("Cannot open object details view (%s)", e.getLocalizedMessage()));
        }
    }

    private static class ObjectClass {
        int classId;
        String className;

        ObjectClass(int classId, String className) {
            this.classId = classId;
            this.className = className;
        }

        public String toString() {
            return this.className;
        }
    }
}

