/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IAxisSet;
import org.swtchart.internal.ChartLayoutData;
import org.swtchart.internal.ChartTitle;
import org.swtchart.internal.Legend;
import org.swtchart.internal.PlotArea;
import org.swtchart.internal.axis.Axis;
import org.swtchart.internal.axis.AxisTickLabels;
import org.swtchart.internal.axis.AxisTickMarks;
import org.swtchart.internal.axis.AxisTitle;

public class ChartLayout
extends Layout {
    private int titleHeight;
    private int titleWidth;
    private int legendWidth;
    private int legendHeight;
    private int bottomAxisHeight;
    private int topAxisHeight;
    private int leftAxisWidth;
    private int rightAxisWidth;
    private ChartTitle title;
    private Legend legend;
    private PlotArea plot;
    private List<Axis> axes;
    private int bottomAxisOffset = 0;
    private int topAxisOffset = 0;
    private int leftAxisOffset = 0;
    private int rightAxisOffset = 0;
    public static final int MARGIN = 5;
    public static final int PADDING = 5;

    public ChartLayout() {
        this.initWidgetSizeVariables();
        this.axes = new ArrayList<Axis>();
    }

    private void initWidgetSizeVariables() {
        this.titleHeight = 0;
        this.titleWidth = 0;
        this.bottomAxisHeight = 0;
        this.topAxisHeight = 0;
        this.leftAxisWidth = 0;
        this.rightAxisWidth = 0;
        this.legendWidth = 0;
        this.legendHeight = 0;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return new Point(wHint, hHint);
    }

    protected void layout(Composite composite, boolean flushCache) {
        if (!this.parseControls(composite)) {
            return;
        }
        this.initWidgetSizeVariables();
        this.computeControlSize();
        Rectangle r = composite.getClientArea();
        this.layoutTitle(r);
        this.layoutLegend(r);
        this.layoutPlot(r);
        this.layoutAxes(r);
    }

    private boolean parseControls(Composite composite) {
        IAxisSet axisSet;
        Control[] children = composite.getChildren();
        this.axes.clear();
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Legend) {
                this.legend = (Legend)child;
            } else if (child instanceof ChartTitle) {
                this.title = (ChartTitle)child;
            } else if (child instanceof PlotArea) {
                this.plot = (PlotArea)child;
            }
            ++n2;
        }
        if (composite instanceof Chart && (axisSet = ((Chart)composite).getAxisSet()) != null) {
            IAxis[] axisArray;
            IAxis[] iAxisArray = axisArray = axisSet.getAxes();
            int n3 = axisArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAxis axis = iAxisArray[n4];
                this.axes.add((Axis)axis);
                ++n4;
            }
        }
        return this.title != null && this.legend != null && this.plot != null && this.axes.size() >= 2;
    }

    private void computeControlSize() {
        this.titleWidth = ((ChartLayoutData)this.title.getLayoutData()).widthHint;
        this.titleHeight = ((ChartLayoutData)this.title.getLayoutData()).heightHint;
        this.legendWidth = ((ChartLayoutData)this.legend.getLayoutData()).widthHint;
        this.legendHeight = ((ChartLayoutData)this.legend.getLayoutData()).heightHint;
        for (Axis axis : this.axes) {
            AxisLayoutData layoutData = new AxisLayoutData(axis);
            if (layoutData.titleLayoutdata == null || layoutData.tickLabelsLayoutdata == null || layoutData.tickMarksLayoutdata == null) continue;
            IAxis.Position position = axis.getPosition();
            if (position == IAxis.Position.Primary && axis.isHorizontalAxis()) {
                this.bottomAxisHeight += layoutData.titleLayoutdata.heightHint + layoutData.tickLabelsLayoutdata.heightHint + layoutData.tickMarksLayoutdata.heightHint;
                continue;
            }
            if (position == IAxis.Position.Secondary && axis.isHorizontalAxis()) {
                this.topAxisHeight += layoutData.titleLayoutdata.heightHint + layoutData.tickLabelsLayoutdata.heightHint + layoutData.tickMarksLayoutdata.heightHint;
                continue;
            }
            if (position == IAxis.Position.Primary && !axis.isHorizontalAxis()) {
                this.leftAxisWidth += layoutData.titleLayoutdata.widthHint + layoutData.tickLabelsLayoutdata.widthHint + layoutData.tickMarksLayoutdata.widthHint;
                continue;
            }
            if (position != IAxis.Position.Secondary || axis.isHorizontalAxis()) continue;
            this.rightAxisWidth += layoutData.titleLayoutdata.widthHint + layoutData.tickLabelsLayoutdata.widthHint + layoutData.tickMarksLayoutdata.widthHint;
        }
    }

    private void layoutTitle(Rectangle r) {
        int x = (int)((double)(r.width - this.titleWidth) / 2.0);
        int y = 5;
        int width = this.titleWidth;
        int height = this.titleHeight;
        this.title.setBounds(x, y, width, height);
    }

    private void layoutLegend(Rectangle r) {
        int y;
        int x;
        int legendPosition = this.legend.getPosition();
        int tHeight = this.titleHeight + (this.titleHeight == 0 ? 0 : 5);
        if (legendPosition == 131072) {
            x = r.width - this.legendWidth - 5;
            y = tHeight;
        } else if (legendPosition == 16384) {
            x = 5;
            y = tHeight;
        } else if (legendPosition == 128) {
            x = 5;
            y = tHeight + 5;
        } else if (legendPosition == 1024) {
            x = 5;
            y = r.height - this.legendHeight - 5;
        } else {
            throw new IllegalStateException();
        }
        int width = this.legendWidth;
        int height = this.legendHeight;
        if (y < tHeight) {
            y = tHeight;
        }
        this.legend.setBounds(x, y, width, height);
    }

    private void layoutPlot(Rectangle r) {
        int legendPosition = this.legend.getPosition();
        int x = this.leftAxisWidth + 5 + (legendPosition == 16384 ? this.legendWidth + (this.legendWidth == 0 ? 0 : 5) : 0);
        int y = this.titleHeight + this.topAxisHeight + 5 + (this.titleHeight == 0 ? 0 : 5) + (legendPosition == 128 ? this.legendHeight + (this.legendHeight == 0 ? 0 : 5) : 0);
        int width = r.width - this.leftAxisWidth - this.rightAxisWidth - (legendPosition == 16384 || legendPosition == 131072 ? this.legendWidth + (this.legendWidth == 0 ? 0 : 5) : 0) - 10;
        int height = r.height - this.bottomAxisHeight - this.topAxisHeight - this.titleHeight - 10 - (this.titleHeight == 0 ? 0 : 5) - (legendPosition == 128 || legendPosition == 1024 ? this.legendHeight + (this.legendHeight == 0 ? 0 : 5) : 0);
        this.plot.setBounds(x, y, width, height);
    }

    private void layoutAxes(Rectangle r) {
        this.bottomAxisOffset = 0;
        this.topAxisOffset = 0;
        this.leftAxisOffset = 0;
        this.rightAxisOffset = 0;
        for (Axis axis : this.axes) {
            AxisLayoutData layoutData = new AxisLayoutData(axis);
            if (layoutData.titleLayoutdata == null || layoutData.tickLabelsLayoutdata == null || layoutData.tickMarksLayoutdata == null) continue;
            IAxis.Position position = axis.getPosition();
            if (position == IAxis.Position.Primary && axis.isHorizontalAxis()) {
                this.layoutBottomAxis(r, layoutData);
                continue;
            }
            if (position == IAxis.Position.Secondary && axis.isHorizontalAxis()) {
                this.layoutTopAxis(r, layoutData);
                continue;
            }
            if (position == IAxis.Position.Primary && !axis.isHorizontalAxis()) {
                this.layoutLeftAxis(r, layoutData);
                continue;
            }
            if (position != IAxis.Position.Secondary || axis.isHorizontalAxis()) continue;
            this.layoutRightAxis(r, layoutData);
        }
    }

    private void layoutBottomAxis(Rectangle r, AxisLayoutData layoutData) {
        int legendPosition = this.legend.getPosition();
        int width = r.width - this.leftAxisWidth - this.rightAxisWidth - (legendPosition == 16384 || legendPosition == 131072 ? this.legendWidth + (this.legendWidth == 0 ? 0 : 5) : 0) - 10;
        int height = layoutData.titleLayoutdata.heightHint;
        int x = this.leftAxisWidth + 5 + (legendPosition == 16384 ? this.legendWidth + (this.legendWidth == 0 ? 0 : 5) : 0);
        int y = r.height - height - this.bottomAxisOffset - 5 - (legendPosition == 1024 ? this.legendHeight + (this.legendHeight == 0 ? 0 : 5) : 0);
        this.bottomAxisOffset += height;
        if (y - layoutData.tickLabelsLayoutdata.heightHint - layoutData.tickMarksLayoutdata.heightHint < this.titleHeight + (this.titleHeight == 0 ? 0 : 5)) {
            y = this.titleHeight + (this.titleHeight == 0 ? 0 : 5) + layoutData.tickLabelsLayoutdata.heightHint + layoutData.tickMarksLayoutdata.heightHint;
        }
        width = width > 0 ? width : 0;
        layoutData.axisTitle.setBounds(x, y, width, height);
        height = layoutData.tickLabelsLayoutdata.heightHint;
        this.bottomAxisOffset += height;
        layoutData.axisTickLabels.setBounds(0, y -= height, r.width, height);
        height = layoutData.tickMarksLayoutdata.heightHint;
        this.bottomAxisOffset += height;
        layoutData.axisTickMarks.setBounds(x, y -= height, width, height);
    }

    private void layoutTopAxis(Rectangle r, AxisLayoutData layoutData) {
        int legendPosition = this.legend.getPosition();
        int width = r.width - this.leftAxisWidth - this.rightAxisWidth - (legendPosition == 16384 || legendPosition == 131072 ? this.legendWidth + (this.legendWidth == 0 ? 0 : 5) : 0) - 10;
        int height = layoutData.titleLayoutdata.heightHint;
        int x = this.leftAxisWidth + 5 + (legendPosition == 16384 ? this.legendWidth + (this.legendWidth == 0 ? 0 : 5) : 0);
        int y = this.titleHeight + this.topAxisOffset + 5 + (this.titleHeight == 0 ? 0 : 5);
        this.topAxisOffset += height;
        width = width > 0 ? width : 0;
        layoutData.axisTitle.setBounds(x, y, width, height);
        y += height;
        height = layoutData.tickLabelsLayoutdata.heightHint;
        this.topAxisOffset += height;
        layoutData.axisTickLabels.setBounds(0, y, r.width, height);
        y += height;
        height = layoutData.tickMarksLayoutdata.heightHint;
        this.topAxisOffset += height;
        layoutData.axisTickMarks.setBounds(x, y, width, height);
    }

    private void layoutLeftAxis(Rectangle r, AxisLayoutData layoutData) {
        int legendPosition = this.legend.getPosition();
        int yAxisMargin = 10;
        int width = layoutData.titleLayoutdata.widthHint;
        int height = r.height - this.bottomAxisHeight - this.topAxisHeight - this.titleHeight - 10 - (this.titleHeight == 0 ? 0 : 5) - (legendPosition == 128 || legendPosition == 1024 ? this.legendHeight + (this.legendHeight == 0 ? 0 : 5) : 0);
        int x = 5 + this.leftAxisOffset + (legendPosition == 16384 ? this.legendWidth + (this.legendWidth == 0 ? 0 : 5) : 0);
        int y = this.titleHeight + this.topAxisHeight + 5 + (this.titleHeight == 0 ? 0 : 5) + (legendPosition == 128 ? this.legendHeight + (this.legendHeight == 0 ? 0 : 5) : 0);
        this.leftAxisOffset += width;
        height = height > 0 ? height : 0;
        layoutData.axisTitle.setBounds(x, y, width, height);
        x += width;
        width = layoutData.tickLabelsLayoutdata.widthHint;
        this.leftAxisOffset += width;
        layoutData.axisTickLabels.setBounds(x, y - yAxisMargin, width, height + yAxisMargin * 2);
        x += width;
        width = layoutData.tickMarksLayoutdata.widthHint;
        this.leftAxisOffset += width;
        layoutData.axisTickMarks.setBounds(x, y, width, height);
    }

    private void layoutRightAxis(Rectangle r, AxisLayoutData layoutData) {
        int legendPosition = this.legend.getPosition();
        int yAxisMargin = 10;
        int width = layoutData.titleLayoutdata.widthHint;
        int height = r.height - this.bottomAxisHeight - this.topAxisHeight - this.titleHeight - 10 - (this.titleHeight == 0 ? 0 : 5) - (legendPosition == 128 || legendPosition == 1024 ? this.legendHeight + (this.legendHeight == 0 ? 0 : 5) : 0);
        int x = r.width - width - this.rightAxisOffset - 5 - (legendPosition == 131072 ? this.legendWidth + (this.legendWidth == 0 ? 0 : 5) : 0);
        int y = this.titleHeight + this.topAxisHeight + 5 + (this.titleHeight == 0 ? 0 : 5) + (legendPosition == 128 ? this.legendHeight + (this.legendHeight == 0 ? 0 : 5) : 0);
        this.rightAxisOffset += width;
        height = height > 0 ? height : 0;
        layoutData.axisTitle.setBounds(x, y, width, height);
        width = layoutData.tickLabelsLayoutdata.widthHint;
        this.rightAxisOffset += width;
        layoutData.axisTickLabels.setBounds(x -= width, y - yAxisMargin, width, height + yAxisMargin * 2);
        width = layoutData.tickMarksLayoutdata.widthHint;
        this.rightAxisOffset += width;
        layoutData.axisTickMarks.setBounds(x -= width, y, width, height);
    }

    private static class AxisLayoutData {
        public AxisTickMarks axisTickMarks;
        public AxisTickLabels axisTickLabels;
        public AxisTitle axisTitle;
        public ChartLayoutData titleLayoutdata;
        public ChartLayoutData tickLabelsLayoutdata;
        public ChartLayoutData tickMarksLayoutdata;

        public AxisLayoutData(Axis axis) {
            this.axisTickMarks = axis.getTick().getAxisTickMarks();
            this.axisTickLabels = axis.getTick().getAxisTickLabels();
            this.axisTitle = (AxisTitle)axis.getTitle();
            this.titleLayoutdata = (ChartLayoutData)this.axisTitle.getLayoutData();
            this.tickLabelsLayoutdata = this.axisTickLabels.getLayoutData();
            this.tickMarksLayoutdata = this.axisTickMarks.getLayoutData();
        }
    }
}

