/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.ui.eclipse.agentmanager.dialogs.SendUserAgentNotificationDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class SendUserAgentNotification
implements IObjectActionDelegate {
    private Shell shell;
    private ViewPart viewPart;
    private Set<Long> objects = null;

    public void run(IAction action) {
        final NXCSession session = ConsoleSharedData.getSession();
        final SendUserAgentNotificationDialog dlg = new SendUserAgentNotificationDialog(this.shell);
        if (dlg.open() == 0) {
            new ConsoleJob("Create user agent notification job", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.agentmanager", null){

                protected String getErrorMessage() {
                    return "Failed to create user agent notification";
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    session.createUserAgentNotification(dlg.getMessage(), (Collection)SendUserAgentNotification.this.objects, dlg.getStartTime(), dlg.getEndTime(), dlg.isStartupNotification());
                }
            }.start();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean isEnabled = true;
        HashSet<Long> tmp = new HashSet<Long>();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            for (Object obj : ((IStructuredSelection)selection).toList()) {
                if (obj instanceof AbstractNode && ((AbstractNode)obj).hasAgent() || obj instanceof Container || obj instanceof ServiceRoot || obj instanceof Rack || obj instanceof Cluster) {
                    tmp.add(((AbstractObject)obj).getObjectId());
                    continue;
                }
                isEnabled = false;
                break;
            }
        } else {
            isEnabled = false;
        }
        action.setEnabled(isEnabled);
        if (isEnabled) {
            this.objects = tmp;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.viewPart = targetPart instanceof ViewPart ? (ViewPart)targetPart : null;
    }
}

