/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.dialogs;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.usermanager.Messages;
import org.netxms.ui.eclipse.usermanager.dialogs.helpers.UserListFilter;
import org.netxms.ui.eclipse.usermanager.dialogs.helpers.UserListLabelProvider;

public class SelectUserDialog
extends Dialog {
    private Text filterText;
    private TableViewer userList;
    private NXCSession session;
    private Class<? extends AbstractUserObject> classFilter;
    private boolean multiSelection = true;
    private AbstractUserObject[] selection;
    private UserListFilter filter;

    public SelectUserDialog(Shell parentShell, Class<? extends AbstractUserObject> classFilter) {
        super(parentShell);
        this.classFilter = classFilter;
    }

    public void enableMultiSelection(boolean enable) {
        this.multiSelection = enable;
    }

    protected void configureShell(Shell newShell) {
        Messages.get();
        newShell.setText(Messages.SelectUserDialog_Title);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.filterText = new Text(dialogArea, 2048);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.filterText.setLayoutData((Object)gd);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectUserDialog.this.filter.setFilter(SelectUserDialog.this.filterText.getText());
                SelectUserDialog.this.userList.refresh(false);
            }
        });
        Label label = new Label(dialogArea, 0);
        Messages.get();
        label.setText(Messages.SelectUserDialog_AvailableUsers);
        this.userList = new TableViewer(dialogArea, 0x800 | (this.multiSelection ? 2 : 0) | 0x10000);
        this.userList.setContentProvider((IContentProvider)new ArrayContentProvider());
        final UserListLabelProvider labelProvider = new UserListLabelProvider();
        this.userList.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.userList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String s1 = labelProvider.getText(e1);
                String s2 = labelProvider.getText(e2);
                return s1.compareToIgnoreCase(s2);
            }
        });
        this.userList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (SelectUserDialog.this.getButton(0).isEnabled()) {
                    SelectUserDialog.this.okPressed();
                }
            }
        });
        this.userList.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return SelectUserDialog.this.classFilter.isInstance(element) || element instanceof String;
            }
        });
        this.userList.setInput((Object)this.session.getUserDatabaseObjects());
        this.filter = new UserListFilter();
        this.userList.addFilter((ViewerFilter)this.filter);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        gd.widthHint = 600;
        this.userList.getControl().setLayoutData((Object)gd);
        return dialogArea;
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        this.getUsersAndRefresh();
        return content;
    }

    private void getUsersAndRefresh() {
        if (this.session.isUserDatabaseSynchronized()) {
            return;
        }
        this.userList.setInput((Object)new String[]{"Loading..."});
        this.getButton(0).setEnabled(false);
        ConsoleJob job = new ConsoleJob("Synchronize users", null, "org.netxms.ui.eclipse.usermanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                SelectUserDialog.this.session.syncUserDatabase();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SelectUserDialog.this.userList.setInput((Object)SelectUserDialog.this.session.getUserDatabaseObjects());
                        SelectUserDialog.this.getButton(0).setEnabled(true);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot synchronize users";
            }
        };
        job.setUser(false);
        job.start();
    }

    protected void okPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.userList.getSelection();
        if (sel.size() == 0) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.SelectUserDialog_Warning, (String)Messages.SelectUserDialog_WarningText);
            return;
        }
        this.selection = new AbstractUserObject[sel.size()];
        Iterator it = sel.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.selection[i] = (AbstractUserObject)it.next();
            ++i;
        }
        super.okPressed();
    }

    public AbstractUserObject[] getSelection() {
        return this.selection;
    }
}

