/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.SshKeyPair;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EditSshKeysDialog
extends Dialog {
    private LabeledText textName;
    private LabeledText publicKey;
    private LabeledText privateKey;
    private Button replaceKeysButton;
    private SshKeyPair key;
    private boolean isNew;

    public EditSshKeysDialog(Shell shell, SshKeyPair key) {
        super(shell);
        if (key == null) {
            this.key = new SshKeyPair();
            this.isNew = true;
        } else {
            this.key = key;
            this.isNew = false;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.textName = new LabeledText(dialogArea, 0);
        this.textName.setLabel("Name");
        this.textName.setText(this.key.getName());
        this.textName.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textName.setLayoutData((Object)gd);
        if (!this.isNew) {
            this.replaceKeysButton = new Button(dialogArea, 32);
            this.replaceKeysButton.setText("Replace keys");
            this.replaceKeysButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    EditSshKeysDialog.this.publicKey.setEditable(EditSshKeysDialog.this.replaceKeysButton.getSelection());
                    EditSshKeysDialog.this.privateKey.setEditable(EditSshKeysDialog.this.replaceKeysButton.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        this.publicKey = new LabeledText(dialogArea, 0, 2626);
        this.publicKey.setLabel("Public keys (Optional)");
        this.publicKey.setText(this.key.getPublicKey());
        this.publicKey.setEditable(this.isNew);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.heightHint = 200;
        gd.widthHint = 600;
        gd.verticalAlignment = 4;
        this.publicKey.setLayoutData((Object)gd);
        this.privateKey = new LabeledText(dialogArea, 0, 2626);
        this.privateKey.setLabel("Private keys");
        this.privateKey.setText("");
        this.privateKey.setEditable(this.isNew);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.heightHint = 200;
        gd.widthHint = 600;
        gd.verticalAlignment = 4;
        this.privateKey.setLayoutData((Object)gd);
        return dialogArea;
    }

    public SshKeyPair getSshKeyData() {
        return this.key;
    }

    protected void okPressed() {
        if (this.textName.getText().isEmpty() || (this.isNew || this.replaceKeysButton.getSelection()) && (this.publicKey.getText().isEmpty() || this.privateKey.getText().isEmpty())) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"All fields should be filled");
            return;
        }
        this.key.setName(this.textName.getText());
        if (this.isNew || this.replaceKeysButton.getSelection()) {
            this.key.setKeys(this.publicKey.getText(), this.privateKey.getText());
        }
        super.okPressed();
    }
}

