/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.ScheduledTask;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ScheduleTableEntryComparator
extends ViewerComparator {
    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        ScheduledTask task1 = (ScheduledTask)e1;
        ScheduledTask task2 = (ScheduledTask)e2;
        switch ((Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID")) {
            case 0: {
                result = (int)(task1.getId() - task2.getId());
                break;
            }
            case 1: {
                result = task1.getTaskHandlerId().compareToIgnoreCase(task2.getTaskHandlerId());
                break;
            }
            case 2: {
                AbstractObject obj1 = ConsoleSharedData.getSession().findObjectById(task1.getObjectId());
                AbstractObject obj2 = ConsoleSharedData.getSession().findObjectById(task2.getObjectId());
                String name1 = obj1 != null ? obj1.getObjectName() : "Unknown";
                String name2 = obj2 != null ? obj2.getObjectName() : "Unknown";
                result = name1.compareToIgnoreCase(name2);
                break;
            }
            case 3: {
                result = task1.getParameters().compareToIgnoreCase(task2.getParameters());
                break;
            }
            case 4: {
                if (task1.getSchedule().isEmpty()) {
                    if (task2.getSchedule().isEmpty()) {
                        result = task1.getExecutionTime().compareTo(task2.getExecutionTime());
                        break;
                    }
                    result = 1;
                    break;
                }
                if (task2.getSchedule().isEmpty()) {
                    result = -1;
                }
                result = task1.getSchedule().compareToIgnoreCase(task2.getSchedule());
                break;
            }
            case 5: {
                result = task1.getLastExecutionTime().compareTo(task2.getLastExecutionTime());
                break;
            }
            case 6: {
                result = task1.getStatus().compareToIgnoreCase(task2.getStatus());
                break;
            }
            case 8: {
                AbstractUserObject user;
                String user1 = "";
                String user2 = "";
                if ((task1.getFlags() & 8) > 0) {
                    user1 = "Internal";
                } else {
                    user = ConsoleSharedData.getSession().findUserDBObjectById(task1.getOwner(), null);
                    String string = user1 = user != null ? user.getName() : "[" + Long.toString(task1.getOwner()) + "]";
                }
                user2 = (task2.getFlags() & 8) > 0 ? "Internal" : ((user = ConsoleSharedData.getSession().findUserDBObjectById(task2.getOwner(), null)) != null ? user.getName() : "[" + Long.toString(task1.getOwner()) + "]");
                result = user1.compareTo(user2);
                break;
            }
            case 9: {
                result = task1.getComments().compareToIgnoreCase(task2.getComments());
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

