/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import org.netxms.base.NXCPMessage;

public class ActionExecutionConfiguration {
    private long actionId;
    private int timerDelay;
    private int snoozeTime;
    private String timerKey;
    private String blockingTimerKey;

    ActionExecutionConfiguration(long actionId) {
        this.actionId = actionId;
        this.timerDelay = 0;
        this.snoozeTime = 0;
        this.timerKey = null;
        this.blockingTimerKey = null;
    }

    public ActionExecutionConfiguration(long actionId, int timerDelay, int snoozeTime, String timerKey, String blockingTimerKey) {
        this.actionId = actionId;
        this.timerDelay = timerDelay;
        this.snoozeTime = snoozeTime;
        this.timerKey = timerKey;
        this.blockingTimerKey = blockingTimerKey;
    }

    protected ActionExecutionConfiguration(NXCPMessage msg, long baseId) {
        this.actionId = msg.getFieldAsInt64(baseId);
        this.timerDelay = msg.getFieldAsInt32(baseId + 1L);
        this.timerKey = msg.getFieldAsString(baseId + 2L);
        this.blockingTimerKey = msg.getFieldAsString(baseId + 3L);
        this.snoozeTime = msg.getFieldAsInt32(baseId + 4L);
    }

    public ActionExecutionConfiguration(ActionExecutionConfiguration src) {
        this.actionId = src.actionId;
        this.timerDelay = src.timerDelay;
        this.snoozeTime = src.snoozeTime;
        this.timerKey = src.timerKey;
        this.blockingTimerKey = src.blockingTimerKey;
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setFieldInt32(baseId, (int)this.actionId);
        msg.setFieldInt32(baseId + 1L, this.timerDelay);
        msg.setField(baseId + 2L, this.timerKey);
        msg.setField(baseId + 3L, this.blockingTimerKey);
        msg.setFieldInt32(baseId + 4L, this.snoozeTime);
    }

    public int getTimerDelay() {
        return this.timerDelay;
    }

    public void setTimerDelay(int timerDelay) {
        this.timerDelay = timerDelay;
    }

    public String getTimerKey() {
        return this.timerKey != null ? this.timerKey : "";
    }

    public void setTimerKey(String timerKey) {
        this.timerKey = timerKey;
    }

    public long getActionId() {
        return this.actionId;
    }

    public String getBlockingTimerKey() {
        return this.blockingTimerKey != null ? this.blockingTimerKey : "";
    }

    public void setBlockingTimerKey(String blockingTimerKey) {
        this.blockingTimerKey = blockingTimerKey;
    }

    public int getSnoozeTime() {
        return this.snoozeTime;
    }

    public void setSnoozeTime(int snoozeTime) {
        this.snoozeTime = snoozeTime;
    }
}

