/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.dialogs;

import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.NotificationChannel;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class SendNotificationDialog
extends Dialog {
    private String recipient = Activator.getDefault().getDialogSettings().get("SendNotification.PhoneNumber");
    private String subject;
    private String message;
    private String channelName;
    private Combo channelNameCombo;
    private LabeledText recipientField;
    private LabeledText subjectField;
    private LabeledText messageField;
    private List<NotificationChannel> channels = null;

    public SendNotificationDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Send Notification");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.channelNameCombo = WidgetHelper.createLabeledCombo(dialogArea, 8, "Channel name", gd);
        this.channelNameCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SendNotificationDialog.this.recipientField.setEnabled(((NotificationChannel)((SendNotificationDialog)SendNotificationDialog.this).channels.get((int)((SendNotificationDialog)SendNotificationDialog.this).channelNameCombo.getSelectionIndex())).getConfigurationTemplate().needRecipient);
                SendNotificationDialog.this.subjectField.setEnabled(((NotificationChannel)((SendNotificationDialog)SendNotificationDialog.this).channels.get((int)((SendNotificationDialog)SendNotificationDialog.this).channelNameCombo.getSelectionIndex())).getConfigurationTemplate().needSubject);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.recipientField = new LabeledText(dialogArea, 0);
        this.recipientField.setLabel("Recipient");
        this.recipientField.setText(this.recipient);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.recipientField.setLayoutData(gd);
        this.subjectField = new LabeledText(dialogArea, 0);
        this.subjectField.setLabel("Subject");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.subjectField.setLayoutData(gd);
        this.messageField = new LabeledText(dialogArea, 0);
        this.messageField.setLabel("Message");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.messageField.setLayoutData(gd);
        if (this.recipient != null && !this.recipient.isEmpty()) {
            this.messageField.getTextControl().setFocus();
        }
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Get list of notification channels", null, "org.netxms.ui.eclipse.console", null){

            @Override
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                SendNotificationDialog.this.channels = session.getNotificationChannels();
                SendNotificationDialog.this.channels.sort(new Comparator<NotificationChannel>(){

                    @Override
                    public int compare(NotificationChannel o1, NotificationChannel o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SendNotificationDialog.this.updateChannelSelector();
                    }
                });
            }

            @Override
            protected String getErrorMessage() {
                return "Cannot get notificationchannels";
            }
        }.start();
        return dialogArea;
    }

    private void updateChannelSelector() {
        this.channelNameCombo.removeAll();
        int i = 0;
        while (i < this.channels.size()) {
            NotificationChannel nc = this.channels.get(i);
            this.channelNameCombo.add(nc.getName());
            ++i;
        }
    }

    protected void okPressed() {
        this.recipient = this.recipientField.getText().trim();
        this.subject = this.subjectField.getText();
        this.message = this.messageField.getText();
        this.channelName = this.channelNameCombo.getItem(this.channelNameCombo.getSelectionIndex());
        Activator.getDefault().getDialogSettings().put("SendNotification.PhoneNumber", this.recipient);
        super.okPressed();
    }

    public String getRecipient() {
        return this.recipient;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getChannelName() {
        return this.channelName;
    }
}

