/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.ui.eclipse.console.dialogs.KeyValuePairEditDialog;
import org.netxms.ui.eclipse.tools.ObjectLabelComparator;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;
import org.netxms.ui.eclipse.widgets.helpers.AttributeLabelProvider;

public class SetEditor
extends Composite {
    private SortableTableViewer viewerSetValue;
    private Button addSetValueButton;
    private Button editSetValueButton;
    private Button removeSetValueButton;
    private Map<String, String> pStorageSet = new HashMap<String, String>();

    public SetEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        String[] setColumnNames = new String[]{"Key", "Value"};
        int[] setColumnWidths = new int[]{150, 200};
        this.viewerSetValue = new SortableTableViewer(this, setColumnNames, setColumnWidths, 0, 128, 67586);
        this.viewerSetValue.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewerSetValue.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        this.viewerSetValue.setComparator(new ObjectLabelComparator((ILabelProvider)this.viewerSetValue.getLabelProvider()));
        this.viewerSetValue.setInput(this.pStorageSet.entrySet().toArray());
        this.viewerSetValue.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = ((IStructuredSelection)SetEditor.this.viewerSetValue.getSelection()).size();
                SetEditor.this.editSetValueButton.setEnabled(size == 1);
                SetEditor.this.removeSetValueButton.setEnabled(size > 0);
            }
        });
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.viewerSetValue.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite((Composite)this, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        this.addSetValueButton = new Button(buttons, 8);
        this.addSetValueButton.setText("Add");
        this.addSetValueButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SetEditor.this.addPStorageSetAction();
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.addSetValueButton.setLayoutData((Object)rd);
        this.editSetValueButton = new Button(buttons, 8);
        this.editSetValueButton.setText("Edit");
        this.editSetValueButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SetEditor.this.editPStorageSetAction();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.editSetValueButton.setLayoutData((Object)rd);
        this.editSetValueButton.setEnabled(false);
        this.removeSetValueButton = new Button(buttons, 8);
        this.removeSetValueButton.setText("Delete");
        this.removeSetValueButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SetEditor.this.deletePStorageSetAction();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.removeSetValueButton.setLayoutData((Object)rd);
        this.removeSetValueButton.setEnabled(false);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.viewerSetValue.getControl().setLayoutData((Object)gd);
    }

    private void addPStorageSetAction() {
        KeyValuePairEditDialog dlg = new KeyValuePairEditDialog(this.getShell(), null, null, true, true);
        if (dlg.open() == 0) {
            this.pStorageSet.put(dlg.getAtributeName(), dlg.getAttributeValue());
            this.viewerSetValue.setInput(this.pStorageSet.entrySet().toArray());
        }
    }

    private void editPStorageSetAction() {
        IStructuredSelection selection = (IStructuredSelection)this.viewerSetValue.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry attr = (Map.Entry)selection.getFirstElement();
        KeyValuePairEditDialog dlg = new KeyValuePairEditDialog(this.getShell(), (String)attr.getKey(), (String)attr.getValue(), true, false);
        if (dlg.open() == 0) {
            this.pStorageSet.put(dlg.getAtributeName(), dlg.getAttributeValue());
            this.viewerSetValue.setInput(this.pStorageSet.entrySet().toArray());
        }
    }

    private void deletePStorageSetAction() {
        IStructuredSelection selection = (IStructuredSelection)this.viewerSetValue.getSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                this.pStorageSet.remove(e.getKey());
            }
            this.viewerSetValue.setInput(this.pStorageSet.entrySet().toArray());
        }
    }

    public void putAll(Map<String, String> pStorageSet) {
        this.pStorageSet.putAll(pStorageSet);
        this.viewerSetValue.setInput(pStorageSet.entrySet().toArray());
    }

    public void setMap(Map<String, String> pStorageSet) {
        this.pStorageSet = pStorageSet;
    }

    public Map<String, String> getSet() {
        return this.pStorageSet;
    }
}

