/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.SshKeyPair;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class SSH
extends PropertyPage {
    private AbstractNode node;
    private ObjectSelector sshProxy;
    private LabeledText sshLogin;
    private LabeledText sshPassword;
    private LabeledText sshPort;
    private Combo sshKey;
    private List<SshKeyPair> keyList;
    private NXCSession session;

    protected Control createContents(Composite parent) {
        this.node = (AbstractNode)this.getElement().getAdapter(AbstractNode.class);
        this.session = ConsoleSharedData.getSession();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogLayout.numColumns = 2;
        dialogLayout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)dialogLayout);
        this.sshLogin = new LabeledText(dialogArea, 0);
        this.sshLogin.setLabel("Login");
        this.sshLogin.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sshLogin.setText(this.node.getSshLogin());
        this.sshPassword = new LabeledText(dialogArea, 0);
        this.sshPassword.setLabel("Password");
        this.sshPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sshPassword.setText(this.node.getSshPassword());
        this.sshPort = new LabeledText(dialogArea, 0);
        this.sshPort.setLabel("Port");
        this.sshPort.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sshPort.setText(Integer.toString(this.node.getSshPort()));
        this.sshKey = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)"Key from configuration", (Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.sshProxy = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.sshProxy.setLabel(Messages.Communication_Proxy);
        this.sshProxy.setEmptySelectionName("<default>");
        this.sshProxy.setObjectId(this.node.getSshProxyId());
        this.sshProxy.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.loadSshKeyList();
        return dialogArea;
    }

    private void loadSshKeyList() {
        ConsoleJob job = new ConsoleJob("Reloading SSH key list", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List list = SSH.this.session.getSshKeys(true);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SSH.this.keyList = list;
                        SSH.this.sshKey.add("");
                        int selection = 0;
                        int i = 0;
                        while (i < SSH.this.keyList.size()) {
                            SshKeyPair d = (SshKeyPair)SSH.this.keyList.get(i);
                            SSH.this.sshKey.add(d.getName());
                            if (d.getId() == SSH.this.node.getSshKeyId()) {
                                selection = i + 1;
                            }
                            ++i;
                        }
                        SSH.this.sshKey.select(selection);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get list of SSH key";
            }
        };
        job.setUser(false);
        job.start();
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        try {
            md.setSshPort(Integer.parseInt(this.sshPort.getText(), 10));
        }
        catch (NumberFormatException e) {
            Shell shell = this.getShell();
            Messages.get();
            MessageDialog.openWarning((Shell)shell, (String)Messages.Communication_Warning, (String)"Please enter valid SSH port number");
            if (isApply) {
                this.setValid(true);
            }
            return false;
        }
        int selection = this.sshKey.getSelectionIndex();
        if (selection > 0) {
            SshKeyPair d = this.keyList.get(selection - 1);
            md.setSshKeyId(d.getId());
        } else {
            md.setSshKeyId(0);
        }
        md.setSshProxy(this.sshProxy.getObjectId());
        md.setSshLogin(this.sshLogin.getText().trim());
        md.setSshPassword(this.sshPassword.getText());
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob(String.format("Updating SSH settings for node %s", this.node.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                return String.format("Cannot update SSH settings for node %s", SSH.this.node.getObjectName());
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            SSH.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.sshProxy.setObjectId(0L);
        this.sshLogin.setText("netxms");
        this.sshPassword.setText("");
        this.sshPort.setText("22");
    }
}

