/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.widgets.helpers;

import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AlarmToolTip
extends ToolTip {
    private static final String[] stateImage = new String[]{"icons/outstanding.png", "icons/acknowledged.png", "icons/resolved.png", "icons/terminated.png", "icons/acknowledged_sticky.png"};
    private static final String[] stateText;
    private Alarm alarm;
    private WorkbenchLabelProvider wbLabelProvider;

    static {
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.AlarmListLabelProvider_AlarmState_Outstanding;
        Messages.get();
        stringArray[1] = Messages.AlarmListLabelProvider_AlarmState_Acknowledged;
        Messages.get();
        stringArray[2] = Messages.AlarmListLabelProvider_AlarmState_Resolved;
        Messages.get();
        stringArray[3] = Messages.AlarmListLabelProvider_AlarmState_Terminated;
        stateText = stringArray;
    }

    public AlarmToolTip(Control control, Alarm alarm) {
        super(control, 2, true);
        this.alarm = alarm;
        this.wbLabelProvider = new WorkbenchLabelProvider();
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        CLabel alarmSeverity = new CLabel(content, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        alarmSeverity.setLayoutData((Object)gd);
        Label sep = new Label(content, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 3;
        sep.setLayoutData((Object)gd);
        Text alarmText = new Text(content, 2);
        alarmText.setEditable(false);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 3;
        alarmText.setLayoutData((Object)gd);
        CLabel alarmState = new CLabel(content, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        alarmState.setLayoutData((Object)gd);
        CLabel alarmSource = new CLabel(content, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        alarmSource.setLayoutData((Object)gd);
        alarmSeverity.setImage(StatusDisplayInfo.getStatusImage((Severity)this.alarm.getCurrentSeverity()));
        alarmSeverity.setText(StatusDisplayInfo.getStatusText((Severity)this.alarm.getCurrentSeverity()));
        int state = this.alarm.getState();
        if (state == 1 && this.alarm.isSticky()) {
            state = 4;
        }
        final Image image = Activator.getImageDescriptor(stateImage[state]).createImage();
        alarmState.setImage(image);
        alarmState.setText(stateText[this.alarm.getState()]);
        AbstractObject object = ConsoleSharedData.getSession().findObjectById(this.alarm.getSourceObjectId());
        alarmSource.setImage(object != null ? this.wbLabelProvider.getImage((Object)object) : SharedIcons.IMG_UNKNOWN_OBJECT);
        alarmSource.setText(object != null ? object.getObjectName() : "[" + Long.toString(this.alarm.getSourceObjectId()) + "]");
        alarmText.setText(this.alarm.getMessage());
        content.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AlarmToolTip.this.wbLabelProvider.dispose();
                image.dispose();
            }
        });
        return content;
    }
}

