/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.dialogs;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.TableRow;
import org.netxms.client.log.Log;
import org.netxms.client.log.LogRecordDetails;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsEventLogRecordDetailsDialog
extends Dialog {
    private static final Logger logger = LoggerFactory.getLogger(WindowsEventLogRecordDetailsDialog.class);
    private LogRecordDetails data;
    private CTabFolder tabFolder;
    private TableRow record;
    private Log logHandle;

    public WindowsEventLogRecordDetailsDialog(Shell parentShell, LogRecordDetails data, TableRow record, Log logHandle) {
        super(parentShell);
        this.data = data;
        this.record = record;
        this.logHandle = logHandle;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Windows Event Log Record Details");
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Close", true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        dialogArea.setLayout((Layout)layout);
        this.tabFolder = new CTabFolder(dialogArea, 2048);
        this.tabFolder.setTabHeight(24);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 800;
        gd.heightHint = 500;
        this.tabFolder.setLayoutData((Object)gd);
        this.createInformationTab("General");
        String rawData = this.data.getValue("raw_data");
        this.createTextValueTab("Details", this.formatXML(rawData));
        this.tabFolder.setSelection(0);
        return dialogArea;
    }

    private String formatXML(String text) {
        String result = "";
        try {
            StringWriter stringWriter = new StringWriter();
            StreamResult xmlOutput = new StreamResult(stringWriter);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 3);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new StreamSource(new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8))), xmlOutput);
            result = xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            logger.warn("Cannot format XML", (Throwable)e);
            logger.debug("Source XML: " + text);
            result = text;
        }
        return result;
    }

    private void createInformationTab(String name) {
        CTabItem tab = this.createTab(name);
        Composite dialogArea = new Composite((Composite)this.tabFolder, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        StyledText textControl = new StyledText(dialogArea, 842);
        textControl.setFont(JFaceResources.getTextFont());
        textControl.setText(this.record.get(this.logHandle.getColumnIndex("message")).getValue());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        gd.heightHint = 500;
        textControl.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        WidgetHelper.createLabeledText((Composite)dialogArea, (int)2060, (int)-1, (String)"Log Name", (String)this.record.get(this.logHandle.getColumnIndex("log_name")).getValue(), (Object)gd);
        long timestamp = this.record.get(this.logHandle.getColumnIndex("origin_timestamp")).getValueAsLong();
        Date date = new Date(timestamp * 1000L);
        WidgetHelper.createLabeledText((Composite)dialogArea, (int)2060, (int)-1, (String)"Logged", (String)RegionalSettings.getDateTimeFormat().format(date), (Object)"WidgetHelper::default_layout_data");
        WidgetHelper.createLabeledText((Composite)dialogArea, (int)2060, (int)-1, (String)"Source", (String)this.record.get(this.logHandle.getColumnIndex("event_source")).getValue(), (Object)"WidgetHelper::default_layout_data");
        WidgetHelper.createLabeledText((Composite)dialogArea, (int)2060, (int)-1, (String)"Event ID", (String)this.record.get(this.logHandle.getColumnIndex("event_code")).getValue(), (Object)"WidgetHelper::default_layout_data");
        WidgetHelper.createLabeledText((Composite)dialogArea, (int)2060, (int)-1, (String)"Level", (String)this.record.get(this.logHandle.getColumnIndex("event_severity")).getValue(), (Object)"WidgetHelper::default_layout_data");
        tab.setControl((Control)dialogArea);
    }

    private void createTextValueTab(String name, String text) {
        CTabItem tab = this.createTab(name);
        StyledText textControl = new StyledText((Composite)this.tabFolder, 842);
        textControl.setFont(JFaceResources.getTextFont());
        textControl.setText(text);
        tab.setControl((Control)textControl);
    }

    private CTabItem createTab(String name) {
        CTabItem tab = new CTabItem(this.tabFolder, 0);
        tab.setText(name);
        return tab;
    }
}

