/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public abstract class TransformationSelectionProvider
implements IPostSelectionProvider {
    private ISelectionProvider parent;
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();
    private Set<ISelectionChangedListener> postSelectionListeners = new HashSet<ISelectionChangedListener>();

    public TransformationSelectionProvider(ISelectionProvider parent) {
        this.parent = parent;
        parent.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!TransformationSelectionProvider.this.selectionListeners.isEmpty()) {
                    SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)TransformationSelectionProvider.this, TransformationSelectionProvider.this.transformSelection(event.getSelection()));
                    for (ISelectionChangedListener l : TransformationSelectionProvider.this.selectionListeners) {
                        l.selectionChanged(e);
                    }
                }
            }
        });
        if (parent instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)parent).addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (!TransformationSelectionProvider.this.postSelectionListeners.isEmpty()) {
                        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)TransformationSelectionProvider.this, TransformationSelectionProvider.this.transformSelection(event.getSelection()));
                        for (ISelectionChangedListener l : TransformationSelectionProvider.this.postSelectionListeners) {
                            l.selectionChanged(e);
                        }
                    }
                }
            });
        }
    }

    public ISelection getSelection() {
        return this.transformSelection(this.parent.getSelection());
    }

    public void setSelection(ISelection selection) {
    }

    protected abstract ISelection transformSelection(ISelection var1);

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.add(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.remove(listener);
    }
}

