/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.widgets;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.netxms.client.snmp.MibObject;
import org.netxms.ui.eclipse.snmp.shared.MibCache;
import org.netxms.ui.eclipse.snmp.widgets.helpers.MibObjectComparator;
import org.netxms.ui.eclipse.snmp.widgets.helpers.MibTreeContentProvider;
import org.netxms.ui.eclipse.snmp.widgets.helpers.MibTreeLabelProvider;

public class MibBrowser
extends Composite {
    private TreeViewer mibTree;

    public MibBrowser(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.mibTree = new TreeViewer((Composite)this, 0);
        this.mibTree.setContentProvider((IContentProvider)new MibTreeContentProvider());
        this.mibTree.setLabelProvider((IBaseLabelProvider)new MibTreeLabelProvider());
        this.mibTree.setComparator((ViewerComparator)new MibObjectComparator());
        this.mibTree.setInput((Object)MibCache.getMibTree());
    }

    public MibObject getSelection() {
        ITreeSelection selection = this.mibTree.getStructuredSelection();
        return (MibObject)selection.getFirstElement();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.mibTree.addSelectionChangedListener(listener);
    }

    public void setSelection(MibObject object) {
        ITreeSelection selection = this.mibTree.getStructuredSelection();
        if (selection.size() == 1 && object.equals(selection.getFirstElement())) {
            return;
        }
        this.mibTree.setSelection((ISelection)new StructuredSelection((Object)object), true);
    }

    public void refreshTree() {
        this.mibTree.setInput((Object)MibCache.getMibTree());
    }

    public Tree getTreeControl() {
        return this.mibTree.getTree();
    }

    public TreeViewer getTreeViewer() {
        return this.mibTree;
    }
}

