/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.netxms.client.NXCSession;
import org.netxms.client.TextOutputListener;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.views.AbstractCommandResults;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ServerCommandResults
extends AbstractCommandResults
implements TextOutputListener,
ISaveablePart2 {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.ServerCommandResults";
    private IOConsoleOutputStream out;
    private String lastCommand = null;
    private Action actionRestart;
    private Action actionStop;
    private Map<String, String> lastInputValues = null;
    private long streamId = 0L;
    private NXCSession session;
    private boolean isRunning = false;
    private List<String> maskedFields;

    @Override
    protected void createActions() {
        super.createActions();
        this.session = ConsoleSharedData.getSession();
        Messages.get();
        this.actionRestart = new Action(Messages.LocalCommandResults_Restart, SharedIcons.RESTART){

            public void run() {
                ServerCommandResults.this.executeCommand(ServerCommandResults.this.lastCommand, ServerCommandResults.this.lastInputValues, ServerCommandResults.this.maskedFields);
            }
        };
        this.actionRestart.setEnabled(false);
        this.actionStop = new Action("Stop", SharedIcons.TERMINATE){

            public void run() {
                ServerCommandResults.this.stopCommand();
            }
        };
        this.actionStop.setEnabled(false);
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IAction)this.actionStop);
        manager.add((IContributionItem)new Separator());
        super.fillLocalPullDown(manager);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IAction)this.actionStop);
        manager.add((IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionRestart);
        manager.add((IAction)this.actionStop);
        manager.add((IContributionItem)new Separator());
        super.fillContextMenu(manager);
    }

    public void executeCommand(final String command, final Map<String, String> inputValues, final List<String> maskedFields) {
        if (this.isRunning) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Command already running!");
            return;
        }
        this.isRunning = true;
        this.actionRestart.setEnabled(false);
        this.actionStop.setEnabled(true);
        this.out = this.console.newOutputStream();
        this.lastCommand = command;
        this.lastInputValues = inputValues;
        this.maskedFields = maskedFields;
        Messages.get();
        ConsoleJob job = new ConsoleJob(String.format(Messages.ObjectToolsDynamicMenu_ExecuteOnNode, this.session.getObjectName(this.nodeId)), null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_CannotExecuteOnNode, ServerCommandResults.this.session.getObjectName(ServerCommandResults.this.nodeId));
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    ServerCommandResults.this.session.executeServerCommand(ServerCommandResults.this.nodeId, command, inputValues, maskedFields, true, (TextOutputListener)ServerCommandResults.this, null);
                    IOConsoleOutputStream iOConsoleOutputStream = ServerCommandResults.this.out;
                    Messages.get();
                    iOConsoleOutputStream.write(Messages.LocalCommandResults_Terminated);
                }
                finally {
                    if (ServerCommandResults.this.out != null) {
                        ServerCommandResults.this.out.close();
                        ServerCommandResults.this.out = null;
                    }
                }
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ServerCommandResults.this.actionRestart.setEnabled(true);
                        ServerCommandResults.this.actionStop.setEnabled(false);
                        ServerCommandResults.this.isRunning = false;
                    }
                });
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    private void stopCommand() {
        if (this.streamId > 0L) {
            ConsoleJob job = new ConsoleJob("Stop server command for node: " + this.session.getObjectName(this.nodeId), null, "org.netxms.ui.eclipse.objecttools", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    ServerCommandResults.this.session.stopServerCommand(ServerCommandResults.this.streamId);
                }

                protected void jobFinalize() {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ServerCommandResults.this.actionStop.setEnabled(false);
                            ServerCommandResults.this.actionRestart.setEnabled(true);
                        }
                    });
                }

                protected String getErrorMessage() {
                    return "Failed to stop server command for node: " + ServerCommandResults.this.session.getObjectName(ServerCommandResults.this.nodeId);
                }
            };
            job.start();
        }
    }

    public void messageReceived(String text) {
        try {
            if (this.out != null) {
                this.out.write(text.replace("\r", ""));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void setStreamId(long streamId) {
        this.streamId = streamId;
    }

    public void doSave(IProgressMonitor monitor) {
        this.stopCommand();
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isRunning;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.isRunning;
    }

    public int promptToSaveOnClose() {
        return MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Stop command", (String)("Do you wish to stop the command \"" + this.lastCommand + "\"? ")) ? 0 : 2;
    }

    public void onError() {
    }
}

