/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.viewers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef4.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.gef4.zest.core.viewers.IGraphContentProvider;
import org.eclipse.gef4.zest.core.viewers.internal.IStylingGraphModelFactory;
import org.eclipse.gef4.zest.core.widgets.Graph;
import org.eclipse.gef4.zest.core.widgets.GraphConnection;
import org.eclipse.gef4.zest.core.widgets.GraphContainer;
import org.eclipse.gef4.zest.core.widgets.GraphItem;
import org.eclipse.gef4.zest.core.widgets.GraphNode;
import org.eclipse.gef4.zest.core.widgets.IContainer;
import org.eclipse.gef4.zest.core.widgets.ZestStyles;
import org.eclipse.gef4.zest.core.widgets.custom.CGraphNode;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractStructuredGraphViewer
extends AbstractZoomableViewer {
    private int graphStyle;
    private int nodeStyle;
    private int connectionStyle;
    private HashMap<Object, GraphItem> nodesMap = new HashMap();
    private HashMap<Object, GraphItem> connectionsMap = new HashMap();

    protected AbstractStructuredGraphViewer(int graphStyle) {
        this.graphStyle = graphStyle;
        this.connectionStyle = 0;
        this.nodeStyle = 0;
    }

    public void setNodeStyle(int nodeStyle) {
        if (this.getInput() != null) {
            throw new SWTError(1);
        }
        this.nodeStyle = nodeStyle;
    }

    public void setConnectionStyle(int connectionStyle) {
        if (this.getInput() != null) {
            throw new SWTError(1);
        }
        if (!ZestStyles.validateConnectionStyle((int)connectionStyle)) {
            throw new SWTError(5);
        }
        this.connectionStyle = connectionStyle;
    }

    public int getGraphStyle() {
        return this.graphStyle;
    }

    public int getNodeStyle() {
        return this.nodeStyle;
    }

    public Graph getGraphControl() {
        return (Graph)this.getControl();
    }

    public int getConnectionStyle() {
        return this.connectionStyle;
    }

    public abstract void setLayoutAlgorithm(LayoutAlgorithm var1, boolean var2);

    protected abstract LayoutAlgorithm getLayoutAlgorithm();

    public void setLayoutAlgorithm(LayoutAlgorithm algorithm) {
        this.setLayoutAlgorithm(algorithm, false);
    }

    public Object[] getNodeElements() {
        return this.nodesMap.keySet().toArray();
    }

    public Object[] getConnectionElements() {
        return this.connectionsMap.keySet().toArray();
    }

    public HashMap<Object, GraphItem> getNodesMap() {
        return this.nodesMap;
    }

    public GraphNode addGraphModelContainer(Object element) {
        GraphNode node = this.getGraphModelNode(element);
        if (node == null) {
            node = new GraphContainer((Graph)this.getControl(), 0);
            this.nodesMap.put(element, (GraphItem)node);
            node.setData(element);
        }
        return node;
    }

    public GraphNode addGraphModelNode(GraphContainer container, Object element) {
        GraphNode node = this.getGraphModelNode(element);
        if (node == null) {
            node = new GraphNode((IContainer)container, 0);
            this.nodesMap.put(element, (GraphItem)node);
            node.setData(element);
        }
        return node;
    }

    public GraphNode addGraphModelNode(Object element, IFigure figure) {
        GraphNode node = this.getGraphModelNode(element);
        if (node == null) {
            if (figure != null) {
                node = new CGraphNode((Graph)this.getControl(), 0, figure);
                this.nodesMap.put(element, (GraphItem)node);
                node.setData(element);
            } else {
                node = new GraphNode((IContainer)((Graph)this.getControl()), 0);
                this.nodesMap.put(element, (GraphItem)node);
                node.setData(element);
            }
        }
        return node;
    }

    public GraphConnection addGraphModelConnection(Object element, GraphNode source, GraphNode target) {
        GraphConnection connection = this.getGraphModelConnection(element);
        if (connection == null) {
            connection = new GraphConnection((Graph)this.getControl(), 0, source, target);
            this.connectionsMap.put(element, (GraphItem)connection);
            connection.setData(element);
        }
        return connection;
    }

    public GraphConnection getGraphModelConnection(Object obj) {
        GraphConnection connection = (GraphConnection)this.connectionsMap.get(obj);
        return connection != null && !connection.isDisposed() ? connection : null;
    }

    public GraphNode getGraphModelNode(Object obj) {
        GraphNode node = (GraphNode)this.nodesMap.get(obj);
        return node != null && !node.isDisposed() ? node : null;
    }

    public void removeGraphModelConnection(Object obj) {
        GraphConnection connection = (GraphConnection)this.connectionsMap.get(obj);
        if (connection != null) {
            this.connectionsMap.remove(obj);
            if (!connection.isDisposed()) {
                connection.dispose();
            }
        }
    }

    public void removeGraphModelNode(Object obj) {
        GraphNode node = (GraphNode)this.nodesMap.get(obj);
        if (node != null) {
            this.nodesMap.remove(obj);
            if (!node.isDisposed()) {
                node.dispose();
            }
        }
    }

    protected void internalRefresh(Object element) {
        if (this.getInput() == null) {
            return;
        }
        if (element == this.getInput()) {
            this.getFactory().refreshGraph(this.getGraphControl());
        } else {
            this.getFactory().refresh(this.getGraphControl(), element);
        }
        this.getGraphControl().getLightweightSystem().getUpdateManager().performUpdate();
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        if (item == this.getGraphControl()) {
            this.getFactory().update((GraphItem[])this.getNodesArray(this.getGraphControl()));
            this.getFactory().update((GraphItem[])this.getConnectionsArray(this.getGraphControl()));
        } else if (item instanceof GraphItem) {
            this.getFactory().update((GraphItem)item);
        }
    }

    protected Widget doFindInputItem(Object element) {
        if (element == this.getInput() && element instanceof Widget) {
            return (Widget)element;
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        Widget node = (Widget)this.nodesMap.get(element);
        Widget connection = (Widget)this.connectionsMap.get(element);
        return node != null ? node : connection;
    }

    protected List<Object> getSelectionFromWidget() {
        List internalSelection = this.getWidgetSelection();
        LinkedList<Object> externalSelection = new LinkedList<Object>();
        Iterator i = internalSelection.iterator();
        while (i.hasNext()) {
            Object data = ((GraphItem)i.next()).getData();
            if (data == null) continue;
            externalSelection.add(data);
        }
        return externalSelection;
    }

    protected GraphItem[] findItems(List l) {
        if (l == null) {
            return new GraphItem[0];
        }
        ArrayList<GraphItem> list = new ArrayList<GraphItem>();
        Iterator iterator = l.iterator();
        while (iterator.hasNext()) {
            GraphItem w = (GraphItem)this.findItem(iterator.next());
            list.add(w);
        }
        return list.toArray(new GraphItem[list.size()]);
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        Graph control = (Graph)this.getControl();
        LinkedList<Object> selection = new LinkedList<Object>();
        for (Object obj : l) {
            GraphNode node = (GraphNode)this.nodesMap.get(obj);
            GraphConnection conn = (GraphConnection)this.connectionsMap.get(obj);
            if (node != null) {
                selection.add(node);
            }
            if (conn == null) continue;
            selection.add(conn);
        }
        control.setSelection((GraphItem[])selection.toArray(new GraphNode[selection.size()]));
    }

    protected List getWidgetSelection() {
        Graph control = (Graph)this.getControl();
        return control.getSelection();
    }

    protected void inputChanged(Object input, Object oldInput) {
        IStylingGraphModelFactory factory = this.getFactory();
        factory.setConnectionStyle(this.getConnectionStyle());
        factory.setNodeStyle(this.getNodeStyle());
        HashMap<Object, GraphItem> oldNodesMap = this.nodesMap;
        Graph graph = (Graph)this.getControl();
        graph.setSelection((GraphItem[])new GraphNode[0]);
        for (GraphNode graphNode : this.nodesMap.values()) {
            if (graphNode.isDisposed()) continue;
            graphNode.dispose();
        }
        for (GraphConnection graphConnection : this.connectionsMap.values()) {
            if (graphConnection.isDisposed()) continue;
            graphConnection.dispose();
        }
        this.nodesMap = new HashMap();
        this.connectionsMap = new HashMap();
        graph = factory.createGraphModel(graph);
        ((Graph)this.getControl()).setNodeStyle(this.getNodeStyle());
        ((Graph)this.getControl()).setConnectionStyle(this.getConnectionStyle());
        for (Object data : oldNodesMap.keySet()) {
            GraphNode newNode = (GraphNode)this.nodesMap.get(data);
            if (newNode == null) continue;
            GraphNode oldNode = (GraphNode)oldNodesMap.get(data);
            newNode.setLocation((double)oldNode.getLocation().x, (double)oldNode.getLocation().y);
            if (!oldNode.isSizeFixed()) continue;
            newNode.setSize((double)oldNode.getSize().width, (double)oldNode.getSize().height);
        }
    }

    protected abstract IStylingGraphModelFactory getFactory();

    protected void filterVisuals() {
        if (this.getGraphControl() == null) {
            return;
        }
        Object[] filtered = this.getFilteredChildren(this.getInput());
        SimpleGraphComparator comparator = new SimpleGraphComparator();
        TreeSet<GraphItem> filteredElements = new TreeSet<GraphItem>(comparator);
        TreeSet<GraphItem> unfilteredElements = new TreeSet<GraphItem>(comparator);
        List connections = this.getGraphControl().getConnections();
        List nodes = this.getGraphControl().getNodes();
        if (filtered.length == 0) {
            for (GraphConnection c : connections) {
                c.setVisible(false);
            }
            for (GraphNode n : nodes) {
                n.setVisible(false);
            }
            return;
        }
        for (GraphConnection c : connections) {
            if (c.getData() == null) continue;
            unfilteredElements.add((GraphItem)c);
        }
        for (GraphNode n : nodes) {
            if (n.getData() == null) continue;
            unfilteredElements.add((GraphItem)n);
        }
        int i = 0;
        while (i < filtered.length) {
            GraphItem modelElement = this.connectionsMap.get(filtered[i]);
            if (modelElement == null) {
                modelElement = this.nodesMap.get(filtered[i]);
            }
            if (modelElement != null) {
                filteredElements.add(modelElement);
            }
            ++i;
        }
        unfilteredElements.removeAll(filteredElements);
        while (unfilteredElements.size() > 0) {
            GraphItem i2 = unfilteredElements.first();
            i2.setVisible(false);
            unfilteredElements.remove(i2);
        }
        while (filteredElements.size() > 0) {
            GraphItem i3 = filteredElements.first();
            i3.setVisible(true);
            filteredElements.remove(i3);
        }
    }

    protected Object[] getRawChildren(Object parent) {
        if (parent == this.getInput()) {
            LinkedList<Object> children = new LinkedList<Object>();
            if (this.getGraphControl() != null) {
                List connections = this.getGraphControl().getConnections();
                List nodes = this.getGraphControl().getNodes();
                for (GraphConnection c : connections) {
                    if (c.getData() == null) continue;
                    children.add(c.getData());
                }
                for (GraphNode n : nodes) {
                    if (n.getData() == null) continue;
                    children.add(n.getData());
                }
                return children.toArray();
            }
        }
        return super.getRawChildren(parent);
    }

    public void reveal(Object element) {
        Widget[] items = this.findItems(element);
        Point location = null;
        int i = 0;
        while (i < items.length) {
            Widget item = items[i];
            if (item instanceof GraphNode) {
                GraphNode graphModelNode = (GraphNode)item;
                graphModelNode.highlight();
                location = this.getTopLeftBoundary(graphModelNode.getLocation(), location);
            } else if (item instanceof GraphConnection) {
                GraphConnection graphModelConnection = (GraphConnection)item;
                graphModelConnection.highlight();
                location = this.getTopLeftBoundary(graphModelConnection.getSource().getLocation(), location);
                location = this.getTopLeftBoundary(graphModelConnection.getDestination().getLocation(), location);
            }
            ++i;
        }
        if (location != null) {
            this.getGraphControl().scrollSmoothTo(location.x, location.y);
        }
    }

    private Point getTopLeftBoundary(Point point1, Point point2) {
        if (point2 != null) {
            return new Point(Math.min(point1.x, point2.x), Math.min(point1.y, point2.y));
        }
        return point1;
    }

    public void unReveal(Object element) {
        Widget[] items = this.findItems(element);
        int i = 0;
        while (i < items.length) {
            Widget item = items[i];
            if (item instanceof GraphNode) {
                GraphNode graphModelNode = (GraphNode)item;
                graphModelNode.unhighlight();
            } else if (item instanceof GraphConnection) {
                GraphConnection graphModelConnection = (GraphConnection)item;
                graphModelConnection.unhighlight();
            }
            ++i;
        }
    }

    public abstract void applyLayout();

    public void removeRelationship(Object connection) {
        GraphConnection relationship = (GraphConnection)this.connectionsMap.get(connection);
        if (relationship != null) {
            relationship.dispose();
            this.connectionsMap.remove(connection);
        }
    }

    public void addNode(Object element) {
        if (this.nodesMap.get(element) == null) {
            this.getFactory().createNode(this.getGraphControl(), element);
        }
    }

    public void removeNode(Object element) {
        GraphNode node = (GraphNode)this.nodesMap.get(element);
        if (node != null) {
            node.dispose();
            this.nodesMap.remove(element);
        }
    }

    public void addRelationship(Object connection, Object srcNode, Object destNode) {
        IStylingGraphModelFactory modelFactory = this.getFactory();
        modelFactory.createConnection(this.getGraphControl(), connection, srcNode, destNode);
    }

    public void addRelationship(Object connection) {
        IStylingGraphModelFactory modelFactory = this.getFactory();
        if (this.connectionsMap.get(connection) == null) {
            if (modelFactory.getContentProvider() instanceof IGraphContentProvider) {
                IGraphContentProvider content = (IGraphContentProvider)modelFactory.getContentProvider();
                Object source = content.getSource(connection);
                Object dest = content.getDestination(connection);
                modelFactory.createConnection(this.getGraphControl(), connection, source, dest);
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected GraphConnection[] getConnectionsArray(Graph graph) {
        GraphConnection[] connsArray = new GraphConnection[graph.getConnections().size()];
        connsArray = graph.getConnections().toArray(connsArray);
        return connsArray;
    }

    protected GraphNode[] getNodesArray(Graph graph) {
        GraphNode[] nodesArray = new GraphNode[graph.getNodes().size()];
        nodesArray = graph.getNodes().toArray(nodesArray);
        return nodesArray;
    }

    private class SimpleGraphComparator
    implements Comparator<GraphItem> {
        TreeSet<String> storedStrings = new TreeSet();

        @Override
        public int compare(GraphItem arg0, GraphItem arg1) {
            if (arg0 instanceof GraphNode && arg1 instanceof GraphConnection) {
                return 1;
            }
            if (arg0 instanceof GraphConnection && arg1 instanceof GraphNode) {
                return -1;
            }
            if (arg0.equals(arg1)) {
                return 0;
            }
            return this.getObjectString(arg0).compareTo(this.getObjectString(arg1));
        }

        private String getObjectString(Object o) {
            String s = String.valueOf(o.getClass().getName()) + "@" + Integer.toHexString(o.hashCode());
            while (this.storedStrings.contains(s)) {
                s = String.valueOf(s) + 'X';
            }
            return s;
        }
    }
}

