/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.widgets;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.ui.eclipse.eventmanager.Activator;
import org.netxms.ui.eclipse.eventmanager.Messages;
import org.netxms.ui.eclipse.eventmanager.widgets.helpers.EventLabelProvider;
import org.netxms.ui.eclipse.eventmanager.widgets.helpers.EventMonitorFilter;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractTraceWidget;

public class EventTraceWidget
extends AbstractTraceWidget
implements SessionListener {
    public static final int COLUMN_TIMESTAMP = 0;
    public static final int COLUMN_SOURCE = 1;
    public static final int COLUMN_SEVERITY = 2;
    public static final int COLUMN_EVENT = 3;
    public static final int COLUMN_MESSAGE = 4;
    private NXCSession session = ConsoleSharedData.getSession();
    private Action actionShowColor;
    private Action actionShowIcons;
    private EventLabelProvider labelProvider;
    private EventMonitorFilter filter;

    public EventTraceWidget(Composite parent, int style, IViewPart viewPart) {
        super(parent, style, viewPart);
        this.session.addListener((SessionListener)this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EventTraceWidget.this.session.removeListener((SessionListener)EventTraceWidget.this);
            }
        });
    }

    protected void setupViewer(TableViewer viewer) {
        this.labelProvider = new EventLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        this.labelProvider.setShowColor(ps.getBoolean("EventMonitor.showColor"));
        this.labelProvider.setShowIcons(ps.getBoolean("EventMonitor.showIcons"));
        Messages.get();
        this.addColumn(Messages.EventMonitor_ColTimestamp, 150);
        Messages.get();
        this.addColumn(Messages.EventMonitor_ColSource, 200);
        Messages.get();
        this.addColumn(Messages.EventMonitor_ColSeverity, 90);
        Messages.get();
        this.addColumn(Messages.EventMonitor_ColEvent, 200);
        Messages.get();
        this.addColumn(Messages.EventMonitor_ColMessage, 600);
        this.filter = new EventMonitorFilter();
        this.setFilter(this.filter);
    }

    protected void saveConfig() {
        super.saveConfig();
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        ps.setValue("EventMonitor.showColor", this.labelProvider.isShowColor());
        ps.setValue("EventMonitor.showIcons", this.labelProvider.isShowIcons());
    }

    protected IDialogSettings getDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    protected String getConfigPrefix() {
        return "EventMonitor";
    }

    protected void createActions() {
        super.createActions();
        Messages.get();
        this.actionShowColor = new Action(Messages.EventMonitor_ShowStatusColors, 2){

            public void run() {
                EventTraceWidget.this.labelProvider.setShowColor(EventTraceWidget.this.actionShowColor.isChecked());
                EventTraceWidget.this.refresh();
            }
        };
        this.actionShowColor.setChecked(this.labelProvider.isShowColor());
        Messages.get();
        this.actionShowIcons = new Action(Messages.EventMonitor_ShowStatusIcons, 2){

            public void run() {
                EventTraceWidget.this.labelProvider.setShowIcons(EventTraceWidget.this.actionShowIcons.isChecked());
                EventTraceWidget.this.refresh();
            }
        };
        this.actionShowIcons.setChecked(this.labelProvider.isShowIcons());
    }

    public void notificationHandler(final SessionNotification n) {
        if (n.getCode() == 2) {
            this.runInUIThread(new Runnable(){

                @Override
                public void run() {
                    if (!EventTraceWidget.this.isDisposed()) {
                        EventTraceWidget.this.addElement(n.getObject());
                    }
                }
            });
        }
    }

    public Action getActionShowColor() {
        return this.actionShowColor;
    }

    public Action getActionShowIcons() {
        return this.actionShowIcons;
    }

    public void setRootObject(long objectId) {
        this.filter.setRootObject(objectId);
        this.refresh();
    }
}

