/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views;

import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.netxms.base.NXCommon;
import org.netxms.client.AgentPolicy;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.LocalChangeListener;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.dialogs.SavePolicyDialog;
import org.netxms.ui.eclipse.datacollection.widgets.AbstractPolicyEditor;
import org.netxms.ui.eclipse.datacollection.widgets.AgentConfigPolicyEditor;
import org.netxms.ui.eclipse.datacollection.widgets.FileDeliveryPolicyEditor;
import org.netxms.ui.eclipse.datacollection.widgets.GenericPolicyEditor;
import org.netxms.ui.eclipse.datacollection.widgets.LogParserPolicyEditor;
import org.netxms.ui.eclipse.datacollection.widgets.SupportAppPolicyEditor;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.PolicyModifyListener;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.NXFindAndReplaceAction;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;

public class PolicyEditorView
extends ViewPart
implements ISaveablePart2,
SessionListener,
IFindReplaceTarget {
    public static final String ID = "org.netxms.ui.eclipse.datacollection.views.policy_editor";
    private AbstractPolicyEditor editor = null;
    private NXCSession session;
    private long templateId;
    private UUID policyGUID = NXCommon.EMPTY_GUID;
    private AgentPolicy policy;
    private FindReplaceAction actionFindReplace;
    private boolean throwExceptionOnSave;
    private Exception saveException;
    private Display display;
    private boolean modified = false;
    private boolean modifiedByOtherUser = false;
    private boolean saveInProgress = false;
    private CompositeWithMessageBar contentWrapper;
    private Composite content;
    private Action actionSave;
    private Action actionRefresh;
    private LocalChangeListener localChangeListener;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
    }

    public void setPolicy(UUID policyGUID, long templateId, LocalChangeListener localChangeListener) {
        this.templateId = templateId;
        this.policyGUID = policyGUID;
        this.localChangeListener = localChangeListener;
        this.modified = false;
        this.firePropertyChange(257);
        this.actionSave.setEnabled(false);
        this.refresh();
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        this.contentWrapper = new CompositeWithMessageBar(parent, 0);
        this.content = new Composite((Composite)this.contentWrapper, 0);
        this.content.setLayout((Layout)new FillLayout());
        this.contentWrapper.setContent(this.content);
        this.createActions();
        this.contributeToActionBars();
        this.session.addListener((SessionListener)this);
    }

    public void dispose() {
        this.modified = false;
        this.firePropertyChange(257);
        this.localChangeListener = null;
        super.dispose();
    }

    protected void createActions() {
        this.actionSave = new Action("Save", SharedIcons.SAVE){

            public void run() {
                PolicyEditorView.this.save();
            }
        };
        this.actionSave.setEnabled(false);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                PolicyEditorView.this.refresh();
            }
        };
        this.actionFindReplace = NXFindAndReplaceAction.getFindReplaceAction((ViewPart)this);
    }

    protected void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getMenuManager().removeAll();
        bars.getToolBarManager().removeAll();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
        bars.updateActionBars();
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        if (this.editor != null) {
            this.editor.fillLocalPullDown(manager);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionFindReplace);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        if (this.editor != null) {
            this.editor.fillLocalToolBar(manager);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void refresh() {
        if (this.modified) {
            if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Refresh policy", (String)"This will discard all unsaved changes. Do you really want to continue?")) {
                return;
            }
            this.modified = false;
            this.firePropertyChange(257);
            this.actionSave.setEnabled(false);
        }
        this.modifiedByOtherUser = false;
        ConsoleJob job = new ConsoleJob("Get agent policy", (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final AgentPolicy tmp = PolicyEditorView.this.session.getAgentPolicy(PolicyEditorView.this.templateId, PolicyEditorView.this.policyGUID);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PolicyEditorView.this.policy = tmp;
                        if (PolicyEditorView.this.editor == null) {
                            PolicyEditorView.this.updateFields();
                        } else {
                            PolicyEditorView.this.editor.setPolicy(PolicyEditorView.this.policy);
                            PolicyEditorView.this.editor.updateControlFromPolicy();
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot load policy";
            }
        };
        job.start();
    }

    private void updateFields() {
        this.setPartName(String.format("Agent Policy - %s", this.policy.getName()));
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        switch (this.policy.getPolicyType()) {
            case "AgentConfig": {
                this.editor = new AgentConfigPolicyEditor(this.content, 0, this.policy, (IViewPart)this);
                break;
            }
            case "FileDelivery": {
                this.editor = new FileDeliveryPolicyEditor(this.content, 0, this.policy, (IViewPart)this);
                break;
            }
            case "LogParserConfig": {
                this.editor = new LogParserPolicyEditor(this.content, 0, this.policy, (IViewPart)this);
                break;
            }
            case "SupportApplicationConfig": {
                this.editor = new SupportAppPolicyEditor(this.content, 0, this.policy, (IViewPart)this);
                break;
            }
            default: {
                this.editor = new GenericPolicyEditor(this.content, 0, this.policy, (IViewPart)this);
            }
        }
        this.contributeToActionBars();
        this.editor.addModifyListener(new PolicyModifyListener(){

            @Override
            public void modifyParser() {
                PolicyEditorView.this.setModified();
            }
        });
        this.editor.setFindAndReplaceAction(this.actionFindReplace);
        this.actionFindReplace.setEnabled(this.editor.isFindAndReplaceRequired());
        this.actionFindReplace.update();
        this.content.layout(true, true);
        this.editor.setFocus();
    }

    protected void setModified() {
        if (this.modified) {
            return;
        }
        this.modified = true;
        this.firePropertyChange(257);
        this.actionSave.setEnabled(true);
    }

    public void doSave(IProgressMonitor monitor) {
        block2: {
            try {
                this.session.savePolicy(this.templateId, this.policy, false);
            }
            catch (Exception e) {
                Activator.logError("Exception during policy save", e);
                this.saveException = e;
                if (this.throwExceptionOnSave) break block2;
                MessageDialogHelper.openError((Shell)this.getViewSite().getShell(), (String)"Error", (String)String.format("Cannot save policy object: %s", e.getLocalizedMessage()));
            }
        }
    }

    public void doSaveAs() {
    }

    private void save() {
        if (this.modifiedByOtherUser && this.modified) {
            if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Refresh policy", (String)"This policy already modified by other users. Do you really want to continue and overwrite other users changes?\n")) {
                return;
            }
            this.contentWrapper.hideMessage();
        }
        this.saveInProgress = true;
        this.modifiedByOtherUser = false;
        this.throwExceptionOnSave = true;
        this.policy = this.editor.updatePolicyFromControl();
        this.editor.onSave();
        new ConsoleJob("Save agent policy", (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PolicyEditorView.this.saveException = null;
                PolicyEditorView.this.doSave(monitor);
                if (PolicyEditorView.this.saveException != null) {
                    throw PolicyEditorView.this.saveException;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PolicyEditorView.this.modified = false;
                        PolicyEditorView.this.firePropertyChange(257);
                        PolicyEditorView.this.actionSave.setEnabled(false);
                        PolicyEditorView.this.saveInProgress = false;
                        if (PolicyEditorView.this.localChangeListener != null) {
                            PolicyEditorView.this.localChangeListener.onObjectChange();
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot save agent policy";
            }

            protected void jobFinalize() {
                PolicyEditorView.this.throwExceptionOnSave = false;
                PolicyEditorView.this.saveInProgress = false;
            }
        }.start();
    }

    public void setFocus() {
        if (this.editor != null) {
            this.editor.setFocus();
        }
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    public int promptToSaveOnClose() {
        SavePolicyDialog dlg = new SavePolicyDialog(this.getSite().getShell());
        int rc = dlg.open();
        if (rc == 100) {
            if (this.modifiedByOtherUser && this.modified && !MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Refresh policy", (String)"This policy already modified by other users. Do you really want to continue and overwrite other users changes?\n")) {
                return 2;
            }
            this.policy = this.editor.updatePolicyFromControl();
            this.editor.onSave();
            if (this.localChangeListener != null) {
                this.localChangeListener.onObjectChange();
            }
            return 0;
        }
        if (rc == 1) {
            return 2;
        }
        this.editor.onDiscard();
        return 1;
    }

    public void notificationHandler(final SessionNotification n) {
        switch (n.getCode()) {
            case 1039: {
                if (n.getSubCode() != this.templateId || !((AgentPolicy)n.getObject()).getGuid().equals(this.policyGUID)) {
                    return;
                }
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PolicyEditorView.this.content.isDisposed()) {
                            return;
                        }
                        if (!PolicyEditorView.this.modified) {
                            PolicyEditorView.this.policy = (AgentPolicy)n.getObject();
                            PolicyEditorView.this.editor.setPolicy(PolicyEditorView.this.policy);
                        } else if (!PolicyEditorView.this.saveInProgress) {
                            PolicyEditorView.this.contentWrapper.showMessage(1, "Policy is modified by other users. \"Refresh\" will discard local changes. \"Save\" will overwrite other users changes with local changes.");
                            PolicyEditorView.this.modifiedByOtherUser = true;
                        }
                    }
                });
                break;
            }
            case 1040: {
                if (n.getSubCode() != this.templateId || !this.policyGUID.equals(n.getObject())) {
                    return;
                }
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PolicyEditorView.this.getViewSite().getPage().hideView((IViewPart)PolicyEditorView.this);
                    }
                });
            }
        }
    }

    public boolean canPerformFind() {
        return this.editor != null ? this.editor.canPerformFind() : false;
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return this.editor != null ? this.editor.findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord) : 0;
    }

    public Point getSelection() {
        return this.editor != null ? this.editor.getSelection() : null;
    }

    public String getSelectionText() {
        return this.editor != null ? this.editor.getSelectionText() : null;
    }

    public boolean isEditable() {
        return this.editor != null ? this.editor.isEditable() : false;
    }

    public void replaceSelection(String text) {
        if (this.editor != null) {
            this.editor.replaceSelection(text);
        }
    }
}

