/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.GraphSettings;
import org.netxms.client.objecttools.ObjectAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.propertypages.Filter;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.dialogs.SaveGraphDlg;
import org.netxms.ui.eclipse.perfview.propertypages.General;
import org.netxms.ui.eclipse.perfview.propertypages.Graph;
import org.netxms.ui.eclipse.perfview.propertypages.TemplateDataSources;
import org.netxms.ui.eclipse.perfview.views.helpers.TemplateGraphLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TemplateGraphView
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.perfview.views.TemplateGraphView";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_DCI_NAME = 1;
    public static final int COLUMN_DCI_DESCRIPTION = 2;
    private NXCSession session;
    private SortableTableViewer viewer;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionAdd;
    private Action actionRefresh;
    private boolean updateInProgress = false;
    List<GraphSettings> graphList;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
    }

    public void createPartControl(Composite parent) {
        String[] names = new String[]{"Graph name", "DCI names", "DCI descriptions"};
        int[] widths = new int[]{150, 400, 400};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 1024, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TemplateGraphLabelProvider());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TemplateGraphView.this.actionEdit.run();
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refreshData();
        this.session.addListener((SessionListener)this);
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                TemplateGraphView.this.refreshData();
            }
        };
        this.actionEdit = new Action("Edit graph"){

            public void run() {
                TemplateGraphView.this.editTemplateGraph();
            }
        };
        this.actionAdd = new Action("Create new template graph", SharedIcons.ADD_OBJECT){

            public void run() {
                TemplateGraphView.this.saveGraph("", null, false);
            }
        };
        this.actionDelete = new Action("Delete template graph"){

            public void run() {
                TemplateGraphView.this.deletePredefinedGraph();
            }
        };
    }

    private void saveGraph(String graphName, String errorMessage, final boolean canBeOverwritten) {
        SaveGraphDlg dlg = new SaveGraphDlg(this.getSite().getShell(), graphName, errorMessage, canBeOverwritten);
        int result = dlg.open();
        if (result == 1) {
            return;
        }
        final GraphSettings gs = new GraphSettings(0L, (long)this.session.getUserId(), 0, new ArrayList(0));
        gs.setName(dlg.getName());
        gs.setFlags(1);
        if (result == 101) {
            Messages.get();
            new ConsoleJob(Messages.HistoricalGraphView_SaveSettings, (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    TemplateGraphView.this.session.saveGraph(gs, canBeOverwritten);
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.HistoricalGraphView_SaveSettingsError;
                }
            }.start();
        } else {
            Messages.get();
            new ConsoleJob(Messages.HistoricalGraphView_SaveSettings, (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    try {
                        TemplateGraphView.this.session.saveGraph(gs, canBeOverwritten);
                    }
                    catch (NXCException e) {
                        if (e.getErrorCode() == 107) {
                            this.runInUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    TemplateGraphView templateGraphView = TemplateGraphView.this;
                                    String string = gs.getName();
                                    Messages.get();
                                    templateGraphView.saveGraph(string, Messages.HistoricalGraphView_NameAlreadyExist, true);
                                }
                            });
                        }
                        if (e.getErrorCode() == 2) {
                            this.runInUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    TemplateGraphView templateGraphView = TemplateGraphView.this;
                                    String string = gs.getName();
                                    Messages.get();
                                    templateGraphView.saveGraph(string, Messages.HistoricalGraphView_NameAlreadyExistNoOverwrite, false);
                                }
                            });
                        }
                        throw e;
                    }
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.HistoricalGraphView_SaveError;
                }
            }.start();
        }
    }

    public void notificationHandler(final SessionNotification n) {
        switch (n.getCode()) {
            case 1028: {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int i = 0;
                        while (i < TemplateGraphView.this.graphList.size()) {
                            if (TemplateGraphView.this.graphList.get(i).getId() == n.getSubCode()) {
                                GraphSettings o = TemplateGraphView.this.graphList.get(i);
                                TemplateGraphView.this.graphList.remove(o);
                                TemplateGraphView.this.viewer.setInput(TemplateGraphView.this.graphList);
                                break;
                            }
                            ++i;
                        }
                    }
                });
                break;
            }
            case 1012: {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GraphSettings element;
                        if (!(n.getObject() instanceof GraphSettings)) {
                            return;
                        }
                        IStructuredSelection selection = (IStructuredSelection)TemplateGraphView.this.viewer.getSelection();
                        boolean objectUpdated = false;
                        int i = 0;
                        while (i < TemplateGraphView.this.graphList.size()) {
                            if (TemplateGraphView.this.graphList.get(i).getId() == n.getSubCode()) {
                                TemplateGraphView.this.graphList.set(i, (GraphSettings)n.getObject());
                                objectUpdated = true;
                                break;
                            }
                            ++i;
                        }
                        if (!objectUpdated && ((GraphSettings)n.getObject()).isTemplate()) {
                            TemplateGraphView.this.graphList.add((GraphSettings)n.getObject());
                        }
                        TemplateGraphView.this.viewer.setInput(TemplateGraphView.this.graphList);
                        if (selection.size() == 1 && selection.getFirstElement() instanceof GraphSettings && (element = (GraphSettings)selection.getFirstElement()).getId() == n.getSubCode()) {
                            TemplateGraphView.this.viewer.setSelection((ISelection)new StructuredSelection((Object)((GraphSettings)n.getObject())), true);
                        }
                    }
                });
            }
        }
    }

    private void editTemplateGraph() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        GraphSettings settings = (GraphSettings)selection.getFirstElement();
        if (this.showGraphPropertyPages(settings)) {
            final GraphSettings newSettings = settings;
            try {
                new ConsoleJob("Update template graph", null, "org.netxms.ui.eclipse.perfview", null){

                    protected void runInternal(IProgressMonitor monitor) throws Exception {
                        TemplateGraphView.this.session.saveGraph(newSettings, false);
                        this.runInUIThread(new Runnable(){

                            @Override
                            public void run() {
                                TemplateGraphView.this.viewer.update((Object)newSettings, null);
                            }
                        });
                    }

                    protected String getErrorMessage() {
                        return "Cannot update predefined graph";
                    }
                }.start();
            }
            catch (Exception e) {
                MessageDialogHelper.openError((Shell)this.getSite().getShell(), (String)"Internal Error", (String)String.format("Unexpected exception: %s", e.getLocalizedMessage()));
            }
        }
    }

    private void deletePredefinedGraph() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.PredefinedGraphTree_DeletePromptTitle, (String)Messages.PredefinedGraphTree_DeletePromptText)) {
            return;
        }
        for (final Object o : selection.toList()) {
            if (!(o instanceof GraphSettings)) continue;
            Messages.get();
            new ConsoleJob(String.format(Messages.PredefinedGraphTree_DeleteJobName, ((GraphSettings)o).getShortName()), null, "org.netxms.ui.eclipse.perfview", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    TemplateGraphView.this.session.deletePredefinedGraph(((GraphSettings)o).getId());
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.PredefinedGraphTree_DeleteJobError;
                }
            }.start();
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionAdd);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAdd);
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TemplateGraphView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionAdd);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        Messages.get();
        new ConsoleJob(Messages.HistoricalDataView_RefreshJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List settings = TemplateGraphView.this.session.getPredefinedGraphs(true);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).TemplateGraphView.this.graphList = settings;
                        TemplateGraphView.this.viewer.setInput((Object)(this).TemplateGraphView.this.graphList.toArray());
                        TemplateGraphView.this.updateInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                return String.format("Error getting ", new Object[0]);
            }
        }.start();
    }

    private boolean showGraphPropertyPages(final GraphSettings settings) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("graph", (IPreferencePage)new Graph(settings, true)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new General(settings, true)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("filter", (IPreferencePage)new Filter((ObjectAction)settings)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("template", (IPreferencePage)new TemplateDataSources(settings, true)));
        PreferenceDialog dlg = new PreferenceDialog(this.getViewSite().getShell(), pm){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText("Properties for " + settings.getDisplayName());
            }
        };
        dlg.setBlockOnOpen(true);
        return dlg.open() == 0;
    }
}

