/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.SshKeyPair;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.dialogs.CerateKeyNameDialog;
import org.netxms.ui.eclipse.serverconfig.dialogs.EditSshKeysDialog;
import org.netxms.ui.eclipse.serverconfig.views.helpers.SSHKeyLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.ObjectLabelComparator;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class SshKeyConfigurator
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.SshKeyConfigurator";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NMAE = 1;
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionCopyToClipboard;
    private Action actionImport;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionGenerateNew;
    private NXCSession session;
    private SessionListener listener;
    private List<SshKeyPair> keyList;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
    }

    public void createPartControl(Composite parent) {
        String[] setColumnNames = new String[]{"ID", "Name"};
        int[] setColumnWidths = new int[]{150, 250};
        this.viewer = new SortableTableViewer(parent, setColumnNames, setColumnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SSHKeyLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ObjectLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = ((IStructuredSelection)SshKeyConfigurator.this.viewer.getSelection()).size();
                SshKeyConfigurator.this.actionCopyToClipboard.setEnabled(size == 1);
                SshKeyConfigurator.this.actionEdit.setEnabled(size == 1);
                SshKeyConfigurator.this.actionDelete.setEnabled(size > 0);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SshKeyConfigurator.this.actionEdit.run();
            }
        });
        this.activateContext();
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refresh();
        final Display display = this.getSite().getShell().getDisplay();
        this.listener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 1053) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SshKeyConfigurator.this.refresh();
                        }
                    });
                }
            }
        };
        this.session.addListener(this.listener);
    }

    public void dispose() {
        if (this.listener != null && this.session != null) {
            this.session.removeListener(this.listener);
        }
        super.dispose();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SshKeyConfigurator.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1) {
            mgr.add((IAction)this.actionCopyToClipboard);
            mgr.add((IAction)this.actionEdit);
        }
        if (selection.size() > 0) {
            mgr.add((IAction)this.actionDelete);
        }
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionImport);
        mgr.add((IAction)this.actionGenerateNew);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionImport);
        manager.add((IAction)this.actionGenerateNew);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionImport);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                SshKeyConfigurator.this.refresh();
            }
        };
        this.actionImport = new Action("Import new", SharedIcons.ADD_OBJECT){

            public void run() {
                SshKeyConfigurator.this.importKeys();
            }
        };
        this.actionGenerateNew = new Action("Generate new", SharedIcons.ADD_OBJECT){

            public void run() {
                SshKeyConfigurator.this.generateKeys();
            }
        };
        this.actionEdit = new Action("Edit", SharedIcons.EDIT){

            public void run() {
                SshKeyConfigurator.this.editKey();
            }
        };
        this.actionDelete = new Action("Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                SshKeyConfigurator.this.deleteKey();
            }
        };
        this.actionCopyToClipboard = new Action("Copy public key to clipboard", SharedIcons.COPY){

            public void run() {
                SshKeyConfigurator.this.copyToClipboard();
            }
        };
        this.actionCopyToClipboard.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.copy_key_task");
        handlerService.activateHandler(this.actionCopyToClipboard.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionEdit));
    }

    private void refresh() {
        new ConsoleJob("Reloading SSH key list", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List list = SshKeyConfigurator.this.session.getSshKeys(true);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SshKeyConfigurator.this.keyList = list;
                        SshKeyConfigurator.this.viewer.setInput((Object)SshKeyConfigurator.this.keyList.toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get list of SSH key";
            }
        }.start();
    }

    protected void copyToClipboard() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        SshKeyPair key = (SshKeyPair)selection.getFirstElement();
        WidgetHelper.copyToClipboard((String)key.getPublicKey());
    }

    protected void deleteKey() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.size() == 0) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Delete Confirmation", (String)"Are you sure you want to delete selected SSH keys?")) {
            return;
        }
        final ArrayList<SshKeyPair> list = new ArrayList<SshKeyPair>(selection.size());
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            list.add((SshKeyPair)it.next());
        }
        new ConsoleJob("Delete SSH key", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (final SshKeyPair key : list) {
                    try {
                        SshKeyConfigurator.this.session.deleteSshKey(key.getId(), false);
                    }
                    catch (NXCException e) {
                        if (e.getErrorCode() != 143) {
                            throw e;
                        }
                        final boolean[] retry = new boolean[1];
                        this.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                List nodes = SshKeyConfigurator.this.session.findMultipleObjects(e.getRelatedObjects(), false);
                                StringBuilder sb = new StringBuilder();
                                int i = 0;
                                while (i < nodes.size()) {
                                    sb.append(((AbstractObject)nodes.get(i)).getObjectName());
                                    if (i + 1 != nodes.size()) {
                                        sb.append(", ");
                                    }
                                    ++i;
                                }
                                retry[0] = MessageDialogHelper.openQuestion((Shell)SshKeyConfigurator.this.getSite().getShell(), (String)"Confirm Delete", (String)String.format("SSH key \"%s\" is in use by %s node(s). Are you sure you want to delete it?", key.getName(), sb.toString()));
                            }
                        });
                        if (!retry[0]) continue;
                        SshKeyConfigurator.this.session.deleteSshKey(key.getId(), true);
                    }
                }
            }

            protected String getErrorMessage() {
                return "Cannot delete SSH key";
            }
        }.start();
    }

    protected void editKey() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        SshKeyPair key = (SshKeyPair)selection.getFirstElement();
        final EditSshKeysDialog dlg = new EditSshKeysDialog(this.getSite().getShell(), new SshKeyPair(key));
        if (dlg.open() != 0) {
            return;
        }
        new ConsoleJob("Edit SSH key", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                SshKeyConfigurator.this.session.updateSshKey(dlg.getSshKeyData());
            }

            protected String getErrorMessage() {
                return "Cannot update SSH key";
            }
        }.start();
    }

    protected void importKeys() {
        final EditSshKeysDialog dlg = new EditSshKeysDialog(this.getSite().getShell(), null);
        if (dlg.open() != 0) {
            return;
        }
        new ConsoleJob("Import SSH keys", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                SshKeyConfigurator.this.session.updateSshKey(dlg.getSshKeyData());
            }

            protected String getErrorMessage() {
                return "Cannot import SSH keys";
            }
        }.start();
    }

    private void generateKeys() {
        final CerateKeyNameDialog dlg = new CerateKeyNameDialog(this.getSite().getShell());
        if (dlg.open() != 0) {
            return;
        }
        new ConsoleJob("Generate SSH keys", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                SshKeyConfigurator.this.session.generateSshKeys(dlg.getName());
            }

            protected String getErrorMessage() {
                return "Cannot generate SSH keys";
            }
        }.start();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.serverconfig.context.SshKeyConfigurator");
        }
    }
}

