/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.propertypages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.ClusterResource;
import org.netxms.client.objects.Node;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.client.snmp.SnmpVersion;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.IParameterSelectionDialog;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectAgentParamDlg;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectInternalParamDlg;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectParameterScriptDialog;
import org.netxms.ui.eclipse.datacollection.dialogs.SelectSnmpParamDlg;
import org.netxms.ui.eclipse.datacollection.propertypages.helpers.AbstractDCIPropertyPage;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class GeneralTable
extends AbstractDCIPropertyPage {
    private DataCollectionTable dci;
    private AbstractObject owner;
    private Cluster cluster = null;
    private Map<Integer, Long> clusterResourceMap;
    private Text description;
    private LabeledText parameter;
    private Button selectButton;
    private Combo origin;
    private Button checkUseCustomSnmpPort;
    private Spinner customSnmpPort;
    private Button checkUseCustomSnmpVersion;
    private Combo customSnmpVersion;
    private ObjectSelector sourceNode;
    private Combo agentCacheMode;
    private Combo schedulingMode;
    private Combo retentionMode;
    private LabeledText pollingInterval;
    private LabeledText retentionTime;
    private Combo clusterResource;

    @Override
    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsTable();
        NXCSession session = ConsoleSharedData.getSession();
        this.owner = session.findObjectById(this.dci.getNodeId());
        if (this.owner instanceof Cluster) {
            this.cluster = (Cluster)this.owner;
        } else if (this.owner instanceof AbstractNode) {
            AbstractObject[] abstractObjectArray = this.owner.getParentsAsArray();
            int n = abstractObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractObject o = abstractObjectArray[n2];
                if (o instanceof Cluster) {
                    this.cluster = (Cluster)o;
                    break;
                }
                ++n2;
            }
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Group groupDescription = new Group(dialogArea, 0);
        Messages.get();
        groupDescription.setText(Messages.GeneralTable_Description);
        FillLayout descriptionLayout = new FillLayout();
        descriptionLayout.marginWidth = 4;
        descriptionLayout.marginHeight = 4;
        groupDescription.setLayout((Layout)descriptionLayout);
        this.description = new Text((Composite)groupDescription, 2048);
        this.description.setTextLimit(255);
        this.description.setText(this.dci.getDescription());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        groupDescription.setLayoutData((Object)gd);
        Group groupData = new Group(dialogArea, 0);
        Messages.get();
        groupData.setText(Messages.GeneralTable_Data);
        FormLayout dataLayout = new FormLayout();
        dataLayout.marginHeight = 4;
        dataLayout.marginWidth = 4;
        groupData.setLayout((Layout)dataLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        groupData.setLayoutData((Object)gd);
        this.parameter = new LabeledText((Composite)groupData, 0);
        Messages.get();
        this.parameter.setLabel(Messages.GeneralTable_Parameter);
        this.parameter.getTextControl().setTextLimit(255);
        this.parameter.setText(this.dci.getName());
        this.selectButton = new Button((Composite)groupData, 8);
        Messages.get();
        this.selectButton.setText(Messages.GeneralTable_Select);
        this.selectButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                GeneralTable.this.selectParameter();
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment((Control)this.selectButton, -2, 16384);
        this.parameter.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment((Control)this.parameter, 0, 1024);
        fd.width = 90;
        this.selectButton.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.parameter, 4, 1024);
        fd.right = new FormAttachment(40, -2);
        Messages.get();
        this.origin = WidgetHelper.createLabeledCombo((Composite)groupData, (int)8, (String)Messages.GeneralTable_Origin, (Object)fd);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceInternal);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceAgent);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceSNMP);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceWebService);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourcePush);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceWinPerf);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceILO);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceScript);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceSSH);
        Messages.get();
        this.origin.add(Messages.DciLabelProvider_SourceMQTT);
        this.origin.select(this.dci.getOrigin().getValue());
        this.origin.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                GeneralTable.this.onOriginChange();
            }
        });
        this.checkUseCustomSnmpPort = new Button((Composite)groupData, 32);
        Messages.get();
        this.checkUseCustomSnmpPort.setText(Messages.GeneralTable_UseCustomSNMPPort);
        this.checkUseCustomSnmpPort.setSelection(this.dci.getSnmpPort() != 0);
        this.checkUseCustomSnmpPort.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneralTable.this.customSnmpPort.setEnabled(GeneralTable.this.checkUseCustomSnmpPort.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.origin.getParent(), 4, 131072);
        fd.top = new FormAttachment((Control)this.parameter, 4, 1024);
        this.checkUseCustomSnmpPort.setLayoutData((Object)fd);
        this.checkUseCustomSnmpPort.setEnabled(this.dci.getOrigin() == DataOrigin.SNMP);
        this.customSnmpPort = new Spinner((Composite)groupData, 2048);
        this.customSnmpPort.setMinimum(1);
        this.customSnmpPort.setMaximum(65535);
        if (this.dci.getOrigin() == DataOrigin.SNMP && this.dci.getSnmpPort() != 0) {
            this.customSnmpPort.setEnabled(true);
            this.customSnmpPort.setSelection(this.dci.getSnmpPort());
        } else {
            this.customSnmpPort.setEnabled(false);
        }
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.origin.getParent(), 4, 131072);
        fd.right = new FormAttachment((Control)this.checkUseCustomSnmpPort, 0, 131072);
        fd.top = new FormAttachment((Control)this.checkUseCustomSnmpPort, 4, 1024);
        this.customSnmpPort.setLayoutData((Object)fd);
        this.checkUseCustomSnmpVersion = new Button((Composite)groupData, 32);
        this.checkUseCustomSnmpVersion.setText("Use custom SNMP version:");
        this.checkUseCustomSnmpVersion.setSelection(this.dci.getSnmpVersion() != SnmpVersion.DEFAULT);
        this.checkUseCustomSnmpVersion.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneralTable.this.customSnmpVersion.setEnabled(GeneralTable.this.checkUseCustomSnmpVersion.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.checkUseCustomSnmpPort, 4, 131072);
        fd.top = new FormAttachment((Control)this.parameter, 4, 1024);
        fd.right = new FormAttachment(100, 0);
        this.checkUseCustomSnmpVersion.setLayoutData((Object)fd);
        this.checkUseCustomSnmpVersion.setEnabled(this.dci.getOrigin() == DataOrigin.SNMP);
        this.customSnmpVersion = new Combo((Composite)groupData, 2056);
        this.customSnmpVersion.add("1");
        this.customSnmpVersion.add("2c");
        this.customSnmpVersion.add("3");
        this.customSnmpVersion.select(GeneralTable.indexFromSnmpVersion(this.dci.getSnmpVersion()));
        this.customSnmpVersion.setEnabled(this.dci.getSnmpVersion() != SnmpVersion.DEFAULT);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.checkUseCustomSnmpPort, 4, 131072);
        fd.top = new FormAttachment((Control)this.checkUseCustomSnmpVersion, 4, 1024);
        fd.right = new FormAttachment(100, 0);
        this.customSnmpVersion.setLayoutData((Object)fd);
        this.sourceNode = new ObjectSelector((Composite)groupData, 0, true);
        Messages.get();
        this.sourceNode.setLabel(Messages.GeneralTable_ProxyNode);
        this.sourceNode.setObjectClass(Node.class);
        this.sourceNode.setObjectId(this.dci.getSourceNode());
        this.sourceNode.setEnabled(this.dci.getOrigin() != DataOrigin.PUSH);
        this.sourceNode.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralTable.this.editor.setSourceNode(GeneralTable.this.sourceNode.getObjectId());
            }
        });
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.customSnmpPort, 4, 1024);
        fd.right = new FormAttachment(100, 0);
        Messages.get();
        this.agentCacheMode = WidgetHelper.createLabeledCombo((Composite)groupData, (int)8, (String)Messages.GeneralTable_AgentCacheMode, (Object)fd);
        Messages.get();
        this.agentCacheMode.add(Messages.GeneralTable_Default);
        Messages.get();
        this.agentCacheMode.add(Messages.GeneralTable_On);
        Messages.get();
        this.agentCacheMode.add(Messages.GeneralTable_Off);
        this.agentCacheMode.select(this.dci.getCacheMode().getValue());
        this.agentCacheMode.setEnabled(this.dci.getOrigin() == DataOrigin.AGENT || this.dci.getOrigin() == DataOrigin.SNMP);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.customSnmpPort, 4, 1024);
        fd.right = new FormAttachment((Control)this.agentCacheMode.getParent(), -4, 16384);
        this.sourceNode.setLayoutData((Object)fd);
        Group groupPolling = new Group(dialogArea, 0);
        Messages.get();
        groupPolling.setText(Messages.GeneralTable_Polling);
        FormLayout pollingLayout = new FormLayout();
        pollingLayout.marginHeight = 4;
        pollingLayout.marginWidth = 4;
        groupPolling.setLayout((Layout)pollingLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        groupPolling.setLayoutData((Object)gd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(50, -2);
        fd.top = new FormAttachment(0, 0);
        Messages.get();
        this.schedulingMode = WidgetHelper.createLabeledCombo((Composite)groupPolling, (int)8, (String)Messages.GeneralTable_PollingMode, (Object)fd);
        Messages.get();
        this.schedulingMode.add(Messages.General_FixedIntervalsDefault);
        Messages.get();
        this.schedulingMode.add(Messages.General_FixedIntervalsCustom);
        Messages.get();
        this.schedulingMode.add(Messages.General_CustomSchedule);
        this.schedulingMode.select(this.dci.getPollingScheduleType());
        this.schedulingMode.setEnabled(this.dci.getOrigin() != DataOrigin.PUSH);
        this.schedulingMode.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                GeneralTable.this.pollingInterval.setEnabled(GeneralTable.this.schedulingMode.getSelectionIndex() == 1);
            }
        });
        this.pollingInterval = new LabeledText((Composite)groupPolling, 0);
        Messages.get();
        this.pollingInterval.setLabel(Messages.General_PollingInterval);
        this.pollingInterval.setText(this.dci.getPollingInterval());
        this.pollingInterval.setEnabled(this.dci.getPollingScheduleType() == 1 && this.dci.getOrigin() != DataOrigin.PUSH);
        fd = new FormData();
        fd.left = new FormAttachment(50, 2);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        this.pollingInterval.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.schedulingMode.getParent(), 4, 1024);
        Messages.get();
        this.clusterResource = WidgetHelper.createLabeledCombo((Composite)groupPolling, (int)8, (String)Messages.GeneralTable_ClRes, (Object)fd);
        if (this.cluster != null) {
            this.clusterResourceMap = new HashMap<Integer, Long>();
            this.clusterResourceMap.put(0, 0L);
            Messages.get();
            this.clusterResource.add(Messages.GeneralTable_None);
            if (this.dci.getResourceId() == 0L) {
                this.clusterResource.select(0);
            }
            int index = 1;
            for (ClusterResource r : this.cluster.getResources()) {
                this.clusterResource.add(r.getName());
                this.clusterResourceMap.put(index, r.getId());
                if (this.dci.getResourceId() == r.getId()) {
                    this.clusterResource.select(index);
                }
                ++index;
            }
        } else {
            Messages.get();
            this.clusterResource.add(Messages.GeneralTable_None);
            this.clusterResource.select(0);
            this.clusterResource.setEnabled(false);
        }
        Group groupStorage = new Group(dialogArea, 0);
        Messages.get();
        groupStorage.setText(Messages.GeneralTable_Storage);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.horizontalSpan = 2;
        groupStorage.setLayoutData((Object)gd);
        GridLayout storageLayout = new GridLayout();
        storageLayout.numColumns = 2;
        storageLayout.horizontalSpacing = 4;
        groupStorage.setLayout((Layout)storageLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        Messages.get();
        this.retentionMode = WidgetHelper.createLabeledCombo((Composite)groupStorage, (int)8, (String)Messages.GeneralTable_RetentionMode, (Object)gd);
        Messages.get();
        this.retentionMode.add(Messages.GeneralTable_UseDefaultRetention);
        Messages.get();
        this.retentionMode.add(Messages.GeneralTable_UseCustomRetention);
        Messages.get();
        this.retentionMode.add(Messages.GeneralTable_NoStorage);
        this.retentionMode.select(this.dci.getRetentionType());
        this.retentionMode.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                int mode = GeneralTable.this.retentionMode.getSelectionIndex();
                GeneralTable.this.retentionTime.setEnabled(mode == 1);
            }
        });
        this.retentionTime = new LabeledText((Composite)groupStorage, 0);
        Messages.get();
        this.retentionTime.setLabel(Messages.GeneralTable_RetentionTime);
        this.retentionTime.setText(this.dci.getRetentionTime());
        this.retentionTime.setEnabled(this.dci.getRetentionType() == 1);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.retentionTime.setLayoutData((Object)gd);
        return dialogArea;
    }

    private static int indexFromSnmpVersion(SnmpVersion version) {
        switch (version) {
            case V1: {
                return 0;
            }
            case V2C: {
                return 1;
            }
            case V3: {
                return 2;
            }
        }
        return -1;
    }

    private static SnmpVersion indexToSnmpVersion(int index) {
        switch (index) {
            case 0: {
                return SnmpVersion.V1;
            }
            case 1: {
                return SnmpVersion.V2C;
            }
            case 2: {
                return SnmpVersion.V3;
            }
        }
        return SnmpVersion.DEFAULT;
    }

    private void onOriginChange() {
        DataOrigin dataOrigin = DataOrigin.getByValue((int)this.origin.getSelectionIndex());
        this.sourceNode.setEnabled(dataOrigin != DataOrigin.PUSH);
        this.schedulingMode.setEnabled(dataOrigin != DataOrigin.PUSH && dataOrigin != DataOrigin.MQTT);
        this.pollingInterval.setEnabled(dataOrigin != DataOrigin.PUSH && dataOrigin != DataOrigin.MQTT && this.schedulingMode.getSelectionIndex() == 1);
        this.checkUseCustomSnmpPort.setEnabled(dataOrigin == DataOrigin.SNMP);
        this.customSnmpPort.setEnabled(dataOrigin == DataOrigin.SNMP && this.checkUseCustomSnmpPort.getSelection());
        this.checkUseCustomSnmpVersion.setEnabled(dataOrigin == DataOrigin.SNMP);
        this.customSnmpVersion.setEnabled(dataOrigin == DataOrigin.SNMP && this.checkUseCustomSnmpVersion.getSelection());
        this.agentCacheMode.setEnabled(dataOrigin == DataOrigin.AGENT || dataOrigin == DataOrigin.SNMP);
        this.selectButton.setEnabled(dataOrigin == DataOrigin.AGENT || dataOrigin == DataOrigin.SNMP || dataOrigin == DataOrigin.INTERNAL || dataOrigin == DataOrigin.WINPERF || dataOrigin == DataOrigin.WEB_SERVICE || dataOrigin == DataOrigin.SCRIPT);
    }

    private void selectParameter() {
        IParameterSelectionDialog dlg;
        this.editor.setSourceNode(this.sourceNode.getObjectId());
        DataOrigin dataOrigin = DataOrigin.getByValue((int)this.origin.getSelectionIndex());
        switch (dataOrigin) {
            case INTERNAL: {
                if (this.sourceNode.getObjectId() != 0L) {
                    dlg = new SelectInternalParamDlg(this.getShell(), this.sourceNode.getObjectId(), true);
                    break;
                }
                dlg = new SelectInternalParamDlg(this.getShell(), this.dci.getNodeId(), true);
                break;
            }
            case AGENT: {
                if (this.sourceNode.getObjectId() != 0L) {
                    dlg = new SelectAgentParamDlg(this.getShell(), this.sourceNode.getObjectId(), dataOrigin, true);
                    break;
                }
                dlg = new SelectAgentParamDlg(this.getShell(), this.dci.getNodeId(), dataOrigin, true);
                break;
            }
            case SNMP: {
                SnmpObjectId oid;
                try {
                    oid = SnmpObjectId.parseSnmpObjectId((String)this.parameter.getText());
                }
                catch (SnmpObjectIdFormatException e) {
                    oid = null;
                }
                if (this.sourceNode.getObjectId() != 0L) {
                    dlg = new SelectSnmpParamDlg(this.getShell(), oid, this.sourceNode.getObjectId());
                    break;
                }
                dlg = new SelectSnmpParamDlg(this.getShell(), oid, this.dci.getNodeId());
                break;
            }
            case SCRIPT: {
                dlg = new SelectParameterScriptDialog(this.getShell());
                break;
            }
            default: {
                dlg = null;
            }
        }
        if (dlg != null && dlg.open() == 0) {
            IParameterSelectionDialog pd = dlg;
            this.description.setText(pd.getParameterDescription());
            this.parameter.setText(pd.getParameterName());
            this.editor.fireOnSelectTableListeners(DataOrigin.getByValue((int)this.origin.getSelectionIndex()), pd.getParameterName(), pd.getParameterDescription());
        }
    }

    protected boolean applyChanges(boolean isApply) {
        this.dci.setDescription(this.description.getText().trim());
        this.dci.setName(this.parameter.getText().trim());
        this.dci.setOrigin(DataOrigin.getByValue((int)this.origin.getSelectionIndex()));
        this.dci.setSourceNode(this.sourceNode.getObjectId());
        this.dci.setCacheMode(AgentCacheMode.getByValue((int)this.agentCacheMode.getSelectionIndex()));
        this.dci.setPollingScheduleType(this.schedulingMode.getSelectionIndex());
        this.dci.setPollingInterval(this.schedulingMode.getSelectionIndex() == 1 ? this.pollingInterval.getText() : null);
        this.dci.setRetentionType(this.retentionMode.getSelectionIndex());
        this.dci.setRetentionTime(this.retentionMode.getSelectionIndex() == 1 ? this.retentionTime.getText() : null);
        if (this.checkUseCustomSnmpPort.getSelection()) {
            this.dci.setSnmpPort(Integer.parseInt(this.customSnmpPort.getText()));
        } else {
            this.dci.setSnmpPort(0);
        }
        if (this.checkUseCustomSnmpVersion.getSelection()) {
            this.dci.setSnmpVersion(GeneralTable.indexToSnmpVersion(this.customSnmpVersion.getSelectionIndex()));
        } else {
            this.dci.setSnmpVersion(SnmpVersion.DEFAULT);
        }
        if (this.cluster != null) {
            this.dci.setResourceId(this.clusterResourceMap.get(this.clusterResource.getSelectionIndex()).longValue());
        }
        this.editor.modify();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        NXCSession session = ConsoleSharedData.getSession();
        this.schedulingMode.select(0);
        this.pollingInterval.setText(Integer.toString(session.getDefaultDciPollingInterval()));
        this.retentionMode.select(0);
        this.retentionTime.setText(Integer.toString(session.getDefaultDciRetentionTime()));
        this.checkUseCustomSnmpPort.setSelection(false);
    }
}

