/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.datacollection.LocalChangeListener;
import org.netxms.client.datacollection.RemoteChangeListener;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.Template;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.api.DataCollectionObjectEditor;
import org.netxms.ui.eclipse.datacollection.dialogs.BulkUpdateDialog;
import org.netxms.ui.eclipse.datacollection.dialogs.helpers.BulkDciUpdateElementUI;
import org.netxms.ui.eclipse.datacollection.views.helpers.DciComparator;
import org.netxms.ui.eclipse.datacollection.views.helpers.DciFilter;
import org.netxms.ui.eclipse.datacollection.views.helpers.DciLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.DialogData;
import org.netxms.ui.eclipse.tools.ExtendedPropertyDialog;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class DataCollectionEditor
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.datacollection.view.data_collection_editor";
    public static final String JOB_FAMILY = "DataCollectionEditorJob";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_ORIGIN = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    public static final int COLUMN_PARAMETER = 3;
    public static final int COLUMN_DATATYPE = 4;
    public static final int COLUMN_INTERVAL = 5;
    public static final int COLUMN_RETENTION = 6;
    public static final int COLUMN_STATUS = 7;
    public static final int COLUMN_THRESHOLD = 8;
    public static final int COLUMN_TEMPLATE = 9;
    public static final int COLUMN_RELATEDOBJ = 10;
    public static final int COLUMN_STATUSCALC = 11;
    private CompositeWithMessageBar viewerContainer;
    private FilterText filterText;
    private SortableTableViewer viewer;
    private NXCSession session;
    private IDialogSettings settings;
    private AbstractObject object;
    private DataCollectionConfiguration dciConfig = null;
    private DciFilter filter;
    private Action actionCreateItem;
    private Action actionCreateTable;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionCopy;
    private Action actionMove;
    private Action actionConvert;
    private Action actionDuplicate;
    private Action actionActivate;
    private Action actionDisable;
    private Action actionShowFilter;
    private RefreshAction actionRefresh;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private Action actionBulkUpdate;
    private boolean hideModificationWarnings;
    private RemoteChangeListener changeListener;

    public void init(IViewSite site) throws PartInitException {
        String string;
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        AbstractObject obj = this.session.findObjectById(Long.parseLong(site.getSecondaryId()));
        this.settings = Activator.getDefault().getDialogSettings();
        this.object = obj != null && (obj instanceof DataCollectionTarget || obj instanceof Template) ? obj : null;
        Messages.get();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.DataCollectionEditor_PartNamePrefix));
        if (this.object != null) {
            string = this.object.getObjectName();
        } else {
            Messages.get();
            string = Messages.DataCollectionEditor_Error;
        }
        this.setPartName(stringBuilder.append(string).toString());
        this.changeListener = new RemoteChangeListener(){

            public void onUpdate(DataCollectionObject object) {
                DataCollectionEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                    }
                });
            }

            public void onDelete(long id) {
                DataCollectionEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                    }
                });
            }

            public void onStatusChange(long id, int status) {
                DataCollectionEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.viewer.refresh();
                    }
                });
            }
        };
    }

    private boolean getBooleanFromSettings(String name, boolean defval) {
        String v = this.settings.get(name);
        return v != null ? Boolean.valueOf(v) : defval;
    }

    public void createPartControl(Composite parent) {
        this.viewerContainer = new CompositeWithMessageBar(parent, 0){

            protected Composite createContent(Composite parent) {
                Composite content = super.createContent(parent);
                content.setLayout((Layout)new FormLayout());
                return content;
            }
        };
        this.filterText = new FilterText(this.viewerContainer.getContent(), 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataCollectionEditor.this.onFilterModify();
            }
        });
        String[] stringArray = new String[12];
        Messages.get();
        stringArray[0] = Messages.DataCollectionEditor_ColID;
        Messages.get();
        stringArray[1] = Messages.DataCollectionEditor_ColOrigin;
        Messages.get();
        stringArray[2] = Messages.DataCollectionEditor_ColDescription;
        Messages.get();
        stringArray[3] = Messages.DataCollectionEditor_ColParameter;
        Messages.get();
        stringArray[4] = Messages.DataCollectionEditor_ColDataType;
        Messages.get();
        stringArray[5] = Messages.DataCollectionEditor_ColPollingInterval;
        Messages.get();
        stringArray[6] = Messages.DataCollectionEditor_ColRetentionTime;
        Messages.get();
        stringArray[7] = Messages.DataCollectionEditor_ColStatus;
        Messages.get();
        stringArray[8] = Messages.DataCollectionEditor_ColThresholds;
        Messages.get();
        stringArray[9] = Messages.DataCollectionEditor_ColTemplate;
        stringArray[10] = "Related Object";
        stringArray[11] = "Is status calculation";
        String[] names = stringArray;
        int[] widths = new int[]{60, 100, 250, 200, 90, 90, 90, 100, 200, 150, 150, 90};
        this.viewer = new SortableTableViewer(this.viewerContainer.getContent(), names, widths, 0, 128, -1);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DciLabelProvider());
        this.viewer.setComparator((ViewerComparator)new DciComparator((DciLabelProvider)this.viewer.getLabelProvider()));
        this.filter = new DciFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)this.settings, (String)"DataCollectionEditor");
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    DataCollectionEditor.this.actionEdit.setEnabled(selection.size() == 1);
                    DataCollectionEditor.this.actionDelete.setEnabled(selection.size() > 0);
                    DataCollectionEditor.this.actionCopy.setEnabled(selection.size() > 0);
                    DataCollectionEditor.this.actionMove.setEnabled(selection.size() > 0);
                    DataCollectionEditor.this.actionConvert.setEnabled(selection.size() > 0);
                    DataCollectionEditor.this.actionDuplicate.setEnabled(selection.size() > 0);
                    DataCollectionEditor.this.actionBulkUpdate.setEnabled(selection.size() > 0);
                    Iterator it = selection.iterator();
                    boolean canActivate = false;
                    boolean canDisable = false;
                    while (!(!it.hasNext() || canActivate && canDisable)) {
                        DataCollectionObject dci = (DataCollectionObject)it.next();
                        if (dci.getStatus() != 0) {
                            canActivate = true;
                        }
                        if (dci.getStatus() == 1) continue;
                        canDisable = true;
                    }
                    DataCollectionEditor.this.actionActivate.setEnabled(canActivate);
                    DataCollectionEditor.this.actionDisable.setEnabled(canDisable);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DataCollectionEditor.this.actionEdit.run();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)DataCollectionEditor.this.viewer, (IDialogSettings)DataCollectionEditor.this.settings, (String)"DataCollectionEditor");
                DataCollectionEditor.this.settings.put("DataCollectionEditor.hideModificationWarnings", DataCollectionEditor.this.hideModificationWarnings);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.filterText.setCloseAction(new Action(){

            public void run() {
                DataCollectionEditor.this.enableFilter(false);
                DataCollectionEditor.this.actionShowFilter.setChecked(false);
            }
        });
        Messages.get();
        new ConsoleJob(String.valueOf(Messages.DataCollectionEditor_OpenJob_Title) + this.object.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DataCollectionEditor.this.dciConfig = DataCollectionEditor.this.session.openDataCollectionConfiguration(DataCollectionEditor.this.object.getObjectId(), DataCollectionEditor.this.changeListener);
                DataCollectionEditor.this.dciConfig.setUserData((Object)DataCollectionEditor.this.viewer);
                if (DataCollectionEditor.this.object instanceof Template) {
                    DataCollectionEditor.this.dciConfig.setLocalChangeCallback(new LocalChangeListener(){

                        public void onObjectChange() {
                            this.runInUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    DataCollectionEditor.this.showInformationMessage();
                                }
                            });
                        }
                    });
                }
                if (!DataCollectionEditor.this.session.areObjectsSynchronized()) {
                    ArrayList<Long> relatedOpbjects = new ArrayList<Long>();
                    DataCollectionObject[] dataCollectionObjectArray = DataCollectionEditor.this.dciConfig.getItems();
                    int n = dataCollectionObjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DataCollectionObject dco = dataCollectionObjectArray[n2];
                        if (dco.getRelatedObject() != 0L) {
                            relatedOpbjects.add(dco.getRelatedObject());
                        }
                        ++n2;
                    }
                    if (relatedOpbjects.size() > 0) {
                        DataCollectionEditor.this.session.syncMissingObjects(relatedOpbjects, true, 2);
                    }
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                    }
                });
            }

            protected void jobFailureHandler() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.getViewSite().getPage().hideView((IViewPart)DataCollectionEditor.this);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.valueOf(Messages.DataCollectionEditor_OpenJob_Error) + DataCollectionEditor.this.object.getObjectName();
            }
        }.start();
        if (this.actionShowFilter.isChecked()) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.hideModificationWarnings = this.getBooleanFromSettings("DataCollectionEditor.hideModificationWarnings", false);
        this.activateContext();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.datacollection.context.LastValues");
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCreateItem);
        manager.add((IAction)this.actionCreateTable);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionBulkUpdate);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionMove);
        if (!(this.object instanceof Template)) {
            manager.add((IAction)this.actionConvert);
        }
        manager.add((IAction)this.actionDuplicate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionActivate);
        manager.add((IAction)this.actionDisable);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("secondary"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
        manager.add((IAction)this.actionExportAllToCsv);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionShowFilter);
        manager.add((IAction)this.actionCreateItem);
        manager.add((IAction)this.actionRefresh);
        manager.add((IAction)this.actionExportAllToCsv);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCreateItem);
        manager.add((IAction)this.actionCreateTable);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionBulkUpdate);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionMove);
        if (!(this.object instanceof Template)) {
            manager.add((IAction)this.actionConvert);
        }
        manager.add((IAction)this.actionDuplicate);
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionActivate);
        manager.add((IAction)this.actionDisable);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("secondary"));
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction(){

            public void run() {
                DataCollectionEditor.this.refresh();
            }
        };
        Messages.get();
        this.actionCreateItem = new Action(Messages.DataCollectionEditor_NewParam, Activator.getImageDescriptor("icons/new.png")){

            public void run() {
                DataCollectionEditor.this.createItem();
            }
        };
        Messages.get();
        this.actionCreateTable = new Action(Messages.DataCollectionEditor_NewTable){

            public void run() {
                DataCollectionEditor.this.createTable();
            }
        };
        Messages.get();
        this.actionEdit = new Action(Messages.DataCollectionEditor_ActionEdit, SharedIcons.EDIT){

            public void run() {
                DataCollectionEditor.this.editSelectedObject();
            }
        };
        Messages.get();
        this.actionEdit.setText(Messages.DataCollectionEditor_Edit);
        this.actionEdit.setImageDescriptor(Activator.getImageDescriptor("icons/edit.png"));
        this.actionEdit.setEnabled(false);
        this.actionBulkUpdate = new Action("Bulk update..."){

            public void run() {
                DataCollectionEditor.this.openBulkUpdateDialog();
            }
        };
        Messages.get();
        this.actionDelete = new Action(Messages.DataCollectionEditor_Delete, Activator.getImageDescriptor("icons/delete.png")){

            public void run() {
                DataCollectionEditor.this.deleteItems();
            }
        };
        this.actionDelete.setEnabled(false);
        Messages.get();
        this.actionCopy = new Action(Messages.DataCollectionEditor_Copy){

            public void run() {
                DataCollectionEditor.this.copyItems(false);
            }
        };
        this.actionCopy.setEnabled(false);
        Messages.get();
        this.actionMove = new Action(Messages.DataCollectionEditor_Move){

            public void run() {
                DataCollectionEditor.this.copyItems(true);
            }
        };
        this.actionMove.setEnabled(false);
        Messages.get();
        this.actionConvert = new Action(Messages.DataCollectionEditor_Convert){

            public void run() {
                DataCollectionEditor.this.convertToTemplate();
            }
        };
        this.actionConvert.setEnabled(false);
        Messages.get();
        this.actionDuplicate = new Action(Messages.DataCollectionEditor_Duplicate){

            public void run() {
                DataCollectionEditor.this.duplicateItems();
            }
        };
        this.actionDuplicate.setEnabled(false);
        Messages.get();
        this.actionActivate = new Action(Messages.DataCollectionEditor_Activate, Activator.getImageDescriptor("icons/active.gif")){

            public void run() {
                DataCollectionEditor.this.setItemStatus(0);
                DataCollectionEditor.this.actionActivate.setEnabled(false);
                DataCollectionEditor.this.actionDisable.setEnabled(true);
            }
        };
        this.actionActivate.setEnabled(false);
        Messages.get();
        this.actionDisable = new Action(Messages.DataCollectionEditor_Disable, Activator.getImageDescriptor("icons/disabled.gif")){

            public void run() {
                DataCollectionEditor.this.setItemStatus(1);
                DataCollectionEditor.this.actionActivate.setEnabled(true);
                DataCollectionEditor.this.actionDisable.setEnabled(false);
            }
        };
        this.actionDisable.setEnabled(false);
        Messages.get();
        this.actionShowFilter = new Action(Messages.DataCollectionEditor_ShowFilter, 2){

            public void run() {
                DataCollectionEditor.this.enableFilter(DataCollectionEditor.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.getBooleanFromSettings("DataCollectionEditor.showFilter", true));
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, false);
    }

    private void refresh() {
        new ConsoleJob("Reftesh data collection configuration for " + this.object.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DataCollectionEditor.this.dciConfig.refreshDataCollectionList();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                    }
                });
            }

            protected void jobFailureHandler() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.getViewSite().getPage().hideView((IViewPart)DataCollectionEditor.this);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot refresh data collection configuration for " + DataCollectionEditor.this.object.getObjectName();
            }
        }.start();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                DataCollectionEditor.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.dciConfig != null) {
            Messages.get();
            new ConsoleJob(String.valueOf(Messages.DataCollectionEditor_UnlockJob_Title) + this.object.getObjectName(), null, "org.netxms.ui.eclipse.datacollection", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    DataCollectionEditor.this.dciConfig.close();
                    DataCollectionEditor.this.dciConfig = null;
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return String.valueOf(Messages.DataCollectionEditor_UnlockJob_Error) + DataCollectionEditor.this.object.getObjectName();
                }
            }.start();
        }
        super.dispose();
    }

    private void setItemStatus(final int newStatus) {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() <= 0) {
            return;
        }
        Messages.get();
        new ConsoleJob(String.valueOf(Messages.DataCollectionEditor_ChStatusJob_Title) + this.object.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                long[] itemList = new long[selection.size()];
                int pos = 0;
                for (Object dci : selection.toList()) {
                    itemList[pos++] = ((DataCollectionObject)dci).getId();
                }
                DataCollectionEditor.this.dciConfig.setObjectStatus(itemList, newStatus);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (Object dci : selection.toList()) {
                            ((DataCollectionObject)dci).setStatus(newStatus);
                            DataCollectionEditor.this.viewer.update(dci, null);
                            new DataCollectionObjectEditor((DataCollectionObject)dci).modify();
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.valueOf(Messages.DataCollectionEditor_ChStatusJob_Error) + DataCollectionEditor.this.object.getObjectName();
            }
        }.start();
    }

    private void deleteItems() {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() <= 0) {
            return;
        }
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.DataCollectionEditor_DeleteConfirmTitle, (String)Messages.DataCollectionEditor_DeleteConfirmText)) {
            return;
        }
        Messages.get();
        new ConsoleJob(String.valueOf(Messages.DataCollectionEditor_DeleteJob_Title) + this.object.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Object dci : selection.toList()) {
                    DataCollectionEditor.this.dciConfig.deleteObject(((DataCollectionObject)dci).getId());
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.valueOf(Messages.DataCollectionEditor_DeleteJob_Error) + DataCollectionEditor.this.object.getObjectName();
            }
        }.start();
    }

    private void createItem() {
        DataCollectionItem dci = new DataCollectionItem(this.dciConfig, 0L);
        if (this.object instanceof AbstractNode && !((AbstractNode)this.object).hasAgent()) {
            if (((AbstractNode)this.object).hasSnmpAgent()) {
                dci.setOrigin(DataOrigin.SNMP);
            } else {
                dci.setOrigin(DataOrigin.INTERNAL);
            }
        }
        ExtendedPropertyDialog dlg = ExtendedPropertyDialog.createDialogOn((Shell)this.getSite().getShell(), null, (Object)dci, (String)"");
        dlg.createAllPages();
        dlg.open();
    }

    private void createTable() {
        DataCollectionTable dci = new DataCollectionTable(this.dciConfig, 0L);
        if (this.object instanceof AbstractNode && !((AbstractNode)this.object).hasAgent()) {
            if (((AbstractNode)this.object).hasSnmpAgent()) {
                dci.setOrigin(DataOrigin.SNMP);
            } else {
                dci.setOrigin(DataOrigin.INTERNAL);
            }
        }
        ExtendedPropertyDialog dlg = ExtendedPropertyDialog.createDialogOn((Shell)this.getSite().getShell(), null, (Object)dci, (String)"");
        dlg.createAllPages();
        dlg.open();
    }

    private void editSelectedObject() {
        String message;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        DataCollectionObject dco = (DataCollectionObject)selection.getFirstElement();
        DialogData data = null;
        if (!this.hideModificationWarnings && dco.getTemplateId() != 0L && (message = DataCollectionObjectEditor.createModificationWarningMessage(dco)) != null) {
            data = MessageDialogHelper.openWarningWithCheckbox((Shell)this.getSite().getShell(), (String)"Warning", (String)"Don't show this message again", (String)message);
            this.hideModificationWarnings = data.getSaveSelection();
        }
        if (data == null || data.isOkPressed()) {
            ExtendedPropertyDialog dlg = ExtendedPropertyDialog.createDialogOn((Shell)this.getSite().getShell(), null, (Object)dco, (String)"");
            dlg.createAllPages();
            dlg.open();
        }
    }

    private void duplicateItems() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        final long[] dciList = new long[selection.size()];
        int i = 0;
        while (i < dciList.length && it.hasNext()) {
            dciList[i] = ((DataCollectionObject)it.next()).getId();
            ++i;
        }
        Messages.get();
        new ConsoleJob(String.valueOf(Messages.DataCollectionEditor_DupJob_Title) + this.object.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DataCollectionEditor.this.dciConfig.copyObjects(DataCollectionEditor.this.dciConfig.getOwnerId(), dciList);
                DataCollectionEditor.this.dciConfig.close();
                DataCollectionEditor.this.dciConfig.open(DataCollectionEditor.this.changeListener);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.valueOf(Messages.DataCollectionEditor_DupJob_Error) + DataCollectionEditor.this.object.getObjectName();
            }
        }.start();
    }

    private void copyItems(final boolean doMove) {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), ObjectSelectionDialog.createDataCollectionOwnerSelectionFilter());
        if (dlg.open() != 0) {
            return;
        }
        final HashSet<AbstractObject> targets = new HashSet<AbstractObject>();
        for (AbstractObject o : dlg.getSelectedObjects()) {
            if (!(o instanceof DataCollectionTarget) && !(o instanceof Template)) continue;
            targets.add(o);
        }
        if (targets.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getSite().getShell(), (String)"Warning", (String)"Target selection is invalid or empty!");
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        final long[] dciList = new long[selection.size()];
        int i = 0;
        while (i < dciList.length && it.hasNext()) {
            dciList[i] = ((DataCollectionObject)it.next()).getId();
            ++i;
        }
        Messages.get();
        new ConsoleJob(String.valueOf(Messages.DataCollectionEditor_CopyJob_Title) + this.object.getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (AbstractObject o : targets) {
                    DataCollectionEditor.this.dciConfig.copyObjects(o.getObjectId(), dciList);
                }
                if (doMove) {
                    long[] lArray = dciList;
                    int n = dciList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        long id = lArray[n2];
                        DataCollectionEditor.this.dciConfig.deleteObject(id);
                        ++n2;
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.valueOf(Messages.DataCollectionEditor_CopyJob_Error) + DataCollectionEditor.this.object.getObjectName();
            }
        }.start();
    }

    private void openBulkUpdateDialog() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        final HashSet<Long> dciList = new HashSet<Long>(selection.size());
        boolean isCustomRetention = true;
        boolean isCustomInterval = true;
        for (DataCollectionObject dco : selection) {
            dciList.add(dco.getId());
            if (dco.getRetentionType() != 1) {
                isCustomRetention = false;
            }
            if (dco.getPollingScheduleType() == 1) continue;
            isCustomInterval = false;
        }
        BulkUpdateDialog dlg = new BulkUpdateDialog(this.getSite().getShell(), isCustomRetention, isCustomInterval);
        if (dlg.open() != 0) {
            return;
        }
        final List<BulkDciUpdateElementUI> elements = dlg.getBulkUpdateElements();
        boolean changed = false;
        for (BulkDciUpdateElementUI e : elements) {
            if (!e.isModified()) continue;
            changed = true;
        }
        if (!changed) {
            return;
        }
        new ConsoleJob("Bulk DCI update", (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DataCollectionEditor.this.dciConfig.bulkUpdateDCIs((Collection)dciList, (Collection)elements);
            }

            protected String getErrorMessage() {
                return "Failed to bulk update DCIs";
            }
        }.start();
    }

    private void convertToTemplate() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), ObjectSelectionDialog.createTemplateSelectionFilter());
        dlg.showFilterToolTip(false);
        if (dlg.open() != 0) {
            return;
        }
        AbstractObject[] objects = dlg.getSelectedObjects(Template.class);
        if (objects.length == 0) {
            return;
        }
        final Template template = (Template)objects[0];
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        final long[] dciList = new long[selection.size()];
        int i = 0;
        while (i < dciList.length && it.hasNext()) {
            dciList[i] = ((DataCollectionObject)it.next()).getId();
            ++i;
        }
        Messages.get();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.DataCollectionEditor_ConvertJob_TitlePrefix)).append(this.object.getObjectName());
        Messages.get();
        new ConsoleJob(stringBuilder.append(Messages.DataCollectionEditor_ConvertJob_TitleSuffix).toString(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int retries;
                long id;
                Messages.get();
                monitor.beginTask(Messages.DataCollectionEditor_ConvertJob_TaskName, 4);
                boolean needApply = true;
                long[] lArray = template.getChildIdList();
                int n = lArray.length;
                int n2 = 0;
                while (n2 < n) {
                    id = lArray[n2];
                    if (id == DataCollectionEditor.this.dciConfig.getOwnerId()) {
                        needApply = false;
                        break;
                    }
                    ++n2;
                }
                monitor.worked(1);
                DataCollectionEditor.this.dciConfig.copyObjects(template.getObjectId(), dciList);
                lArray = dciList;
                n = dciList.length;
                n2 = 0;
                while (n2 < n) {
                    id = lArray[n2];
                    DataCollectionEditor.this.dciConfig.deleteObject(id);
                    ++n2;
                }
                DataCollectionEditor.this.dciConfig.close();
                monitor.worked(1);
                if (needApply) {
                    boolean success = false;
                    retries = 5;
                    do {
                        try {
                            DataCollectionEditor.this.session.applyTemplate(template.getObjectId(), DataCollectionEditor.this.dciConfig.getOwnerId());
                            success = true;
                        }
                        catch (NXCException e) {
                            if (e.getErrorCode() != 1) {
                                throw e;
                            }
                            Thread.sleep(200L);
                        }
                    } while (!success && --retries > 0);
                }
                monitor.worked(1);
                boolean success = false;
                retries = 5;
                do {
                    try {
                        Thread.sleep(500L);
                        DataCollectionEditor.this.dciConfig.open(DataCollectionEditor.this.changeListener);
                        success = true;
                    }
                    catch (NXCException e) {
                        if (e.getErrorCode() == 1) continue;
                        throw e;
                    }
                } while (!success && --retries > 0);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DataCollectionEditor.this.viewer.setInput((Object)DataCollectionEditor.this.dciConfig.getItems());
                    }
                });
                monitor.done();
            }

            protected String getErrorMessage() {
                Messages.get();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.DataCollectionEditor_ConvertJob_ErrorPrefix)).append(DataCollectionEditor.this.object.getObjectName());
                Messages.get();
                return stringBuilder.append(Messages.DataCollectionEditor_ConvertJob_ErrorSuffix).toString();
            }
        }.start();
    }

    private void enableFilter(boolean enable) {
        this.filterText.setVisible(enable);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.viewerContainer.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
        this.settings.put("DataCollectionEditor.showFilter", enable);
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    public void showInformationMessage() {
        if (!this.viewerContainer.isDisposed()) {
            this.viewerContainer.showMessage(0, "Changes in policies will be deployed to nodes the moment when the tab is closed");
        }
    }
}

