/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.FontCache;

public class ThemeEngine {
    private static final Map<Display, ThemeEngine> instances = new HashMap<Display, ThemeEngine>();
    private ColorCache colors = new ColorCache();
    private FontCache fonts = new FontCache();
    private Map<String, ThemeElement> elements = new HashMap<String, ThemeElement>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThemeEngine getInstance(Display display) {
        ThemeEngine instance;
        Map<Display, ThemeEngine> map = instances;
        synchronized (map) {
            instance = instances.get(display);
            if (instance == null) {
                instance = new ThemeEngine(display);
                instances.put(display, instance);
            }
        }
        return instance;
    }

    public ThemeEngine(final Display display) {
        display.addListener(12, new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event event) {
                Map map = instances;
                synchronized (map) {
                    instances.remove(display);
                }
                ThemeEngine.this.colors.dispose();
                ThemeEngine.this.fonts.dispose();
            }
        });
        this.loadDefaultTheme(display);
    }

    public static RGB getBackgroundColorDefinition(String path) {
        ThemeEngine instance = ThemeEngine.getInstance(Display.getCurrent());
        for (ThemeElement e : instance.getElementChain(path)) {
            if (e.background == null) continue;
            return e.background;
        }
        return Display.getCurrent().getSystemColor(22).getRGB();
    }

    public static String getBackgroundColorDefinitionAsText(String path) {
        RGB rgb = ThemeEngine.getBackgroundColorDefinition(path);
        return String.valueOf(rgb.red) + "," + rgb.green + "," + rgb.blue;
    }

    public static Color getBackgroundColor(String path) {
        return ThemeEngine.getInstance((Display)Display.getCurrent()).colors.create(ThemeEngine.getBackgroundColorDefinition(path));
    }

    public static RGB getForegroundColorDefinition(String path) {
        ThemeEngine instance = ThemeEngine.getInstance(Display.getCurrent());
        for (ThemeElement e : instance.getElementChain(path)) {
            if (e.foreground == null) continue;
            return e.foreground;
        }
        return Display.getCurrent().getSystemColor(21).getRGB();
    }

    public static String getForegroundColorDefinitionAsText(String path) {
        RGB rgb = ThemeEngine.getForegroundColorDefinition(path);
        return String.valueOf(rgb.red) + "," + rgb.green + "," + rgb.blue;
    }

    public static Color getForegroundColor(String path) {
        return ThemeEngine.getInstance((Display)Display.getCurrent()).colors.create(ThemeEngine.getForegroundColorDefinition(path));
    }

    public static Font getFont(String path) {
        ThemeEngine instance = ThemeEngine.getInstance(Display.getCurrent());
        for (ThemeElement e : instance.getElementChain(path)) {
            if (e.fontName == null) continue;
            return instance.fonts.create(e.fontName, e.fontHeight);
        }
        return Display.getCurrent().getSystemFont();
    }

    private List<ThemeElement> getElementChain(String path) {
        ArrayList<ThemeElement> chain = new ArrayList<ThemeElement>(16);
        while (!path.isEmpty()) {
            int index;
            ThemeElement e = this.elements.get(path);
            if (e != null) {
                chain.add(e);
            }
            String string = path = (index = path.lastIndexOf(46)) != -1 ? path.substring(0, index) : "";
        }
        chain.add(this.elements.get("."));
        return chain;
    }

    private void loadDefaultTheme(Display display) {
        boolean darkOSTheme = ColorConverter.isDarkColor(display.getSystemColor(22).getRGB());
        this.elements.clear();
        if (darkOSTheme) {
            this.elements.put(".", new ThemeElement(null, null, null, 0));
            this.elements.put("Card.Title", new ThemeElement(new RGB(53, 80, 9), new RGB(240, 240, 240)));
            this.elements.put("Dashboard", new ThemeElement(new RGB(53, 53, 53), null));
            this.elements.put("GeoMap.Title", new ThemeElement(null, new RGB(0, 0, 0)));
            this.elements.put("List.Error", new ThemeElement(null, new RGB(255, 0, 0)));
            this.elements.put("Map.GroupBox", new ThemeElement(null, new RGB(255, 255, 255)));
            this.elements.put("Map.LastValues", new ThemeElement(null, new RGB(0, 64, 0)));
            this.elements.put("MessageBar", new ThemeElement(new RGB(255, 252, 192), new RGB(0, 0, 0)));
            this.elements.put("MibExplorer.Header", new ThemeElement(new RGB(64, 64, 64), new RGB(153, 180, 209)));
            this.elements.put("ObjectTab.Header", new ThemeElement(new RGB(64, 64, 64), new RGB(153, 180, 209)));
            this.elements.put("Rack", new ThemeElement(new RGB(255, 255, 255), new RGB(0, 0, 0)));
            this.elements.put("Rack.Border", new ThemeElement(new RGB(92, 92, 92), new RGB(92, 92, 92)));
            this.elements.put("Rack.EmptySpace", new ThemeElement(new RGB(224, 224, 224), null));
            this.elements.put("RuleEditor", new ThemeElement(new RGB(255, 255, 255), new RGB(0, 0, 0)));
            this.elements.put("RuleEditor.Title.Disabled", new ThemeElement(new RGB(202, 227, 206), null));
            this.elements.put("RuleEditor.Title.Normal", new ThemeElement(new RGB(225, 233, 241), null));
            this.elements.put("RuleEditor.Title.Selected", new ThemeElement(new RGB(245, 249, 104), null));
            this.elements.put("RuleEditor.Border.Action", new ThemeElement(new RGB(186, 176, 201), null));
            this.elements.put("RuleEditor.Border.Condition", new ThemeElement(new RGB(198, 214, 172), null));
            this.elements.put("RuleEditor.Border.Rule", new ThemeElement(new RGB(153, 180, 209), null));
            this.elements.put("ServiceAvailability.Legend", new ThemeElement(null, new RGB(0, 0, 0)));
            this.elements.put("Status.Normal", new ThemeElement(null, new RGB(0, 192, 0)));
            this.elements.put("Status.Warning", new ThemeElement(null, new RGB(0, 255, 255)));
            this.elements.put("Status.Minor", new ThemeElement(null, new RGB(231, 226, 0)));
            this.elements.put("Status.Major", new ThemeElement(null, new RGB(255, 128, 0)));
            this.elements.put("Status.Critical", new ThemeElement(null, new RGB(192, 0, 0)));
            this.elements.put("Status.Unknown", new ThemeElement(null, new RGB(0, 0, 128)));
            this.elements.put("Status.Unmanaged", new ThemeElement(null, new RGB(192, 192, 192)));
            this.elements.put("Status.Disabled", new ThemeElement(null, new RGB(128, 64, 0)));
            this.elements.put("Status.Testing", new ThemeElement(null, new RGB(255, 128, 255)));
            this.elements.put("StatusMap.Text", new ThemeElement(null, new RGB(0, 0, 0)));
            this.elements.put("TextInput.Error", new ThemeElement(new RGB(255, 0, 0), null));
        } else {
            this.elements.put(".", new ThemeElement(null, null, null, 0));
            this.elements.put("Card.Title", new ThemeElement(new RGB(153, 180, 209), new RGB(0, 0, 0)));
            this.elements.put("Dashboard", new ThemeElement(new RGB(240, 240, 240), null));
            this.elements.put("GeoMap.Title", new ThemeElement(null, new RGB(0, 0, 0)));
            this.elements.put("List.Error", new ThemeElement(null, new RGB(255, 0, 0)));
            this.elements.put("Map.GroupBox", new ThemeElement(null, new RGB(255, 255, 255)));
            this.elements.put("Map.LastValues", new ThemeElement(null, new RGB(0, 64, 0)));
            this.elements.put("MessageBar", new ThemeElement(new RGB(255, 252, 192), new RGB(0, 0, 0)));
            this.elements.put("MibExplorer.Header", new ThemeElement(new RGB(153, 180, 209), new RGB(255, 255, 255)));
            this.elements.put("ObjectTab.Header", new ThemeElement(new RGB(153, 180, 209), new RGB(255, 255, 255)));
            this.elements.put("Rack", new ThemeElement(new RGB(255, 255, 255), new RGB(0, 0, 0)));
            this.elements.put("Rack.Border", new ThemeElement(new RGB(92, 92, 92), new RGB(92, 92, 92)));
            this.elements.put("Rack.EmptySpace", new ThemeElement(new RGB(224, 224, 224), null));
            this.elements.put("RuleEditor", new ThemeElement(new RGB(255, 255, 255), new RGB(0, 0, 0)));
            this.elements.put("RuleEditor.Title.Disabled", new ThemeElement(new RGB(202, 227, 206), null));
            this.elements.put("RuleEditor.Title.Normal", new ThemeElement(new RGB(225, 233, 241), null));
            this.elements.put("RuleEditor.Title.Selected", new ThemeElement(new RGB(245, 249, 104), null));
            this.elements.put("RuleEditor.Border.Action", new ThemeElement(new RGB(186, 176, 201), null));
            this.elements.put("RuleEditor.Border.Condition", new ThemeElement(new RGB(198, 214, 172), null));
            this.elements.put("RuleEditor.Border.Rule", new ThemeElement(new RGB(153, 180, 209), null));
            this.elements.put("ServiceAvailability.Legend", new ThemeElement(null, new RGB(0, 0, 0)));
            this.elements.put("Status.Normal", new ThemeElement(null, new RGB(0, 192, 0)));
            this.elements.put("Status.Warning", new ThemeElement(null, new RGB(0, 255, 255)));
            this.elements.put("Status.Minor", new ThemeElement(null, new RGB(231, 226, 0)));
            this.elements.put("Status.Major", new ThemeElement(null, new RGB(255, 128, 0)));
            this.elements.put("Status.Critical", new ThemeElement(null, new RGB(192, 0, 0)));
            this.elements.put("Status.Unknown", new ThemeElement(null, new RGB(0, 0, 128)));
            this.elements.put("Status.Unmanaged", new ThemeElement(null, new RGB(192, 192, 192)));
            this.elements.put("Status.Disabled", new ThemeElement(null, new RGB(128, 64, 0)));
            this.elements.put("Status.Testing", new ThemeElement(null, new RGB(255, 128, 255)));
            this.elements.put("StatusMap.Text", new ThemeElement(null, new RGB(0, 0, 0)));
            this.elements.put("TextInput.Error", new ThemeElement(new RGB(255, 0, 0), null));
        }
    }

    private class ThemeElement {
        RGB background;
        RGB foreground;
        String fontName;
        int fontHeight;

        public ThemeElement(RGB background, RGB foreground, String fontName, int fontHeight) {
            this.background = background;
            this.foreground = foreground;
            this.fontName = fontName;
            this.fontHeight = fontHeight;
        }

        public ThemeElement(RGB background, RGB foreground) {
            this.background = background;
            this.foreground = foreground;
            this.fontName = null;
            this.fontHeight = 0;
        }
    }
}

