/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.users.AbstractAccessListElement;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.client.users.UserGroup;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.Activator;

public class UserAdapterFactory
implements IAdapterFactory {
    private static final Class[] supportedClasses = new Class[]{IWorkbenchAdapter.class};

    public Class[] getAdapterList() {
        return supportedClasses;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IWorkbenchAdapter.class) {
            if (adaptableObject instanceof User) {
                return new IWorkbenchAdapter(){

                    public Object[] getChildren(Object o) {
                        return null;
                    }

                    public ImageDescriptor getImageDescriptor(Object object) {
                        return Activator.getImageDescriptor("icons/user.png");
                    }

                    public String getLabel(Object o) {
                        StringBuilder sb = new StringBuilder();
                        if (((User)o).getFullName().isEmpty()) {
                            sb.append(((User)o).getName());
                        } else {
                            sb.append(String.format("%s <%s>", ((User)o).getName(), ((User)o).getFullName()));
                        }
                        if (!((User)o).getDescription().isEmpty()) {
                            sb.append(String.format(" (%s)", ((User)o).getDescription()));
                        }
                        return sb.toString();
                    }

                    public Object getParent(Object o) {
                        return null;
                    }
                };
            }
            if (adaptableObject instanceof UserGroup) {
                return new IWorkbenchAdapter(){

                    public Object[] getChildren(Object o) {
                        long[] members = ((UserGroup)o).getMembers();
                        Object[] childrens = new User[members.length];
                        int i = 0;
                        while (i < members.length) {
                            childrens[i] = ConsoleSharedData.getSession().findUserDBObjectById(members[i], null);
                            ++i;
                        }
                        return childrens;
                    }

                    public ImageDescriptor getImageDescriptor(Object object) {
                        return Activator.getImageDescriptor("icons/group.png");
                    }

                    public String getLabel(Object o) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(((UserGroup)o).getName());
                        if (!((UserGroup)o).getDescription().isEmpty()) {
                            sb.append(String.format(" (%s)", ((UserGroup)o).getDescription()));
                        }
                        return sb.toString();
                    }

                    public Object getParent(Object o) {
                        return null;
                    }
                };
            }
            if (adaptableObject instanceof AbstractAccessListElement) {
                final WorkbenchLabelProvider wbLabelProvider = new WorkbenchLabelProvider();
                return new IWorkbenchAdapter(){

                    public Object[] getChildren(Object o) {
                        return null;
                    }

                    public ImageDescriptor getImageDescriptor(Object object) {
                        long userId = ((AbstractAccessListElement)object).getUserId();
                        return Activator.getImageDescriptor((userId & 0x40000000L) == 0L ? "icons/user.png" : "icons/group.png");
                    }

                    public String getLabel(Object object) {
                        long userId = ((AbstractAccessListElement)object).getUserId();
                        NXCSession session = ConsoleSharedData.getSession();
                        AbstractUserObject dbo = session.findUserDBObjectById(userId, null);
                        return dbo != null ? wbLabelProvider.getText((Object)dbo) : "{" + Long.toString(userId) + "}";
                    }

                    public Object getParent(Object o) {
                        return null;
                    }
                };
            }
        }
        return null;
    }
}

