/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.views;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;
import org.netxms.client.constants.HistoricalDataType;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.GraphItemStyle;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.AlarmComment;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.alarmviewer.dialogs.EditCommentDialog;
import org.netxms.ui.eclipse.alarmviewer.views.helpers.EventTreeComparator;
import org.netxms.ui.eclipse.alarmviewer.views.helpers.EventTreeContentProvider;
import org.netxms.ui.eclipse.alarmviewer.views.helpers.EventTreeLabelProvider;
import org.netxms.ui.eclipse.alarmviewer.views.helpers.HistoricalDataLabelProvider;
import org.netxms.ui.eclipse.alarmviewer.widgets.AlarmCommentsEditor;
import org.netxms.ui.eclipse.charts.api.ChartFactory;
import org.netxms.ui.eclipse.charts.api.HistoricalDataChart;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.layout.DashboardLayout;
import org.netxms.ui.eclipse.layout.DashboardLayoutData;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.ImageCache;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.ViewRefreshController;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTreeViewer;

public class AlarmDetails
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.alarmviewer.views.AlarmDetails";
    public static final int EV_COLUMN_SEVERITY = 0;
    public static final int EV_COLUMN_SOURCE = 1;
    public static final int EV_COLUMN_NAME = 2;
    public static final int EV_COLUMN_MESSAGE = 3;
    public static final int EV_COLUMN_TIMESTAMP = 4;
    private static final String[] dciStatusImage = new String[]{"icons/active.gif", "icons/disabled.gif", "icons/unsupported.gif"};
    private static final String[] stateImage = new String[]{"icons/outstanding.png", "icons/acknowledged.png", "icons/resolved.png", "icons/terminated.png", "icons/acknowledged_sticky.png"};
    private static final String[] stateText;
    private NXCSession session;
    private long alarmId;
    private ImageCache imageCache;
    private WorkbenchLabelProvider wbLabelProvider;
    private FormToolkit toolkit;
    private Form form;
    private CLabel alarmSeverity;
    private CLabel alarmState;
    private CLabel alarmSource;
    private CLabel alarmDCI;
    private CLabel alarmKey;
    private CLabel alarmRule;
    private Text alarmText;
    private Composite editorsArea;
    private ImageHyperlink linkAddComment;
    private Map<Long, AlarmCommentsEditor> editors = new HashMap<Long, AlarmCommentsEditor>();
    private Composite dataArea;
    private SortableTreeViewer eventViewer;
    private Action actionRefresh;
    private CLabel labelAccessDenied = null;
    private boolean dataSectionCreated = false;
    private Section dataSection;
    private HistoricalDataChart chart;
    private TableViewer dataViewer;
    private Control dataViewControl;
    private long nodeId;
    private long dciId;
    private ViewRefreshController refreshController = null;
    private boolean updateInProgress = false;

    static {
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.AlarmListLabelProvider_AlarmState_Outstanding;
        Messages.get();
        stringArray[1] = Messages.AlarmListLabelProvider_AlarmState_Acknowledged;
        Messages.get();
        stringArray[2] = Messages.AlarmListLabelProvider_AlarmState_Resolved;
        Messages.get();
        stringArray[3] = Messages.AlarmListLabelProvider_AlarmState_Terminated;
        stateText = stringArray;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        this.wbLabelProvider = new WorkbenchLabelProvider();
        try {
            this.alarmId = Long.parseLong(site.getSecondaryId());
        }
        catch (NumberFormatException e) {
            Messages.get();
            throw new PartInitException(Messages.AlarmComments_InternalError, (Throwable)e);
        }
        this.setPartName(String.valueOf(this.getPartName()) + " [" + Long.toString(this.alarmId) + "]");
    }

    public void createPartControl(Composite parent) {
        this.imageCache = new ImageCache();
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(parent);
        DashboardLayout layout = new DashboardLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        this.form.getBody().setLayout((Layout)layout);
        this.createAlarmDetailsSection();
        this.createEventsSection();
        this.createCommentsSection();
        this.createDataSection();
        this.createActions();
        this.contributeToActionBars();
        this.refresh();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                AlarmDetails.this.refresh();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void createAlarmDetailsSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 354);
        Messages.get();
        section.setText(Messages.AlarmDetails_Overview);
        DashboardLayoutData dd = new DashboardLayoutData();
        dd.fill = false;
        section.setLayoutData((Object)dd);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.alarmSeverity = new CLabel(clientArea, 0);
        this.toolkit.adapt((Composite)this.alarmSeverity);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.alarmSeverity.setLayoutData((Object)gd);
        Label sep = new Label(clientArea, 514);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 4;
        sep.setLayoutData((Object)gd);
        final ScrolledComposite textContainer = new ScrolledComposite(clientArea, 768){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point size = super.computeSize(wHint, hHint, changed);
                if (size.y > 200) {
                    size.y = 200;
                }
                return size;
            }
        };
        textContainer.setExpandHorizontal(true);
        textContainer.getHorizontalBar().setIncrement(20);
        textContainer.setExpandVertical(true);
        textContainer.getVerticalBar().setIncrement(20);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 4;
        textContainer.setLayoutData((Object)gd);
        textContainer.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = AlarmDetails.this.alarmText.computeSize(-1, -1);
                AlarmDetails.this.alarmText.setSize(size.x, size.y);
                textContainer.setMinWidth(size.x);
                textContainer.setMinHeight(size.y);
            }
        });
        int bs = this.toolkit.getBorderStyle();
        this.toolkit.setBorderStyle(0);
        this.alarmText = this.toolkit.createText((Composite)textContainer, "", 2);
        this.toolkit.setBorderStyle(bs);
        this.alarmText.setEditable(false);
        textContainer.setContent((Control)this.alarmText);
        this.alarmState = new CLabel(clientArea, 0);
        this.toolkit.adapt((Composite)this.alarmState);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.alarmState.setLayoutData((Object)gd);
        this.alarmSource = new CLabel(clientArea, 0);
        this.toolkit.adapt((Composite)this.alarmSource);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.alarmSource.setLayoutData((Object)gd);
        this.alarmKey = new CLabel(clientArea, 0);
        this.toolkit.adapt((Composite)this.alarmKey);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.alarmKey.setLayoutData((Object)gd);
        final Image keyImage = Activator.getImageDescriptor("icons/key.png").createImage();
        this.alarmKey.setImage(keyImage);
        this.alarmKey.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                keyImage.dispose();
            }
        });
        this.alarmRule = new CLabel(clientArea, 0);
        this.toolkit.adapt((Composite)this.alarmRule);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1024;
        gd.horizontalSpan = 3;
        this.alarmRule.setLayoutData((Object)gd);
        final Image eppImage = Activator.getImageDescriptor("icons/epp.png").createImage();
        this.alarmRule.setImage(eppImage);
        this.alarmRule.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                eppImage.dispose();
            }
        });
    }

    private void createCommentsSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 354);
        Messages.get();
        section.setText(Messages.AlarmComments_Comments);
        final DashboardLayoutData dd = new DashboardLayoutData();
        dd.fill = true;
        section.setLayoutData((Object)dd);
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
                dd.fill = e.getState();
            }

            public void expansionStateChanged(ExpansionEvent e) {
            }
        });
        this.editorsArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        this.editorsArea.setLayout((Layout)layout);
        section.setClient((Control)this.editorsArea);
        this.linkAddComment = this.toolkit.createImageHyperlink(this.editorsArea, 0);
        this.linkAddComment.setImage(this.imageCache.add(Activator.getImageDescriptor("icons/new_comment.png")));
        Messages.get();
        this.linkAddComment.setText(Messages.AlarmComments_AddCommentLink);
        this.linkAddComment.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AlarmDetails.this.addComment();
            }
        });
    }

    private void createEventsSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 354);
        Messages.get();
        section.setText(Messages.AlarmDetails_RelatedEvents);
        final DashboardLayoutData dd = new DashboardLayoutData();
        dd.fill = true;
        section.setLayoutData((Object)dd);
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
                dd.fill = e.getState();
            }

            public void expansionStateChanged(ExpansionEvent e) {
            }
        });
        Composite content = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        content.setLayout((Layout)layout);
        section.setClient((Control)content);
        String[] stringArray = new String[5];
        Messages.get();
        stringArray[0] = Messages.AlarmDetails_Column_Severity;
        Messages.get();
        stringArray[1] = Messages.AlarmDetails_Column_Source;
        Messages.get();
        stringArray[2] = Messages.AlarmDetails_Column_Name;
        Messages.get();
        stringArray[3] = Messages.AlarmDetails_Column_Message;
        Messages.get();
        stringArray[4] = Messages.AlarmDetails_Column_Timestamp;
        String[] names = stringArray;
        int[] widths = new int[]{130, 160, 160, 400, 150};
        this.eventViewer = new SortableTreeViewer(content, names, widths, 4, 1024, 67584);
        this.eventViewer.setContentProvider((IContentProvider)new EventTreeContentProvider());
        this.eventViewer.setLabelProvider((IBaseLabelProvider)new EventTreeLabelProvider());
        this.eventViewer.setComparator((ViewerComparator)new EventTreeComparator());
        this.eventViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        WidgetHelper.restoreTreeViewerSettings((SortableTreeViewer)this.eventViewer, (IDialogSettings)settings, (String)"AlarmDetails.Events");
        this.eventViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTreeViewerSettings((SortableTreeViewer)AlarmDetails.this.eventViewer, (IDialogSettings)settings, (String)"AlarmDetails.Events");
            }
        });
    }

    private void createDataSection() {
        this.dataSection = this.toolkit.createSection(this.form.getBody(), 354);
        Messages.get();
        this.dataSection.setText(Messages.AlarmDetails_LastValues);
        final DashboardLayoutData dd = new DashboardLayoutData();
        dd.fill = true;
        this.dataSection.setLayoutData((Object)dd);
        this.dataSection.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
                dd.fill = e.getState();
            }

            public void expansionStateChanged(ExpansionEvent e) {
            }
        });
        this.dataArea = this.toolkit.createComposite((Composite)this.dataSection);
        this.dataSection.setClient((Control)this.dataArea);
        this.dataArea.setLayout((Layout)new FillLayout());
        Composite clientArea = this.toolkit.createComposite((Composite)this.dataSection);
        this.alarmDCI = new CLabel(clientArea, 0);
        this.toolkit.adapt((Composite)this.alarmDCI);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.alarmDCI.setLayoutData((Object)gd);
    }

    public void setFocus() {
        this.form.setFocus();
    }

    private void refresh() {
        Messages.get();
        new ConsoleJob(Messages.AlarmDetails_RefreshJobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                List _events;
                DciValue[] lastValues;
                List comments;
                Alarm alarm;
                block2: {
                    alarm = AlarmDetails.this.session.getAlarm(AlarmDetails.this.alarmId);
                    comments = AlarmDetails.this.session.getAlarmComments(AlarmDetails.this.alarmId);
                    lastValues = AlarmDetails.this.session.getLastValues(alarm.getSourceObjectId());
                    _events = null;
                    try {
                        _events = AlarmDetails.this.session.getAlarmEvents(AlarmDetails.this.alarmId);
                    }
                    catch (NXCException e) {
                        if (e.getErrorCode() == 2) break block2;
                        throw e;
                    }
                }
                final List events = _events;
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AlarmDetails.this.updateAlarmDetails(alarm);
                        for (AlarmCommentsEditor e : AlarmDetails.this.editors.values()) {
                            e.dispose();
                        }
                        for (AlarmComment n : comments) {
                            AlarmDetails.this.editors.put(n.getId(), AlarmDetails.this.createEditor(n));
                        }
                        if (events != null) {
                            AlarmDetails.this.eventViewer.setInput((Object)events);
                            AlarmDetails.this.eventViewer.expandAll();
                            if (AlarmDetails.this.labelAccessDenied != null) {
                                AlarmDetails.this.labelAccessDenied.dispose();
                                AlarmDetails.this.labelAccessDenied = null;
                            }
                        } else if (AlarmDetails.this.labelAccessDenied == null) {
                            AlarmDetails.this.labelAccessDenied = new CLabel(AlarmDetails.this.eventViewer.getControl().getParent(), 0);
                            AlarmDetails.this.toolkit.adapt((Composite)AlarmDetails.this.labelAccessDenied);
                            AlarmDetails.this.labelAccessDenied.setImage(StatusDisplayInfo.getStatusImage((Severity)Severity.CRITICAL));
                            CLabel cLabel = AlarmDetails.this.labelAccessDenied;
                            Messages.get();
                            cLabel.setText(Messages.AlarmDetails_RelatedEvents_AccessDenied);
                            AlarmDetails.this.labelAccessDenied.moveAbove(null);
                            AlarmDetails.this.labelAccessDenied.setLayoutData((Object)new GridData(4, 128, true, false));
                        }
                        if (!AlarmDetails.this.dataSectionCreated) {
                            if (alarm.getDciId() != 0L) {
                                DciValue dci = null;
                                DciValue[] dciValueArray = lastValues;
                                int n = lastValues.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    DciValue d = dciValueArray[n2];
                                    if (d.getId() == alarm.getDciId()) {
                                        dci = d;
                                        break;
                                    }
                                    ++n2;
                                }
                                if (dci != null) {
                                    Threshold t = dci.getActiveThreshold();
                                    AlarmDetails.this.alarmDCI.setText(String.valueOf(dci.getDescription()) + (t != null ? " (" + t.getTextualRepresentation() + ")" : " (OK)"));
                                    AlarmDetails.this.alarmDCI.setImage(AlarmDetails.this.imageCache.add(Activator.getImageDescriptor(dciStatusImage[dci.getStatus()])));
                                    AlarmDetails.this.createDataAreaElements(alarm, dci);
                                    AlarmDetails.this.refreshData();
                                } else {
                                    Label label = new Label(AlarmDetails.this.dataArea, 0);
                                    label.setText(String.format("DCI with ID %d is not accessible", alarm.getDciId()));
                                    AlarmDetails.this.alarmDCI.setText("[" + alarm.getDciId() + "]");
                                    AlarmDetails.this.dataSection.setExpanded(false);
                                    DashboardLayoutData dd = (DashboardLayoutData)AlarmDetails.this.dataSection.getLayoutData();
                                    dd.fill = false;
                                }
                            } else {
                                Label label = new Label(AlarmDetails.this.dataArea, 0);
                                label.setText("No DCI associated with this alarm");
                                AlarmDetails.this.dataSection.setExpanded(false);
                                DashboardLayoutData dd = (DashboardLayoutData)AlarmDetails.this.dataSection.getLayoutData();
                                dd.fill = false;
                                AlarmDetails.this.alarmDCI.dispose();
                            }
                            AlarmDetails.this.dataSectionCreated = true;
                        } else if (AlarmDetails.this.dataViewControl != null) {
                            AlarmDetails.this.refreshData();
                        }
                        AlarmDetails.this.updateLayout();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmDetails_RefreshJobError;
            }
        }.start();
    }

    private void createDataAreaElements(Alarm alarm, DciValue dci) {
        this.nodeId = alarm.getSourceObjectId();
        this.dciId = alarm.getDciId();
        if (dci.getDataType() != DataType.STRING) {
            this.chart = ChartFactory.createLineChart((Composite)this.dataArea, (int)2048);
            this.chart.setZoomEnabled(true);
            this.chart.setTitleVisible(true);
            this.chart.setChartTitle(dci.getDescription());
            this.chart.setLegendVisible(true);
            this.chart.setLegendPosition(8);
            this.chart.setExtendedLegend(true);
            this.chart.setGridVisible(true);
            this.chart.setTranslucent(true);
            this.chart.addParameter(new GraphItem(this.nodeId, this.dciId, DataOrigin.INTERNAL, dci.getDataType(), dci.getName(), dci.getDescription(), "%s"));
            List itemStyles = this.chart.getItemStyles();
            ((GraphItemStyle)itemStyles.get(0)).setType(1);
            ((GraphItemStyle)itemStyles.get(0)).setColor(ColorConverter.rgbToInt((RGB)new RGB(127, 154, 72)));
            this.chart.setItemStyles(itemStyles);
            this.dataViewControl = (Control)this.chart;
        } else {
            this.dataViewer = new TableViewer(this.dataArea, 67584);
            this.dataViewer.getTable().setHeaderVisible(true);
            TableColumn tc = new TableColumn(this.dataViewer.getTable(), 16384);
            tc.setText("Timestamp");
            tc = new TableColumn(this.dataViewer.getTable(), 16384);
            tc.setText("Value");
            this.dataViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.dataViewer.setLabelProvider((IBaseLabelProvider)new HistoricalDataLabelProvider());
            this.dataViewControl = this.dataViewer.getControl();
        }
        this.refreshController = new ViewRefreshController((IViewPart)this, 30, new Runnable(){

            @Override
            public void run() {
                if (AlarmDetails.this.dataViewControl.isDisposed()) {
                    return;
                }
                AlarmDetails.this.refreshData();
            }
        });
    }

    private void updateLayout() {
        this.form.layout(true, true);
    }

    private AlarmCommentsEditor createEditor(final AlarmComment note) {
        HyperlinkAdapter editAction = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AlarmDetails.this.editComment(note.getId(), note.getText());
            }
        };
        HyperlinkAdapter deleteAction = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AlarmDetails.this.deleteComment(note.getId());
            }
        };
        AlarmCommentsEditor e = new AlarmCommentsEditor(this.editorsArea, this.toolkit, this.imageCache, note, editAction, deleteAction);
        this.toolkit.adapt((Composite)e);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        e.setLayoutData(gd);
        e.moveBelow((Control)this.linkAddComment);
        return e;
    }

    private void addComment() {
        this.editComment(0L, "");
    }

    private void editComment(final long noteId, String noteText) {
        final EditCommentDialog dlg = new EditCommentDialog(this.getSite().getShell(), noteId, noteText);
        if (dlg.open() != 0) {
            return;
        }
        Messages.get();
        new ConsoleJob(Messages.AlarmComments_AddCommentJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AlarmDetails.this.session.updateAlarmComment(AlarmDetails.this.alarmId, noteId, dlg.getText());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AlarmDetails.this.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmComments_AddError;
            }
        }.start();
    }

    private void deleteComment(final long noteId) {
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.AlarmComments_Confirmation, (String)Messages.AlarmComments_AckToDeleteComment)) {
            return;
        }
        Messages.get();
        new ConsoleJob(Messages.AlarmComments_DeleteCommentJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AlarmDetails.this.session.deleteAlarmComment(AlarmDetails.this.alarmId, noteId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AlarmDetails.this.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmComments_ErrorDeleteAlarmComment;
            }
        }.start();
    }

    private void updateAlarmDetails(Alarm alarm) {
        this.alarmSeverity.setImage(StatusDisplayInfo.getStatusImage((Severity)alarm.getCurrentSeverity()));
        this.alarmSeverity.setText(StatusDisplayInfo.getStatusText((Severity)alarm.getCurrentSeverity()));
        int state = alarm.getState();
        if (state == 1 && alarm.isSticky()) {
            state = 4;
        }
        this.alarmState.setImage(this.imageCache.add(Activator.getImageDescriptor(stateImage[state])));
        this.alarmState.setText(stateText[alarm.getState()]);
        AbstractObject object = this.session.findObjectById(alarm.getSourceObjectId());
        this.alarmSource.setImage(object != null ? this.wbLabelProvider.getImage((Object)object) : SharedIcons.IMG_UNKNOWN_OBJECT);
        this.alarmSource.setText(object != null ? object.getObjectName() : "[" + Long.toString(alarm.getSourceObjectId()) + "]");
        this.alarmKey.setText(alarm.getKey());
        this.alarmText.setText(alarm.getMessage());
        this.alarmRule.setText(String.format("Created by rule \"%s\" (%s)", alarm.getRuleDescription(), alarm.getRuleId().toString()));
    }

    public void dispose() {
        if (this.refreshController != null) {
            this.refreshController.dispose();
        }
        this.imageCache.dispose();
        this.wbLabelProvider.dispose();
        super.dispose();
    }

    private void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        ConsoleJob job = new ConsoleJob("Update DCI data view", (IWorkbenchPart)this, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                if (AlarmDetails.this.chart != null) {
                    final Date from = new Date(System.currentTimeMillis() - 86400000L);
                    final Date to = new Date(System.currentTimeMillis());
                    final DciData data = AlarmDetails.this.session.getCollectedData(AlarmDetails.this.nodeId, AlarmDetails.this.dciId, from, to, 0, HistoricalDataType.PROCESSED);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (!AlarmDetails.this.dataViewControl.isDisposed()) {
                                AlarmDetails.this.chart.setTimeRange(from, to);
                                AlarmDetails.this.chart.updateParameter(0, data, true);
                                AlarmDetails.this.chart.clearErrors();
                            }
                            AlarmDetails.this.updateInProgress = false;
                        }
                    });
                } else {
                    final DciData data = AlarmDetails.this.session.getCollectedData(AlarmDetails.this.nodeId, AlarmDetails.this.dciId, null, null, 20, HistoricalDataType.PROCESSED);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (!AlarmDetails.this.dataViewControl.isDisposed()) {
                                AlarmDetails.this.dataViewer.setInput((Object)data.getValues());
                                TableColumn[] tableColumnArray = AlarmDetails.this.dataViewer.getTable().getColumns();
                                int n = tableColumnArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TableColumn tc = tableColumnArray[n2];
                                    tc.pack();
                                    tc.setWidth(tc.getWidth() + 10);
                                    ++n2;
                                }
                            }
                            AlarmDetails.this.updateInProgress = false;
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot read DCI data from server";
            }

            protected void jobFailureHandler() {
                AlarmDetails.this.updateInProgress = false;
                super.jobFailureHandler();
            }

            protected IStatus createFailureStatus(final Exception e) {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (AlarmDetails.this.chart != null) {
                            AlarmDetails.this.chart.addError(String.valueOf(this.getErrorMessage()) + " (" + e.getLocalizedMessage() + ")");
                        } else {
                            AlarmDetails.this.dataViewer.setInput((Object)new Object[0]);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.start();
    }
}

