/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.WebServiceDefinition;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.dialogs.IParameterSelectionDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class SelectWebServiceDlg
extends Dialog
implements IParameterSelectionDialog {
    boolean multiSelection;
    private TableViewer viewer;
    private List<WebServiceDefinition> selection;

    public SelectWebServiceDlg(Shell parentShell, boolean multiSelection) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.multiSelection = multiSelection;
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        Point location = this.getShell().getLocation();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("SelectWebServiceDlg.cx", location.x);
        settings.put("SelectWebServiceDlg.cy", location.y);
        settings.put("SelectWebServiceDlg.width", size.x);
        settings.put("SelectWebServiceDlg.height", size.y);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Web Service Defenition Selection");
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("SelectWebServiceDlg.width"), settings.getInt("SelectWebServiceDlg.height"));
            newShell.setLocation(settings.getInt("SelectWebServiceDlg.cx"), settings.getInt("SelectWebServiceDlg.cy"));
        }
        catch (NumberFormatException e) {
            newShell.setSize(400, 250);
            newShell.setLocation(100, 100);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 0x10800 | (this.multiSelection ? 2 : 0));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((WebServiceDefinition)element).getName();
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((WebServiceDefinition)e1).getName().compareToIgnoreCase(((WebServiceDefinition)e2).getName());
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 400;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.getWebServiceDefinitions();
        return dialogArea;
    }

    private void getWebServiceDefinitions() {
        final NXCSession session = ConsoleSharedData.getSession();
        ConsoleJob job = new ConsoleJob("Get web service definitions", null, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List definitions = session.getWebServiceDefinitions();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SelectWebServiceDlg.this.viewer.setInput((Object)definitions.toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get web service definitions";
            }
        };
        job.setUser(false);
        job.start();
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        IStructuredSelection viewerSelection = (IStructuredSelection)this.viewer.getSelection();
        if (viewerSelection.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Web service definition should be selected");
            return;
        }
        this.selection = new ArrayList<WebServiceDefinition>();
        for (Object o : viewerSelection.toList()) {
            this.selection.add((WebServiceDefinition)o);
        }
        this.saveSettings();
        super.okPressed();
    }

    public List<WebServiceDefinition> getSelection() {
        return this.selection;
    }

    @Override
    public String getParameterName() {
        return String.valueOf(this.selection.get(0).getName()) + ":";
    }

    @Override
    public String getParameterDescription() {
        return this.selection.get(0).getName();
    }

    @Override
    public DataType getParameterDataType() {
        return DataType.STRING;
    }

    @Override
    public String getInstanceColumn() {
        return "";
    }
}

