/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import org.netxms.base.NXCPMessage;

public class PostalAddress {
    public String country;
    public String city;
    public String streetAddress;
    public String postcode;

    public String toString() {
        return "PostalAddress [country=" + this.country + " city=" + this.city + " streetAddress=" + this.streetAddress + " postcode=" + this.postcode;
    }

    public PostalAddress() {
        this.country = "";
        this.city = "";
        this.streetAddress = "";
        this.postcode = "";
    }

    public PostalAddress(String country, String city, String streetAddress, String postcode) {
        this.country = country;
        this.city = city;
        this.streetAddress = streetAddress;
        this.postcode = postcode;
    }

    public PostalAddress(PostalAddress src) {
        this.country = src.country;
        this.city = src.city;
        this.streetAddress = src.streetAddress;
        this.postcode = src.postcode;
    }

    public PostalAddress(NXCPMessage msg) {
        this.country = msg.getFieldAsString(486L);
        this.city = msg.getFieldAsString(487L);
        this.streetAddress = msg.getFieldAsString(488L);
        this.postcode = msg.getFieldAsString(489L);
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setField(486L, this.country);
        msg.setField(487L, this.city);
        msg.setField(488L, this.streetAddress);
        msg.setField(489L, this.postcode);
    }

    public String getAddressLine() {
        StringBuilder sb = new StringBuilder();
        if (!this.streetAddress.isEmpty()) {
            sb.append(this.streetAddress);
        }
        if (!this.city.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.city);
        }
        if (!this.postcode.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.postcode);
        }
        if (!this.country.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.country);
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.country.isEmpty() && this.city.isEmpty() && this.streetAddress.isEmpty() && this.postcode.isEmpty();
    }
}

