/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class RefreshTimer {
    private static ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(4);
    private Display display;
    private Control control;
    private Runnable callback;
    private long interval;
    private long lastRun = 0L;
    private boolean scheduled = false;
    private boolean refreshDisabled = false;
    private boolean updateMissed = false;

    public RefreshTimer(int interval, Control control, Runnable callback) {
        this.interval = interval;
        this.control = control;
        this.display = control.getDisplay();
        this.callback = callback;
    }

    public RefreshTimer(int interval, Display display, Runnable callback) {
        this.interval = interval;
        this.control = null;
        this.display = display;
        this.callback = callback;
    }

    public synchronized void execute() {
        if (this.refreshDisabled) {
            this.updateMissed = true;
            return;
        }
        long curr = System.currentTimeMillis();
        if (this.interval <= 0L || curr - this.lastRun >= this.interval) {
            this.lastRun = curr;
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (RefreshTimer.this.control == null || !RefreshTimer.this.control.isDisposed()) {
                        RefreshTimer.this.callback.run();
                    }
                }
            });
        } else if (!this.scheduled) {
            int delay = (int)(this.interval - (curr - this.lastRun));
            this.scheduled = true;
            executor.schedule(new Runnable(){

                @Override
                public void run() {
                    if (RefreshTimer.this.refreshDisabled) {
                        RefreshTimer.this.updateMissed = true;
                        return;
                    }
                    RefreshTimer.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RefreshTimer.this.onTimer();
                            if (RefreshTimer.this.control == null || !RefreshTimer.this.control.isDisposed()) {
                                RefreshTimer.this.callback.run();
                            }
                        }
                    });
                }
            }, (long)delay, TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void onTimer() {
        this.lastRun = System.currentTimeMillis();
        this.scheduled = false;
    }

    public synchronized void disableRefresh() {
        this.refreshDisabled = true;
    }

    public synchronized void enableRefresh() {
        this.refreshDisabled = false;
        if (this.updateMissed) {
            this.execute();
        }
    }
}

