/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview;

import java.io.StringWriter;
import java.io.Writer;
import org.netxms.client.datacollection.PerfTabDci;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="config", strict=false)
public class PerfTabGraphSettings {
    @Element(required=false)
    private boolean enabled = false;
    @Element(required=false)
    private boolean autoScale = true;
    @Element(required=false)
    private boolean logScaleEnabled = false;
    @Element(required=false)
    private boolean stacked = false;
    @Element(required=false)
    private boolean showLegendAlways = false;
    @Element(required=false)
    private boolean extendedLegend = true;
    @Element(required=false)
    private boolean useMultipliers = true;
    @Element(required=false)
    private double minYScaleValue = 0.0;
    @Element(required=false)
    private double maxYScaleValue = 100.0;
    @Element(required=false)
    private int timeRange = 1;
    @Element(required=false)
    private int timeUnits = 1;
    @Element(required=false)
    private int type = 0;
    @Element(required=false)
    private String color = "0x00C000";
    @Element(required=false)
    private String title = "";
    @Element(required=false)
    private String name = "";
    @Element(required=false)
    private boolean showThresholds = false;
    @Element(required=false)
    private String groupName = null;
    @Element(required=false)
    private int order = 100;
    @Element(required=false)
    private long parentDciId = 0L;
    @Element(required=false)
    private boolean modifyYBase = false;
    @Element(required=false)
    private boolean invertedValues = false;
    @Element(required=false)
    private boolean translucent = true;
    private PerfTabDci runtimeDciInfo = null;

    public static PerfTabGraphSettings createFromXml(String xml) throws Exception {
        Persister serializer = new Persister();
        return (PerfTabGraphSettings)serializer.read(PerfTabGraphSettings.class, xml);
    }

    public String createXml() throws Exception {
        Persister serializer = new Persister();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, (Writer)writer);
        return ((Object)writer).toString();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getType() {
        return this.type;
    }

    public String getColor() {
        return this.color;
    }

    public int getColorAsInt() {
        try {
            if (this.color.startsWith("0x")) {
                return Integer.parseInt(this.color.substring(2), 16);
            }
            return Integer.parseInt(this.color, 10);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getRuntimeTitle() {
        String t = this.title == null || this.title.isEmpty() ? (this.runtimeDciInfo != null ? this.runtimeDciInfo.getDescription() : "") : this.title;
        return t.replace("{instance}", this.runtimeDciInfo != null ? this.runtimeDciInfo.getInstance() : "");
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setColor(int color) {
        this.color = Integer.toString(color);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isShowThresholds() {
        return this.showThresholds;
    }

    public void setShowThresholds(boolean showThresholds) {
        this.showThresholds = showThresholds;
    }

    public String getGroupName() {
        if (this.groupName != null) {
            return this.runtimeDciInfo != null ? this.groupName.replace("{instance}", this.runtimeDciInfo.getInstance()) : this.groupName;
        }
        return this.parentDciId != 0L ? "##" + Long.toString(this.parentDciId) : "";
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public final PerfTabDci getRuntimeDciInfo() {
        return this.runtimeDciInfo;
    }

    public final void setRuntimeDciInfo(PerfTabDci runtimeDciInfo) {
        this.runtimeDciInfo = runtimeDciInfo;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public String getRuntimeName() {
        String n = this.name == null || this.name.isEmpty() ? (this.runtimeDciInfo != null ? this.runtimeDciInfo.getDescription() : "") : this.name;
        return n.replace("{instance}", this.runtimeDciInfo != null ? this.runtimeDciInfo.getInstance() : "");
    }

    public final int getOrder() {
        return this.order;
    }

    public final void setOrder(int order) {
        this.order = order;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public double getMinYScaleValue() {
        return this.minYScaleValue;
    }

    public void setMinYScaleValue(double minYScaleValue) {
        this.minYScaleValue = minYScaleValue;
    }

    public double getMaxYScaleValue() {
        return this.maxYScaleValue;
    }

    public void setMaxYScaleValue(double maxYScaleValue) {
        this.maxYScaleValue = maxYScaleValue;
    }

    public int getTimeRange() {
        return this.timeRange;
    }

    public long getTimeRangeMillis() {
        switch (this.timeUnits) {
            case 0: {
                return (long)this.timeRange * 60L * 1000L;
            }
            case 1: {
                return (long)this.timeRange * 60L * 60L * 1000L;
            }
            case 2: {
                return (long)this.timeRange * 24L * 60L * 60L * 1000L;
            }
        }
        return 0L;
    }

    public void setTimeRange(int timeInterval) {
        this.timeRange = timeInterval;
    }

    public int getTimeUnits() {
        return this.timeUnits;
    }

    public void setTimeUnits(int timeUnits) {
        this.timeUnits = timeUnits;
    }

    public boolean isLogScaleEnabled() {
        return this.logScaleEnabled;
    }

    public void setLogScaleEnabled(boolean logScaleEnabled) {
        this.logScaleEnabled = logScaleEnabled;
    }

    public boolean isShowLegendAlways() {
        return this.showLegendAlways;
    }

    public void setShowLegendAlways(boolean showLegendAlways) {
        this.showLegendAlways = showLegendAlways;
    }

    public boolean isExtendedLegend() {
        return this.extendedLegend;
    }

    public void setExtendedLegend(boolean extendedLegend) {
        this.extendedLegend = extendedLegend;
    }

    public boolean isUseMultipliers() {
        return this.useMultipliers;
    }

    public void setUseMultipliers(boolean useMultipliers) {
        this.useMultipliers = useMultipliers;
    }

    public void setModifyYBase(boolean modifyYBase) {
        this.modifyYBase = modifyYBase;
    }

    public boolean modifyYBase() {
        return this.modifyYBase;
    }

    public boolean isInvertedValues() {
        return this.invertedValues;
    }

    public void setInvertedValues(boolean invertedValues) {
        this.invertedValues = invertedValues;
    }

    public boolean isTranslucent() {
        return this.translucent;
    }

    public void setTranslucent(boolean translucent) {
        this.translucent = translucent;
    }
}

