/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views.helpers;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.UserAgentNotification;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.console.UserRefreshRunnable;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class UserAgentNotificationLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private NXCSession session;
    private SortableTableViewer viewer;

    public UserAgentNotificationLabelProvider(SortableTableViewer viewer) {
        this.viewer = viewer;
        this.session = ConsoleSharedData.getSession();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        UserAgentNotification uaMessage = (UserAgentNotification)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(uaMessage.getId());
            }
            case 1: {
                return uaMessage.getObjectNames();
            }
            case 2: {
                return uaMessage.getMessage();
            }
            case 3: {
                return uaMessage.isRecalled() ? "Yes" : "No";
            }
            case 4: {
                return uaMessage.isStartupNotification() ? "Yes" : "No";
            }
            case 5: {
                return uaMessage.getStartTime().getTime() == 0L ? "" : RegionalSettings.getDateTimeFormat().format(uaMessage.getStartTime());
            }
            case 6: {
                return uaMessage.getEndTime().getTime() == 0L ? "" : RegionalSettings.getDateTimeFormat().format(uaMessage.getEndTime());
            }
            case 7: {
                return uaMessage.getCreationTime().getTime() == 0L ? "" : RegionalSettings.getDateTimeFormat().format(uaMessage.getCreationTime());
            }
            case 8: {
                return this.getUserName(uaMessage);
            }
        }
        return null;
    }

    public String getUserName(UserAgentNotification uam) {
        AbstractUserObject user = this.session.findUserDBObjectById(uam.getCreatedBy(), (Runnable)new UserRefreshRunnable((ColumnViewer)this.viewer, (Object)uam));
        return user != null ? user.getName() : "[" + Long.toString(uam.getCreatedBy()) + "]";
    }
}

