/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.EventMonitorConfig;
import org.netxms.ui.eclipse.eventmanager.widgets.EventTraceWidget;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class EventMonitorElement
extends ElementWidget {
    private EventTraceWidget viewer;
    private EventMonitorConfig config;
    private final NXCSession session;

    protected EventMonitorElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = EventMonitorConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new EventMonitorConfig();
        }
        this.session = ConsoleSharedData.getSession();
        new ConsoleJob(String.format("Subscribing to channel ", "Core.Events"), (IWorkbenchPart)viewPart, "org.netxms.ui.eclipse.console", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                EventMonitorElement.this.session.subscribe("Core.Events");
            }

            protected String getErrorMessage() {
                return String.format("Cannot subscribe to channel ", "Core.Events");
            }
        }.start();
        FillLayout layout = new FillLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.viewer = new EventTraceWidget((Composite)this, 0, viewPart);
        this.viewer.setRootObject(this.config.getObjectId());
        this.viewer.getViewer().getControl().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                EventMonitorElement.this.setSelectionProviderDelegate(EventMonitorElement.this.viewer.getSelectionProvider());
            }
        });
    }

    public void dispose() {
        ConsoleJob job = new ConsoleJob(String.format("Unsuscribing from channel ", "Core.Events"), null, "org.netxms.ui.eclipse.console", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                EventMonitorElement.this.session.unsubscribe("Core.Events");
            }

            protected String getErrorMessage() {
                return String.format("Cannot unsubscribe from channel ", "Core.Events");
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
        super.dispose();
    }
}

