/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.NetworkService;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.NetworkServiceListLabelProvider;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.NodeComponentTabFilter;

public class NetworkServiceTabFilter
extends NodeComponentTabFilter {
    private NetworkServiceListLabelProvider lp;

    public NetworkServiceTabFilter(NetworkServiceListLabelProvider lp) {
        this.lp = lp;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        NetworkService ns = (NetworkService)element;
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        boolean matched = false;
        if (Long.toString(ns.getObjectId()).contains(this.filterString)) {
            matched = true;
        } else if (ns.getObjectName().contains(this.filterString)) {
            matched = true;
        } else if (StatusDisplayInfo.getStatusText((ObjectStatus)ns.getStatus()).contains(this.filterString)) {
            matched = true;
        } else if (this.lp.types[ns.getServiceType()].contains(this.filterString)) {
            matched = true;
        } else if (ns.getIpAddress().getHostAddress().contains(this.filterString)) {
            matched = true;
        } else if (Integer.toString(ns.getProtocol()).contains(this.filterString)) {
            matched = true;
        } else if (Integer.toString(ns.getPort()).contains(this.filterString)) {
            matched = true;
        } else if (ns.getRequest().contains(this.filterString)) {
            matched = true;
        } else if (ns.getResponse().contains(this.filterString)) {
            matched = true;
        } else if (this.lp.getPollerName(ns).contains(this.filterString)) {
            matched = true;
        } else if (Integer.toString(ns.getPollCount()).contains(this.filterString)) {
            matched = true;
        }
        return matched;
    }
}

