/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.base.InetAddressEx;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.NetworkService;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class NetworkServicePolling
extends PropertyPage {
    private NetworkService object;
    private Combo serviceType;
    private LabeledText port;
    private LabeledText request;
    private LabeledText response;
    private LabeledText ipAddress;
    private ObjectSelector pollerNode;
    private Spinner pollCount;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (NetworkService)this.getElement().getAdapter(NetworkService.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Messages.get();
        this.serviceType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.NetworkServicePolling_ServiceType, (Object)gd);
        Messages.get();
        this.serviceType.add(Messages.NetworkServicePolling_TypeUserDef);
        Messages.get();
        this.serviceType.add(Messages.NetworkServicePolling_TypeSSH);
        Messages.get();
        this.serviceType.add(Messages.NetworkServicePolling_TypePOP3);
        Messages.get();
        this.serviceType.add(Messages.NetworkServicePolling_TypeSMTP);
        Messages.get();
        this.serviceType.add(Messages.NetworkServicePolling_TypeFTP);
        Messages.get();
        this.serviceType.add(Messages.NetworkServicePolling_TypeHTTP);
        Messages.get();
        this.serviceType.add(Messages.NetworkServicePolling_TypeHTTPS);
        Messages.get();
        this.serviceType.add(Messages.NetworkServicePolling_TypeTelnet);
        this.serviceType.select(this.object.getServiceType());
        this.port = new LabeledText(dialogArea, 0);
        Messages.get();
        this.port.setLabel(Messages.NetworkServicePolling_Port);
        this.port.setText(Integer.toString(this.object.getPort()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.port.setLayoutData((Object)gd);
        this.ipAddress = new LabeledText(dialogArea, 0);
        this.ipAddress.setLabel("IP Address");
        if (this.object.getIpAddress().isValidAddress()) {
            this.ipAddress.setText(this.object.getIpAddress().getHostAddress());
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.ipAddress.setLayoutData((Object)gd);
        this.request = new LabeledText(dialogArea, 0);
        Messages.get();
        this.request.setLabel(Messages.NetworkServicePolling_Request);
        this.request.setText(this.object.getRequest());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.request.setLayoutData((Object)gd);
        this.response = new LabeledText(dialogArea, 0);
        Messages.get();
        this.response.setLabel(Messages.NetworkServicePolling_Response);
        this.response.setText(this.object.getResponse());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.response.setLayoutData((Object)gd);
        this.pollerNode = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.pollerNode.setLabel(Messages.NetworkServicePolling_PollerNode);
        Messages.get();
        this.pollerNode.setEmptySelectionName(Messages.NetworkServicePolling_SelectionDefault);
        this.pollerNode.setObjectClass(AbstractNode.class);
        this.pollerNode.setObjectId(this.object.getPollerNode());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.pollerNode.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        Messages.get();
        this.pollCount = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)Messages.NetworkServicePolling_RequiredPolls, (int)0, (int)1000, (Object)gd);
        this.pollCount.setSelection(this.object.getPollCount());
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        try {
            int ipPort = Integer.parseInt(this.port.getText());
            if (ipPort < 1 || ipPort > 65535) {
                throw new NumberFormatException();
            }
            md.setIpPort(ipPort);
        }
        catch (NumberFormatException e) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.NetworkServicePolling_Warning, (String)Messages.NetworkServicePolling_WarningInvalidPort);
            return false;
        }
        md.setRequiredPolls(this.pollCount.getSelection());
        md.setServiceType(this.serviceType.getSelectionIndex());
        String addr = this.ipAddress.getText().trim();
        if (!addr.isEmpty()) {
            try {
                md.setIpAddress(new InetAddressEx(InetAddress.getByName(addr)));
            }
            catch (UnknownHostException e) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openWarning((Shell)shell, (String)Messages.AddAddressListElementDialog_Warning, (String)Messages.AddAddressListElementDialog_AddressValidationError);
                return false;
            }
        } else {
            md.setIpAddress(new InetAddressEx());
        }
        md.setRequest(this.request.getText());
        md.setResponse(this.response.getText());
        md.setPollerNode(this.pollerNode.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.NetworkServicePolling_JobName, null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NetworkServicePolling_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            NetworkServicePolling.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }
}

