/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.core.data.ColumnBinding;
import org.eclipse.birt.core.data.ExpressionParserUtility;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.data.IDimLevel;
import org.eclipse.birt.core.data.OlapExpressionCompiler;
import org.eclipse.birt.core.data.ParseIndicator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.exception.CoreException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;

public final class ExpressionUtil {
    public static final String ROW_INDICATOR = "row";
    public static final String DATASET_ROW_INDICATOR = "dataSetRow";
    public static final String PARAMETER_INDICATOR = "params";
    public static final String MEASURE_INDICATOR = "measure";
    public static final String DIMENSION_INDICATOR = "dimension";
    public static final String DATA_INDICATOR = "data";
    private static String PREFIX = "COLUMN_";
    public static String EXPRESSION_VALUE_SUFFIX = ".value";
    private static int suffix = 0;

    public static String createRowExpression(String rowName) {
        return ExpressionUtil.createJSRowExpression(rowName);
    }

    public static String createDataSetRowExpression(String rowName) {
        return ExpressionUtil.createJSDataSetRowExpression(rowName);
    }

    public static String createJSRowExpression(String rowName) {
        return ROW_INDICATOR + ExpressionUtil.createJSExprComponent(rowName);
    }

    public static String createJSMeasureExpression(String measureName) {
        return MEASURE_INDICATOR + ExpressionUtil.createJSExprComponent(measureName);
    }

    public static String createJSDataExpression(String dataName) {
        return DATA_INDICATOR + ExpressionUtil.createJSExprComponent(dataName);
    }

    public static String createJSDimensionExpression(String dimensionName, String levelName) {
        return DIMENSION_INDICATOR + ExpressionUtil.createJSExprComponent(dimensionName) + ExpressionUtil.createJSExprComponent(levelName);
    }

    public static String createJSDimensionExpression(String dimensionName, String levelName, String attributeName) {
        return DIMENSION_INDICATOR + ExpressionUtil.createJSExprComponent(dimensionName) + ExpressionUtil.createJSExprComponent(levelName) + ExpressionUtil.createJSExprComponent(attributeName);
    }

    public static String createJSDataSetRowExpression(String rowName) {
        return DATASET_ROW_INDICATOR + ExpressionUtil.createJSExprComponent(rowName);
    }

    public static String createJSParameterExpression(String parameterName) {
        return PARAMETER_INDICATOR + ExpressionUtil.createJSExprComponent(parameterName);
    }

    public static String createJSParameterValueExpression(String parameterName) {
        return String.valueOf(ExpressionUtil.createJSParameterExpression(parameterName)) + EXPRESSION_VALUE_SUFFIX;
    }

    private static String createJSExprComponent(String value) {
        return "[\"" + (value == null ? "" : JavascriptEvalUtil.transformToJsConstants(value.trim())) + "\"]";
    }

    public static String createRowExpression(int index) {
        return "row[" + index + "]";
    }

    public static List<IColumnBinding> extractColumnExpressions(String oldExpression) throws BirtException {
        return ExpressionUtil.extractColumnExpressions(oldExpression, ROW_INDICATOR);
    }

    public static String getColumnBindingName(String oldExpression) throws BirtException {
        List<IColumnBinding> columnsLists = ExpressionUtil.extractColumnExpressions(oldExpression, ROW_INDICATOR);
        if (columnsLists.size() != 1 || !ExpressionParserUtility.isDirectColumnRef(oldExpression, ROW_INDICATOR)) {
            return null;
        }
        return columnsLists.get(0).getResultSetColumnName();
    }

    public static String getColumnName(String oldExpression) throws BirtException {
        List<IColumnBinding> columnsLists = ExpressionUtil.extractColumnExpressions(oldExpression, DATASET_ROW_INDICATOR);
        if (columnsLists.size() != 1 || !ExpressionParserUtility.isDirectColumnRef(oldExpression, DATASET_ROW_INDICATOR)) {
            return null;
        }
        return columnsLists.get(0).getResultSetColumnName();
    }

    public static List<IColumnBinding> extractColumnExpressions(String oldExpression, boolean mode) throws BirtException {
        String indicator = mode ? ROW_INDICATOR : DATASET_ROW_INDICATOR;
        return ExpressionUtil.extractColumnExpressions(oldExpression, indicator);
    }

    public static List<IColumnBinding> extractColumnExpressions(String oldExpression, String indicator) throws BirtException {
        if (oldExpression == null || oldExpression.trim().length() == 0) {
            return Collections.emptyList();
        }
        try {
            return ExpressionParserUtility.compileColumnExpression(new ExpressionParserUtility(), oldExpression, indicator);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    public static boolean hasAggregation(String expression) {
        if (expression == null) {
            return false;
        }
        try {
            return ExpressionParserUtility.hasAggregation(expression, ROW_INDICATOR) || ExpressionParserUtility.hasAggregation(expression, DATASET_ROW_INDICATOR);
        }
        catch (BirtException birtException) {
            return false;
        }
    }

    public static IColumnBinding getColumnBinding(String oldExpression) {
        return new ColumnBinding(String.valueOf(PREFIX) + ++suffix, ExpressionUtil.toNewExpression(oldExpression));
    }

    public static String toNewExpression(String oldExpression) {
        if (oldExpression == null) {
            return null;
        }
        char[] chars = oldExpression.toCharArray();
        if (chars.length < 5) {
            return oldExpression;
        }
        ParseIndicator status = new ParseIndicator(0, 0, false, false, true, true);
        int i = 0;
        while (i < chars.length) {
            if ((i = (status = ExpressionUtil.getParseIndicator(chars, i, status.omitNextQuote(), status.getCandidateKey1(), status.getCandidateKey2())).getNewIndex()) >= status.getRetrieveSize() + 3 && status.isCandidateKey() && chars[i - status.getRetrieveSize() - 3] == 'r' && chars[i - status.getRetrieveSize() - 2] == 'o' && chars[i - status.getRetrieveSize() - 1] == 'w' && (i - status.getRetrieveSize() - 4 <= 0 || ExpressionUtil.isValidProceeding(chars[i - status.getRetrieveSize() - 4])) && (chars[i] == ' ' || chars[i] == '.' || chars[i] == '[')) {
                String firstPart = oldExpression.substring(0, i - status.getRetrieveSize() - 3);
                String secondPart = ExpressionUtil.toNewExpression(oldExpression.substring(i - status.getRetrieveSize()));
                String newExpression = String.valueOf(firstPart) + DATASET_ROW_INDICATOR + secondPart;
                return newExpression;
            }
            ++i;
        }
        return oldExpression;
    }

    public static String updateParentQueryReferenceExpression(String oldExpression, boolean isParameterBinding) {
        if (oldExpression == null) {
            return null;
        }
        char[] chars = oldExpression.toCharArray();
        if (chars.length < 7) {
            return oldExpression;
        }
        ParseIndicator status = new ParseIndicator(0, 0, false, false, true, true);
        int i = 0;
        while (i < chars.length) {
            if ((i = (status = ExpressionUtil.getParseIndicator(chars, i, status.omitNextQuote(), status.getCandidateKey1(), status.getCandidateKey2())).getNewIndex()) >= status.getRetrieveSize() + 4 && status.isCandidateKey() && chars[i - status.getRetrieveSize() - 4] == 'r' && chars[i - status.getRetrieveSize() - 3] == 'o' && chars[i - status.getRetrieveSize() - 2] == 'w' && chars[i - status.getRetrieveSize() - 1] == 's' && (i - status.getRetrieveSize() - 5 <= 0 || ExpressionUtil.isValidProceeding(chars[i - status.getRetrieveSize() - 5])) && (chars[i] == ' ' || chars[i] == '.' || chars[i] == '[')) {
                int start = i;
                int end = 1;
                do {
                    ++end;
                } while (++i < chars.length && chars[i] != ']');
                String firstPart = oldExpression.substring(0, start - status.getRetrieveSize() - 4);
                String secondPart = ExpressionUtil.updateParentQueryReferenceExpression(oldExpression.substring(start - status.getRetrieveSize() + end), isParameterBinding);
                String newExpression = String.valueOf(firstPart) + (isParameterBinding ? ROW_INDICATOR : "row._outer") + secondPart;
                return newExpression;
            }
            ++i;
        }
        return oldExpression;
    }

    public static boolean isScalarParamReference(String expression) {
        Pattern pattern = Pattern.compile("params\\[\".+\\\"]");
        Matcher matcher = pattern.matcher(expression);
        return matcher.matches();
    }

    private static ParseIndicator getParseIndicator(char[] chars, int i, boolean omitNextQuote, boolean candidateKey1, boolean candidateKey2) {
        int retrieveSize = 0;
        if (chars[i] == '/') {
            if (i > 0 && chars[i - 1] == '/') {
                ++retrieveSize;
                while (i < chars.length - 2) {
                    ++retrieveSize;
                    if (chars[++i] == '\n') break;
                }
                ++retrieveSize;
                ++i;
            }
        } else if (chars[i] == '*' && i > 0 && chars[i - 1] == '/') {
            ++i;
            retrieveSize += 2;
            while (i < chars.length - 2) {
                ++retrieveSize;
                if (chars[++i - 1] == '*' && chars[i] == '/') break;
            }
            ++retrieveSize;
            ++i;
        }
        if (!omitNextQuote && chars[i] == '\"') {
            boolean bl = candidateKey1 = !candidateKey1;
            if (candidateKey1) {
                candidateKey2 = true;
            }
        }
        if (!omitNextQuote && chars[i] == '\'') {
            boolean bl = candidateKey2 = !candidateKey2;
            if (candidateKey2) {
                candidateKey1 = true;
            }
        }
        omitNextQuote = chars[i] == '\\';
        return new ParseIndicator(retrieveSize, i, candidateKey1, omitNextQuote, candidateKey1, candidateKey2);
    }

    private static boolean isValidProceeding(char operator) {
        return !(operator >= 'A' && operator <= 'Z' || operator >= 'a' && operator <= 'z') && operator != '_';
    }

    public static String[] getSourceDataSetNames(String jointColumName) {
        assert (jointColumName != null);
        String[] result = new String[2];
        if (jointColumName.indexOf("::") != -1) {
            String[] splited = jointColumName.split("::");
            result[0] = splited[0];
            if (result[0].endsWith("1") || result[0].endsWith("2")) {
                result[1] = result[0].substring(0, result[0].length() - 1);
            }
        }
        return result;
    }

    public static String getDataSetNameWithoutPrefix(String fullDataSetName) {
        if (fullDataSetName == null) {
            return null;
        }
        String dataSetName = fullDataSetName;
        String[] temp = fullDataSetName.split("\\Q.\\E");
        if (temp.length >= 2) {
            dataSetName = temp[1].trim();
        }
        return dataSetName;
    }

    public static Set<IDimLevel> getReferencedDimLevel(String expr) throws CoreException {
        return OlapExpressionCompiler.getReferencedDimLevel(expr);
    }

    public static String getReferencedMeasure(String expr) throws CoreException {
        Set<String> names = OlapExpressionCompiler.getReferencedMeasure(expr);
        return names.isEmpty() ? null : names.iterator().next();
    }

    public static Set<String> getAllReferencedMeasures(String expr) throws CoreException {
        return OlapExpressionCompiler.getReferencedMeasure(expr);
    }

    public static String replaceParameterName(String expr, String paramOldName, String paramNewName) {
        if (expr == null || paramOldName == null || paramNewName == null) {
            return expr;
        }
        expr = expr.replaceAll("\\Qparams[\"\\E" + paramOldName + "\\Q\"]\\E", "params[\"" + paramNewName + "\"]");
        expr = expr.replaceAll("\\Qparams.\\E" + paramOldName, "params." + paramNewName);
        return expr;
    }

    public static String generateConstantExpr(String input, int dataType) throws BirtException {
        if (input == null) {
            return null;
        }
        if (dataType == 4) {
            return "new java.math.BigDecimal(\"" + input + "\")";
        }
        if (dataType == 5 || dataType == 6 || dataType == 9 || dataType == 10 || dataType == 11) {
            return JavascriptEvalUtil.transformToJsExpression(input);
        }
        return input;
    }
}

