/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.views;

import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerService;
import org.netxms.base.GeoLocation;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.osm.Activator;
import org.netxms.ui.eclipse.osm.Messages;
import org.netxms.ui.eclipse.osm.tools.MapAccessor;
import org.netxms.ui.eclipse.osm.views.AbstractGeolocationView;
import org.netxms.ui.eclipse.osm.widgets.AbstractGeoMapViewer;
import org.netxms.ui.eclipse.osm.widgets.ObjectGeoLocationViewer;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.FilterText;

public class WorldMap
extends AbstractGeolocationView {
    public static final String ID = "org.netxms.ui.eclipse.osm.views.WorldMap";
    private GeoLocation initialLocation = new GeoLocation(0.0, 0.0);
    private int initialZoom;
    private Action actionPlaceObject;
    private Action actionShowFilter;
    private boolean filterEnabled;
    private FilterText filterControl;

    @Override
    public void createPartControl(Composite parent) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        int n = this.initialZoom = settings.get("org.netxms.ui.eclipse.osm.views.WorldMapzoom") != null ? settings.getInt("org.netxms.ui.eclipse.osm.views.WorldMapzoom") : 2;
        if (settings.get("org.netxms.ui.eclipse.osm.views.WorldMaplatitude") != null && settings.get("org.netxms.ui.eclipse.osm.views.WorldMaplongitude") != null) {
            this.initialLocation = new GeoLocation(settings.getDouble("org.netxms.ui.eclipse.osm.views.WorldMaplatitude"), settings.getDouble("org.netxms.ui.eclipse.osm.views.WorldMaplongitude"));
        }
        this.filterEnabled = settings.get("org.netxms.ui.eclipse.osm.views.WorldMapfilterEnabled") != null ? settings.getBoolean("org.netxms.ui.eclipse.osm.views.WorldMapfilterEnabled") : true;
        super.createPartControl(parent);
        parent.setLayout((Layout)new FormLayout());
        this.filterControl = new FilterText(parent, 0);
        this.filterControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WorldMap.this.onFilterModify();
            }
        });
        this.filterControl.setCloseAction(new Action(){

            public void run() {
                WorldMap.this.enableFilter(false);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterControl);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.map.setLayoutData(fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterControl.setLayoutData((Object)fd);
        if (this.filterEnabled) {
            this.filterControl.setFocus();
        } else {
            this.enableFilter(false);
        }
    }

    @Override
    protected AbstractGeoMapViewer createMapViewer(Composite parent, int style) {
        return new ObjectGeoLocationViewer(parent, style);
    }

    public void dispose() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        MapAccessor m = this.getMapAccessor();
        settings.put("org.netxms.ui.eclipse.osm.views.WorldMapzoom", m.getZoom());
        settings.put("org.netxms.ui.eclipse.osm.views.WorldMaplatitude", m.getLatitude());
        settings.put("org.netxms.ui.eclipse.osm.views.WorldMaplongitude", m.getLongitude());
        settings.put("org.netxms.ui.eclipse.osm.views.WorldMapfilterEnabled", this.filterEnabled);
        super.dispose();
    }

    @Override
    protected GeoLocation getInitialCenterPoint() {
        return this.initialLocation;
    }

    @Override
    protected int getInitialZoomLevel() {
        return this.initialZoom;
    }

    @Override
    protected void createActions() {
        super.createActions();
        Messages.get();
        this.actionPlaceObject = new Action(Messages.WorldMap_PlaceObject){

            public void run() {
                WorldMap.this.placeObject();
            }
        };
        this.actionShowFilter = new Action("Show filter", 2){

            public void run() {
                WorldMap.this.enableFilter(WorldMap.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.filterEnabled);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.worldmap.commands.show_filter");
        ActionHandler showFilterHandler = new ActionHandler((IAction)this.actionShowFilter);
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)showFilterHandler);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        if (this.getSelection().isEmpty()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionPlaceObject);
            manager.add((IAction)this.actionShowFilter);
        }
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        super.fillLocalPullDown(manager);
        manager.add((IAction)this.actionShowFilter);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        super.fillLocalToolBar(manager);
        manager.add((IAction)this.actionShowFilter);
    }

    private void placeObject() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), ObjectSelectionDialog.createDataCollectionTargetSelectionFilter());
        if (dlg.open() == 0) {
            final NXCObjectModificationData md = new NXCObjectModificationData(((AbstractObject)dlg.getSelectedObjects().get(0)).getObjectId());
            md.setGeolocation(this.map.getLocationAtPoint(this.map.getCurrentPoint()));
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            new ConsoleJob(Messages.WorldMap_JobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.osm", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    session.modifyObject(md);
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.WorldMap_JobError;
                }
            }.start();
        }
    }

    private void onFilterModify() {
        ((ObjectGeoLocationViewer)this.map).setFilterString(this.filterControl.getText().trim().toLowerCase());
        this.map.reloadMap();
    }

    public void enableFilter(boolean enable) {
        this.actionShowFilter.setChecked(enable);
        this.filterEnabled = enable;
        this.filterControl.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.map.getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterControl) : new FormAttachment(0, 0);
        this.map.getParent().layout();
        if (enable) {
            this.filterControl.setFocus();
        } else {
            this.filterControl.setText("");
        }
    }
}

