/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.netxms.base.GeoLocation;
import org.netxms.client.GeoArea;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.osm.GeoLocationCache;
import org.netxms.ui.eclipse.osm.tools.Area;
import org.netxms.ui.eclipse.osm.widgets.AbstractGeoMapViewer;

public class GeoAreaViewer
extends AbstractGeoMapViewer {
    private GeoArea area = null;

    public GeoAreaViewer(Composite parent, int style) {
        super(parent, style);
    }

    public void setArea(GeoArea area) {
        this.area = area;
        if (area != null) {
            GeoLocation[] boundingBox = area.getBoundingBox();
            GeoLocation center = new GeoLocation(boundingBox[0].getLatitude() + (boundingBox[1].getLatitude() - boundingBox[0].getLatitude()) / 2.0, boundingBox[0].getLongitude() + (boundingBox[1].getLongitude() - boundingBox[0].getLongitude()) / 2.0);
            int zoom = 0;
            while (zoom < 19) {
                Area coverage = GeoLocationCache.calculateCoverage(this.getSize(), center, 0, ++zoom);
                if (coverage.contains(boundingBox[0]) && coverage.contains(boundingBox[1])) continue;
                --zoom;
                break;
            }
            this.showMap(center.getLatitude(), center.getLongitude(), zoom);
        }
    }

    @Override
    protected void onMapLoad() {
    }

    @Override
    protected void drawContent(GC gc, GeoLocation currentLocation, int imgW, int imgH) {
        if (this.area == null) {
            return;
        }
        Point centerXY = GeoLocationCache.coordinateToDisplay(currentLocation, this.accessor.getZoom());
        gc.setForeground(this.getDisplay().getSystemColor(4));
        gc.setBackground(this.getDisplay().getSystemColor(4));
        int[] points = new int[this.area.getBorder().size() * 2];
        int i = 0;
        for (GeoLocation p : this.area.getBorder()) {
            Point virtualXY = GeoLocationCache.coordinateToDisplay(p, this.accessor.getZoom());
            int dx = virtualXY.x - centerXY.x;
            int dy = virtualXY.y - centerXY.y;
            points[i++] = imgW / 2 + dx;
            points[i++] = imgH / 2 + dy;
        }
        gc.setAlpha(40);
        gc.fillPolygon(points);
        gc.setAlpha(255);
        gc.drawPolygon(points);
    }

    @Override
    protected void onCacheChange(AbstractObject object, GeoLocation prevLocation) {
    }

    @Override
    public AbstractObject getObjectAtPoint(Point p) {
        return null;
    }
}

