/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.PhysicalComponent;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.ComponentTreeContentProvider;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.ComponentTreeLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class ComponentsTab
extends ObjectTab {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_CLASS = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    public static final int COLUMN_MODEL = 3;
    public static final int COLUMN_FIRMWARE = 4;
    public static final int COLUMN_SERIAL = 5;
    public static final int COLUMN_VENDOR = 6;
    public static final int COLUMN_INTERFACE = 7;
    private TreeViewer viewer;
    private ComponentTreeLabelProvider labelProvider;
    private Action actionCopy;
    private Action actionCopyName;
    private Action actionCopyModel;
    private Action actionCopySerial;
    private Action actionCollapseAll;
    private Action actionExpandAll;

    @Override
    protected void createTabContent(Composite parent) {
        this.viewer = new TreeViewer(parent, 65538);
        Messages.get();
        this.addColumn(Messages.ComponentsTab_ColName, 200);
        Messages.get();
        this.addColumn(Messages.ComponentsTab_ColClass, 100);
        Messages.get();
        this.addColumn(Messages.ComponentsTab_ColDescription, 250);
        Messages.get();
        this.addColumn(Messages.ComponentsTab_ColModel, 150);
        Messages.get();
        this.addColumn(Messages.ComponentsTab_ColFirmware, 100);
        Messages.get();
        this.addColumn(Messages.ComponentsTab_ColSerial, 150);
        Messages.get();
        this.addColumn(Messages.ComponentsTab_ColVendor, 150);
        Messages.get();
        this.addColumn(Messages.ComponentsTab_ColInterface, 150);
        this.labelProvider = new ComponentTreeLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ComponentTreeContentProvider());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        WidgetHelper.restoreColumnSettings((Tree)this.viewer.getTree(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ComponentTree");
        this.viewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Tree)ComponentsTab.this.viewer.getTree(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ComponentTree");
            }
        });
        this.createActions();
        this.createPopupMenu();
    }

    private void addColumn(String name, int width) {
        TreeViewerColumn tc = new TreeViewerColumn(this.viewer, 16384);
        tc.getColumn().setText(name);
        tc.getColumn().setWidth(width);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ComponentsTab.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (this.getViewPart() != null) {
            this.getViewPart().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionCopyName);
        manager.add((IAction)this.actionCopyModel);
        manager.add((IAction)this.actionCopySerial);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCollapseAll);
        manager.add((IAction)this.actionExpandAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void createActions() {
        Messages.get();
        this.actionCopy = new Action(Messages.ComponentsTab_ActionCopy, SharedIcons.COPY){

            public void run() {
                ComponentsTab.this.copySelectionToClipboard(-1);
            }
        };
        Messages.get();
        this.actionCopyName = new Action(Messages.ComponentsTab_ActionCopyName){

            public void run() {
                ComponentsTab.this.copySelectionToClipboard(0);
            }
        };
        Messages.get();
        this.actionCopyModel = new Action(Messages.ComponentsTab_ActionCopyModel){

            public void run() {
                ComponentsTab.this.copySelectionToClipboard(3);
            }
        };
        Messages.get();
        this.actionCopySerial = new Action(Messages.ComponentsTab_ActionCopySerial){

            public void run() {
                ComponentsTab.this.copySelectionToClipboard(5);
            }
        };
        Messages.get();
        this.actionCollapseAll = new Action(Messages.ComponentsTab_ActionCollapseAll, SharedIcons.COLLAPSE_ALL){

            public void run() {
                ComponentsTab.this.viewer.collapseAll();
            }
        };
        Messages.get();
        this.actionExpandAll = new Action(Messages.ComponentsTab_ActionExpandAll, SharedIcons.EXPAND_ALL){

            public void run() {
                ComponentsTab.this.viewer.expandAll();
            }
        };
    }

    private void copySelectionToClipboard(int column) {
        TreeItem[] selection = this.viewer.getTree().getSelection();
        if (selection.length > 0) {
            String newLine = WidgetHelper.getNewLineCharacters();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < selection.length) {
                if (i > 0) {
                    sb.append(newLine);
                }
                if (column == -1) {
                    sb.append(selection[i].getText(0));
                    int j = 1;
                    while (j < this.viewer.getTree().getColumnCount()) {
                        sb.append("\t");
                        sb.append(selection[i].getText(j));
                        ++j;
                    }
                } else {
                    sb.append(selection[i].getText(column));
                }
                ++i;
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    @Override
    public void objectChanged(final AbstractObject object) {
        this.viewer.setInput((Object)new Object[0]);
        if (object == null) {
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.ComponentsTab_JobName, (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.objectview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    final PhysicalComponent root = session.getNodePhysicalComponents(object.getObjectId());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ComponentsTab.this.viewer.getTree().isDisposed()) {
                                return;
                            }
                            if (ComponentsTab.this.getObject() != null && ComponentsTab.this.getObject().getObjectId() == object.getObjectId()) {
                                ComponentsTab.this.labelProvider.setNode((AbstractNode)object);
                                ComponentsTab.this.viewer.setInput((Object)new Object[]{root});
                                ComponentsTab.this.viewer.expandAll();
                            }
                        }
                    });
                }
                catch (NXCException e) {
                    if (e.getErrorCode() != 96) {
                        throw e;
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ComponentsTab.this.viewer.getTree().isDisposed()) {
                                return;
                            }
                            if (ComponentsTab.this.getObject() != null && ComponentsTab.this.getObject().getObjectId() == object.getObjectId()) {
                                ComponentsTab.this.labelProvider.setNode(null);
                                ComponentsTab.this.viewer.setInput((Object)new Object[0]);
                            }
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ComponentsTab_JobError, object.getObjectName());
            }
        };
        job.setUser(false);
        job.start();
    }

    @Override
    public boolean showForObject(AbstractObject object) {
        if (object instanceof Node) {
            return (((Node)object).getCapabilities() & 0x8000) != 0;
        }
        return false;
    }
}

