/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.objects.Chassis;
import org.netxms.ui.eclipse.console.resources.ThemeEngine;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectview.widgets.ChassisWidget;
import org.netxms.ui.eclipse.objectview.widgets.helpers.ElementSelectionListener;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ChassisView
extends ViewPart
implements ISelectionProvider {
    public static final String ID = "org.netxms.ui.eclipse.objectview.views.ChassisView";
    private Composite chassisArea;
    private Chassis chassis;
    private ChassisWidget chassisFrontWidget;
    private ChassisWidget chassisRearWidget;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        NXCSession session = ConsoleSharedData.getSession();
        String[] parts = site.getSecondaryId().split("&");
        this.chassis = (Chassis)session.findObjectById(Long.parseLong(parts.length > 0 ? parts[0] : site.getSecondaryId()), Chassis.class);
        if (this.chassis == null) {
            throw new PartInitException("Chassis object not found");
        }
        this.setPartName(String.format("Chassis - %s", this.chassis.getObjectName()));
    }

    public void createPartControl(Composite parent) {
        this.chassisArea = new Composite(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                if (ChassisView.this.chassisFrontWidget == null || ChassisView.this.chassisRearWidget == null || wHint == -1) {
                    return super.computeSize(wHint, hHint, changed);
                }
                Point s = ChassisView.this.chassisFrontWidget.computeSize(wHint, hHint, changed);
                return new Point(s.x, s.y * 2);
            }
        };
        this.chassisFrontWidget = new ChassisWidget(this.chassisArea, 0, this.chassis, RackOrientation.FRONT, true);
        this.chassisRearWidget = new ChassisWidget(this.chassisArea, 0, this.chassis, RackOrientation.REAR, true);
        this.chassisArea.setBackground(ThemeEngine.getBackgroundColor((String)"Rack"));
        this.chassisArea.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (ChassisView.this.chassisFrontWidget == null || ChassisView.this.chassisRearWidget == null) {
                    return;
                }
                int width = ((ChassisView)ChassisView.this).chassisArea.getSize().x;
                int height = ((ChassisView)ChassisView.this).chassisArea.getSize().y;
                Point size = ChassisView.this.chassisFrontWidget.computeSize(width, height, true);
                ChassisView.this.chassisFrontWidget.setSize(size);
                ChassisView.this.chassisRearWidget.setSize(size);
                ChassisView.this.chassisRearWidget.setLocation(0, size.y);
            }
        });
        ElementSelectionListener listener = new ElementSelectionListener(){

            @Override
            public void objectSelected(Object object) {
                ChassisView.this.selection = (ISelection)(object != null ? new StructuredSelection(object) : new StructuredSelection());
                for (ISelectionChangedListener listener : ChassisView.this.selectionListeners) {
                    listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)ChassisView.this, ChassisView.this.selection));
                }
            }
        };
        this.chassisFrontWidget.addSelectionListener(listener);
        this.chassisRearWidget.addSelectionListener(listener);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.createPopupMenu();
    }

    public void setFocus() {
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ChassisView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.chassisFrontWidget);
        this.chassisFrontWidget.setMenu(menu);
        menu = menuMgr.createContextMenu((Control)this.chassisRearWidget);
        this.chassisRearWidget.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
    }

    private void fillContextMenu(IMenuManager manager) {
        ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)this.getSite(), (ISelectionProvider)this);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

