/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.internal.AlarmViewerConfig;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class AlarmViewer
extends PropertyPage {
    private static final String[] STATE_NAME = new String[]{"Outstanding", "Acknowledged", "Resolved"};
    private AlarmViewerConfig config;
    private ObjectSelector objectSelector;
    private LabeledText title;
    private Button[] checkSeverity;
    private Button[] checkState;
    private Button checkEnableLocalSound;

    protected Control createContents(Composite parent) {
        this.config = (AlarmViewerConfig)this.getElement().getAdapter(AlarmViewerConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.objectSelector.setLabel(Messages.AlarmViewer_RootObject);
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.objectSelector.setLayoutData((Object)gd);
        this.title = new LabeledText(dialogArea, 0);
        Messages.get();
        this.title.setLabel(Messages.AlarmViewer_Title);
        this.title.setText(this.config.getTitle());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.title.setLayoutData((Object)gd);
        Group severityGroup = new Group(dialogArea, 0);
        Messages.get();
        severityGroup.setText(Messages.AlarmViewer_SeverityFilter);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        severityGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 5;
        layout.makeColumnsEqualWidth = true;
        severityGroup.setLayout((Layout)layout);
        this.checkSeverity = new Button[5];
        int severity = 4;
        while (severity >= 0) {
            this.checkSeverity[severity] = new Button((Composite)severityGroup, 32);
            this.checkSeverity[severity].setText(StatusDisplayInfo.getStatusText((int)severity));
            this.checkSeverity[severity].setSelection((this.config.getSeverityFilter() & 1 << severity) != 0);
            --severity;
        }
        Group stateGroup = new Group(dialogArea, 0);
        stateGroup.setText("State Filter");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        stateGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        stateGroup.setLayout((Layout)layout);
        this.checkState = new Button[3];
        int i = 0;
        while (i < 3) {
            this.checkState[i] = new Button((Composite)stateGroup, 32);
            this.checkState[i].setText(STATE_NAME[i]);
            this.checkState[i].setSelection((this.config.getStateFilter() & 1 << i) != 0);
            ++i;
        }
        this.checkEnableLocalSound = new Button(dialogArea, 32);
        this.checkEnableLocalSound.setText("Play alarm sounds when active");
        this.checkEnableLocalSound.setSelection(this.config.getIsLocalSoundEnabled());
        return dialogArea;
    }

    public boolean performOk() {
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.config.setTitle(this.title.getText());
        int severityFilter = 0;
        int i = 0;
        while (i < this.checkSeverity.length) {
            if (this.checkSeverity[i].getSelection()) {
                severityFilter |= 1 << i;
            }
            ++i;
        }
        this.config.setSeverityFilter(severityFilter);
        int stateFilter = 0;
        int i2 = 0;
        while (i2 < this.checkState.length) {
            if (this.checkState[i2].getSelection()) {
                stateFilter |= 1 << i2;
            }
            ++i2;
        }
        this.config.setStateFilter(stateFilter);
        this.config.setIsLocalSoundEnabled(this.checkEnableLocalSound.getSelection());
        return true;
    }
}

