/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.widgets.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.snmp.SnmpTrapLogRecord;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.views.helpers.AbstractTraceViewFilter;

public class SnmpTrapMonitorFilter
extends AbstractTraceViewFilter {
    private NXCSession session = ConsoleSharedData.getSession();
    private long rootObjectId = 0L;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        AbstractObject object;
        SnmpTrapLogRecord record = (SnmpTrapLogRecord)element;
        if (!(this.rootObjectId == 0L || this.rootObjectId == record.getSourceNode() || (object = this.session.findObjectById(record.getSourceNode())) != null && object.isChildOf(this.rootObjectId))) {
            return false;
        }
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        if (record.getTrapObjectId().contains(this.filterString)) {
            return true;
        }
        if (record.getVarbinds().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (record.getSourceAddress().getHostAddress().contains(this.filterString)) {
            return true;
        }
        object = this.session.findObjectById(record.getSourceNode());
        if (object != null) {
            return object.getObjectName().toLowerCase().contains(this.filterString);
        }
        return false;
    }

    public void setRootObject(long rootObjectId) {
        this.rootObjectId = rootObjectId;
    }
}

