/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.widgets;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.TextOutputListener;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objects.ObjectContext;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.widgets.AbstractObjectToolExecutor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ServerScriptExecutor
extends AbstractObjectToolExecutor
implements TextOutputListener {
    private IOConsoleOutputStream out;
    private String script = null;
    private Map<String, String> inputValues = null;
    private long alarmId;
    private long nodeId;

    public ServerScriptExecutor(Composite resultArea, ViewPart viewPart, ObjectContext ctx, AbstractObjectToolExecutor.ActionSet actionSet, ObjectTool tool, Map<String, String> inputValues) {
        super(resultArea, viewPart, ctx, actionSet);
        this.script = tool.getData();
        this.alarmId = ctx.alarm != null ? ctx.alarm.getId() : 0L;
        this.nodeId = ctx.object.getObjectId();
        this.inputValues = inputValues;
    }

    @Override
    public void execute() {
        this.setRunning(true);
        final NXCSession session = ConsoleSharedData.getSession();
        this.out = this.console.newOutputStream();
        Messages.get();
        ConsoleJob job = new ConsoleJob(String.format(Messages.ObjectToolsDynamicMenu_ExecuteOnNode, session.getObjectName(this.nodeId)), null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_CannotExecuteOnNode, session.getObjectName(ServerScriptExecutor.this.nodeId));
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                try {
                    session.executeLibraryScript(ServerScriptExecutor.this.nodeId, ServerScriptExecutor.this.alarmId, ServerScriptExecutor.this.script, ServerScriptExecutor.this.inputValues, (TextOutputListener)ServerScriptExecutor.this);
                }
                finally {
                    if (ServerScriptExecutor.this.out != null) {
                        ServerScriptExecutor.this.out.close();
                        ServerScriptExecutor.this.out = null;
                    }
                }
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ServerScriptExecutor.this.setRunning(false);
                    }
                });
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    public void messageReceived(String text) {
        try {
            if (this.out != null) {
                this.out.write(text.replace("\r", ""));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void dispose() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.out = null;
        }
        super.dispose();
    }

    public void setStreamId(long streamId) {
    }

    public void onError() {
    }
}

