/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.actions;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerService;
import org.netxms.ui.eclipse.actions.ViewerProvider;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;

public class ExportToCsvAction
extends Action {
    private IViewPart viewPart;
    private ColumnViewer viewer;
    private ViewerProvider viewerProvider;
    private boolean selectionOnly;

    private ExportToCsvAction(IViewPart viewPart, ColumnViewer viewer, ViewerProvider viewerProvider, boolean selectionOnly) {
        String string;
        if (selectionOnly) {
            Messages.get();
            string = Messages.ExportToCsvAction_ExportToCsv;
        } else {
            Messages.get();
            string = Messages.ExportToCsvAction_ExportAllToCsv;
        }
        super(string, SharedIcons.CSV);
        this.setId(selectionOnly ? "org.netxms.ui.eclipse.popupActions.ExportToCSV" : "org.netxms.ui.eclipse.actions.ExportToCSV");
        this.viewPart = viewPart;
        this.viewer = viewer;
        this.viewerProvider = viewerProvider;
        this.selectionOnly = selectionOnly;
        if (viewPart == null || viewPart.getViewSite().getId().equals("org.netxms.ui.eclipse.objectview.view.tabbed_object_view")) {
            return;
        }
        IHandlerService handlerService = (IHandlerService)viewPart.getSite().getService(IHandlerService.class);
        this.setActionDefinitionId("org.netxms.ui.eclipse.library.commands.export_to_csv_" + (selectionOnly ? "selection" : "all"));
        handlerService.activateHandler(this.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this));
    }

    public ExportToCsvAction(IViewPart viewPart, ColumnViewer viewer, boolean selectionOnly) {
        this(viewPart, viewer, null, selectionOnly);
    }

    public ExportToCsvAction(IViewPart viewPart, ViewerProvider viewerProvider, boolean selectionOnly) {
        this(viewPart, null, viewerProvider, selectionOnly);
    }

    public void run() {
        FileDialog dlg = new FileDialog(this.viewPart.getSite().getShell(), 8192);
        dlg.setFilterExtensions(new String[]{"*.csv", "*.*"});
        dlg.setFilterNames(new String[]{"CSV files", "All files"});
        final String fileName = dlg.open();
        if (fileName == null) {
            return;
        }
        if (this.viewerProvider != null) {
            this.viewer = this.viewerProvider.getViewer();
        }
        final ArrayList<String[]> data = new ArrayList<String[]>();
        if (this.viewer instanceof TableViewer) {
            TableItem[] selection;
            int numColumns = ((TableViewer)this.viewer).getTable().getColumnCount();
            if (numColumns == 0) {
                numColumns = 1;
            }
            TableColumn[] columns = ((TableViewer)this.viewer).getTable().getColumns();
            String[] headerRow = new String[numColumns];
            int i = 0;
            while (i < numColumns) {
                headerRow[i] = columns[i].getText();
                ++i;
            }
            data.add(headerRow);
            TableItem[] tableItemArray = selection = this.selectionOnly ? ((TableViewer)this.viewer).getTable().getSelection() : ((TableViewer)this.viewer).getTable().getItems();
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                String[] row = new String[numColumns];
                int i2 = 0;
                while (i2 < numColumns) {
                    row[i2] = item.getText(i2);
                    ++i2;
                }
                data.add(row);
                ++n2;
            }
        } else if (this.viewer instanceof TreeViewer) {
            TreeItem[] selection;
            int numColumns = ((TreeViewer)this.viewer).getTree().getColumnCount();
            if (numColumns == 0) {
                numColumns = 1;
            }
            TreeItem[] treeItemArray = selection = this.selectionOnly ? ((TreeViewer)this.viewer).getTree().getSelection() : ((TreeViewer)this.viewer).getTree().getItems();
            int n = selection.length;
            int n3 = 0;
            while (n3 < n) {
                TreeItem item = treeItemArray[n3];
                String[] row = new String[numColumns];
                int i = 0;
                while (i < numColumns) {
                    row[i] = item.getText(i);
                    ++i;
                }
                data.add(row);
                if (!this.selectionOnly) {
                    this.addSubItems(item, data, numColumns);
                }
                ++n3;
            }
        }
        Messages.get();
        new ConsoleJob(String.format(Messages.ExportToCsvAction_SaveTo, fileName), (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.console", null){

            @Override
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8"));
                for (String[] row : data) {
                    int i = 0;
                    while (i < row.length) {
                        if (i > 0) {
                            out.write(44);
                        }
                        out.write(34);
                        out.write(row[i].replace("\"", "\"\""));
                        out.write(34);
                        ++i;
                    }
                    out.newLine();
                }
                out.close();
            }

            @Override
            protected String getErrorMessage() {
                Messages.get();
                return Messages.ExportToCsvAction_SaveError;
            }
        }.start();
    }

    private void addSubItems(TreeItem root, List<String[]> data, int numColumns) {
        TreeItem[] treeItemArray = root.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            String[] row = new String[numColumns];
            int i = 0;
            while (i < numColumns) {
                row[i] = item.getText(i);
                ++i;
            }
            data.add(row);
            this.addSubItems(item, data, numColumns);
            ++n2;
        }
    }
}

