/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.resources;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.resources.DefaultDarkTheme;
import org.netxms.ui.eclipse.console.resources.DefaultLightTheme;
import org.netxms.ui.eclipse.console.resources.Theme;
import org.netxms.ui.eclipse.console.resources.ThemeElement;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.FontCache;

public class ThemeEngine {
    private static final Map<Display, ThemeEngine> instances = new HashMap<Display, ThemeEngine>();
    private ColorCache colors = new ColorCache();
    private FontCache fonts = new FontCache();
    private Map<String, ThemeElement> elements = new HashMap<String, ThemeElement>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThemeEngine getInstance(Display display) {
        ThemeEngine instance;
        Map<Display, ThemeEngine> map = instances;
        synchronized (map) {
            instance = instances.get(display);
            if (instance == null) {
                instance = new ThemeEngine(display);
                instances.put(display, instance);
            }
        }
        return instance;
    }

    private ThemeEngine(final Display display) {
        display.addListener(12, new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event event) {
                Map map = instances;
                synchronized (map) {
                    instances.remove(display);
                }
                ThemeEngine.this.colors.dispose();
                ThemeEngine.this.fonts.dispose();
            }
        });
        this.reload(display);
    }

    public static RGB getBackgroundColorDefinition(String path) {
        ThemeEngine instance = ThemeEngine.getInstance(Display.getCurrent());
        for (ThemeElement e : instance.getElementChain(path)) {
            if (e.background == null) continue;
            return e.background;
        }
        return Display.getCurrent().getSystemColor(22).getRGB();
    }

    public static String getBackgroundColorDefinitionAsText(String path) {
        RGB rgb = ThemeEngine.getBackgroundColorDefinition(path);
        return String.valueOf(rgb.red) + "," + rgb.green + "," + rgb.blue;
    }

    public static Color getBackgroundColor(String path) {
        return ThemeEngine.getInstance((Display)Display.getCurrent()).colors.create(ThemeEngine.getBackgroundColorDefinition(path));
    }

    public static RGB getForegroundColorDefinition(String path) {
        ThemeEngine instance = ThemeEngine.getInstance(Display.getCurrent());
        for (ThemeElement e : instance.getElementChain(path)) {
            if (e.foreground == null) continue;
            return e.foreground;
        }
        return Display.getCurrent().getSystemColor(21).getRGB();
    }

    public static String getForegroundColorDefinitionAsText(String path) {
        RGB rgb = ThemeEngine.getForegroundColorDefinition(path);
        return String.valueOf(rgb.red) + "," + rgb.green + "," + rgb.blue;
    }

    public static Color getForegroundColor(String path) {
        return ThemeEngine.getInstance((Display)Display.getCurrent()).colors.create(ThemeEngine.getForegroundColorDefinition(path));
    }

    public static Font getFont(String path) {
        ThemeEngine instance = ThemeEngine.getInstance(Display.getCurrent());
        for (ThemeElement e : instance.getElementChain(path)) {
            if (e.fontName == null) continue;
            return instance.fonts.create(e.fontName, e.fontHeight);
        }
        return Display.getCurrent().getSystemFont();
    }

    public static File getThemeStorageDirectory() {
        File targetDir;
        Location loc = Platform.getInstanceLocation();
        try {
            targetDir = new File(loc.getURL().toURI());
        }
        catch (URISyntaxException e) {
            targetDir = new File(loc.getURL().getPath());
        }
        return new File(targetDir, "themes");
    }

    public static void saveTheme(Theme theme) throws Exception {
        File storage = ThemeEngine.getThemeStorageDirectory();
        if (!storage.exists()) {
            storage.mkdirs();
        }
        File file = new File(storage, String.valueOf(theme.getName()) + ".xml");
        theme.save(file);
    }

    public static boolean deleteTheme(String name) {
        return new File(ThemeEngine.getThemeStorageDirectory(), String.valueOf(name) + ".xml").delete();
    }

    public static void reload() {
        Display display = Display.getCurrent();
        ThemeEngine.getInstance(display).reload(display);
    }

    private void reload(Display display) {
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        String currentTheme = ps.getString("CurrentTheme");
        if (currentTheme == null || currentTheme.isEmpty() || currentTheme.equalsIgnoreCase("[automatic]")) {
            this.loadDefaultTheme(display);
        } else if (currentTheme.equalsIgnoreCase("Light [built-in]")) {
            this.loadTheme(new DefaultLightTheme());
        } else if (currentTheme.equalsIgnoreCase("Dark [built-in]")) {
            this.loadTheme(new DefaultDarkTheme());
        } else {
            boolean loaded = false;
            File base = ThemeEngine.getThemeStorageDirectory();
            if (base.isDirectory()) {
                File[] fileArray = base.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".xml");
                    }
                });
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    Activator.logInfo("Loading theme file " + f.getAbsolutePath());
                    try {
                        Theme t = Theme.load(f);
                        if (t.getName().equalsIgnoreCase(currentTheme)) {
                            Activator.logInfo("Applying theme " + t.getName());
                            boolean darkOSTheme = ColorConverter.isDarkColor(display.getSystemColor(22).getRGB());
                            t.setMissingElements(darkOSTheme ? new DefaultDarkTheme() : new DefaultLightTheme());
                            this.loadTheme(t);
                            loaded = true;
                            break;
                        }
                    }
                    catch (Exception e) {
                        Activator.logError("Error loading theme file " + f.getAbsolutePath(), e);
                    }
                    ++n2;
                }
            }
            if (!loaded) {
                this.loadDefaultTheme(display);
            }
        }
    }

    private List<ThemeElement> getElementChain(String path) {
        ArrayList<ThemeElement> chain = new ArrayList<ThemeElement>(16);
        while (!path.isEmpty()) {
            int index;
            ThemeElement e = this.elements.get(path);
            if (e != null) {
                chain.add(e);
            }
            String string = path = (index = path.lastIndexOf(46)) != -1 ? path.substring(0, index) : "";
        }
        chain.add(this.elements.get("."));
        return chain;
    }

    private void loadTheme(Theme theme) {
        this.elements.clear();
        this.elements.putAll(theme.elements);
    }

    private void loadDefaultTheme(Display display) {
        boolean darkOSTheme = ColorConverter.isDarkColor(display.getSystemColor(22).getRGB());
        this.loadTheme(darkOSTheme ? new DefaultDarkTheme() : new DefaultLightTheme());
    }
}

